/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtils {
    private static final Set<String> immutableTypes = new HashSet<String>(19);
    private static final Set<PsiType> primitiveNumericTypes = new HashSet<PsiType>(7);
    private static final Set<PsiType> integralTypes = new HashSet<PsiType>(5);

    private ClassUtils() {
    }

    @Nullable
    public static PsiClass findClass(@NonNls String fqClassName, PsiElement context) {
        return JavaPsiFacade.getInstance(context.getProject()).findClass(fqClassName, context.getResolveScope());
    }

    @Nullable
    public static PsiClass findObjectClass(PsiElement context) {
        return ClassUtils.findClass("java.lang.Object", context);
    }

    public static boolean isPrimitive(PsiType type2) {
        return TypeConversionUtil.isPrimitiveAndNotNull(type2);
    }

    public static boolean isIntegral(PsiType type2) {
        return integralTypes.contains(type2);
    }

    public static boolean isImmutable(PsiType type2) {
        if (TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return true;
        }
        PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (aClass2 == null) {
            return false;
        }
        if (immutableTypes.contains(aClass2.getQualifiedName())) {
            return true;
        }
        return JCiPUtil.isImmutable(aClass2);
    }

    public static boolean inSamePackage(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 == null || element2 == null) {
            return false;
        }
        PsiFile containingFile1 = element1.getContainingFile();
        if (!(containingFile1 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile1 = (PsiClassOwner)containingFile1;
        String packageName1 = containingJavaFile1.getPackageName();
        PsiFile containingFile2 = element2.getContainingFile();
        if (!(containingFile2 instanceof PsiClassOwner)) {
            return false;
        }
        PsiClassOwner containingJavaFile2 = (PsiClassOwner)containingFile2;
        String packageName2 = containingJavaFile2.getPackageName();
        return packageName1.equals(packageName2);
    }

    public static boolean isFieldVisible(@NotNull PsiField field, PsiClass fromClass) {
        PsiClass fieldClass;
        if (field == null) {
            ClassUtils.$$$reportNull$$$0(0);
        }
        if ((fieldClass = field.getContainingClass()) == null) {
            return false;
        }
        if (fieldClass.equals(fromClass)) {
            return true;
        }
        if (field.hasModifierProperty("private")) {
            return false;
        }
        if (field.hasModifierProperty("public") || field.hasModifierProperty("protected")) {
            return true;
        }
        return ClassUtils.inSamePackage(fieldClass, fromClass);
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveNumericType(@Nullable PsiType type2) {
        return primitiveNumericTypes.contains(type2);
    }

    public static boolean isInnerClass(PsiClass aClass2) {
        PsiClass parentClass = ClassUtils.getContainingClass(aClass2);
        return parentClass != null;
    }

    @Nullable
    public static PsiClass getContainingClass(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiClass.class);
    }

    public static PsiClass getOutermostContainingClass(PsiClass aClass2) {
        PsiClass containingClass;
        PsiClass outerClass2 = aClass2;
        while ((containingClass = ClassUtils.getContainingClass(outerClass2)) != null) {
            outerClass2 = containingClass;
        }
        return outerClass2;
    }

    @Nullable
    public static PsiClass getContainingStaticClass(PsiElement element) {
        PsiClass aClass2 = PsiTreeUtil.getParentOfType(element, PsiClass.class, false, PsiFile.class);
        while (ClassUtils.isNonStaticClass(aClass2)) {
            aClass2 = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class, true, PsiFile.class);
        }
        return aClass2;
    }

    public static boolean isNonStaticClass(@Nullable PsiClass aClass2) {
        if (aClass2 == null) {
            return false;
        }
        if (aClass2.hasModifierProperty("static") || aClass2.isInterface() || aClass2.isEnum()) {
            return false;
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            return true;
        }
        PsiElement parent2 = aClass2.getParent();
        if (parent2 == null || parent2 instanceof PsiFile) {
            return false;
        }
        if (!(parent2 instanceof PsiClass)) {
            return true;
        }
        PsiClass parentClass = (PsiClass)parent2;
        return !parentClass.isInterface();
    }

    @Nullable
    public static PsiClassInitializer getDoubleBraceInitializer(PsiAnonymousClass aClass2) {
        PsiClassInitializer[] initializers = aClass2.getInitializers();
        if (initializers.length != 1) {
            return null;
        }
        PsiClassInitializer initializer2 = initializers[0];
        if (initializer2.hasModifierProperty("static")) {
            return null;
        }
        if (aClass2.getFields().length != 0 || aClass2.getMethods().length != 0 || aClass2.getInnerClasses().length != 0) {
            return null;
        }
        if (aClass2.getBaseClassReference().resolve() == null) {
            return null;
        }
        return initializer2;
    }

    public static boolean isFinalClassWithDefaultEquals(@Nullable PsiClass aClass2) {
        PsiMethod[] methods2;
        if (aClass2 == null) {
            return false;
        }
        if (!aClass2.hasModifierProperty("final") || !ClassUtils.hasOnlyPrivateConstructors(aClass2)) {
            return false;
        }
        for (PsiMethod method : methods2 = aClass2.findMethodsByName("equals", true)) {
            PsiClass containingClass;
            if (!MethodUtils.isEquals(method) || (containingClass = method.getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyPrivateConstructors(PsiClass aClass2) {
        if (aClass2 == null) {
            return false;
        }
        PsiMethod[] constructors2 = aClass2.getConstructors();
        if (constructors2.length == 0) {
            return false;
        }
        for (PsiMethod constructor : constructors2) {
            if (constructor.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    static {
        integralTypes.add(PsiType.LONG);
        integralTypes.add(PsiType.INT);
        integralTypes.add(PsiType.SHORT);
        integralTypes.add(PsiType.CHAR);
        integralTypes.add(PsiType.BYTE);
        primitiveNumericTypes.add(PsiType.BYTE);
        primitiveNumericTypes.add(PsiType.CHAR);
        primitiveNumericTypes.add(PsiType.SHORT);
        primitiveNumericTypes.add(PsiType.INT);
        primitiveNumericTypes.add(PsiType.LONG);
        primitiveNumericTypes.add(PsiType.FLOAT);
        primitiveNumericTypes.add(PsiType.DOUBLE);
        immutableTypes.add("java.lang.Boolean");
        immutableTypes.add("java.lang.Character");
        immutableTypes.add("java.lang.Short");
        immutableTypes.add("java.lang.Integer");
        immutableTypes.add("java.lang.Long");
        immutableTypes.add("java.lang.Float");
        immutableTypes.add("java.lang.Double");
        immutableTypes.add("java.lang.Byte");
        immutableTypes.add("java.lang.String");
        immutableTypes.add("java.awt.Font");
        immutableTypes.add("java.awt.BasicStroke");
        immutableTypes.add("java.awt.Color");
        immutableTypes.add("java.awt.Cursor");
        immutableTypes.add("java.math.BigDecimal");
        immutableTypes.add("java.math.BigInteger");
        immutableTypes.add("java.math.MathContext");
        immutableTypes.add("java.nio.channels.FileLock");
        immutableTypes.add("java.nio.charset.Charset");
        immutableTypes.add("java.io.File");
        immutableTypes.add("java.net.Inet4Address");
        immutableTypes.add("java.net.Inet6Address");
        immutableTypes.add("java.net.InetSocketAddress");
        immutableTypes.add("java.net.URI");
        immutableTypes.add("java.net.URL");
        immutableTypes.add("java.util.Locale");
        immutableTypes.add("java.util.UUID");
        immutableTypes.add("java.util.regex.Pattern");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/psiutils/ClassUtils", "isFieldVisible"));
    }
}

