/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneUtils {
    private CloneUtils() {
    }

    public static boolean isCloneable(@Nullable PsiClass aClass2) {
        return InheritanceUtil.isInheritor(aClass2, "java.lang.Cloneable");
    }

    public static boolean isDirectlyCloneable(@NotNull PsiClass aClass2) {
        PsiClass[] interfaces;
        if (aClass2 == null) {
            CloneUtils.$$$reportNull$$$0(0);
        }
        for (PsiClass anInterface : interfaces = aClass2.getInterfaces()) {
            String qualifiedName2;
            if (anInterface == null || !"java.lang.Cloneable".equals(qualifiedName2 = anInterface.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClone(@Nullable PsiMethod method) {
        PsiClassType javaLangObject;
        if (method == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(method)) {
            javaLangObject = TypeUtils.getObjectType(method);
        } else {
            if (method.getReturnType() instanceof PsiPrimitiveType) {
                return false;
            }
            javaLangObject = null;
        }
        return MethodUtils.methodMatches(method, null, (PsiType)javaLangObject, "clone", PsiType.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/CloneUtils", "isDirectlyCloneable"));
    }
}

