/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class ConstructionUtils {
    private static final Set<String> GUAVA_UTILITY_CLASSES = ContainerUtil.set("com.google.common.collect.Maps", "com.google.common.collect.Lists", "com.google.common.collect.Sets");
    private static final CallMatcher ENUM_SET_NONE_OF = CallMatcher.staticCall("java.util.EnumSet", "noneOf").parameterCount(1);

    @Contract(value="null -> false")
    public static boolean isEmptyStringBuilderInitializer(PsiExpression initializer2) {
        return "\"\"".equals(ConstructionUtils.getStringBuilderInitializerText(initializer2));
    }

    @Contract(value="null -> null")
    public static String getStringBuilderInitializerText(PsiExpression construction) {
        if (!((construction = PsiUtil.skipParenthesizedExprDown(construction)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)construction;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (classReference == null) {
            return null;
        }
        PsiElement target = classReference.resolve();
        if (!(target instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass2 = (PsiClass)target;
        String qualifiedName2 = aClass2.getQualifiedName();
        if (!"java.lang.StringBuilder".equals(qualifiedName2) && !"java.lang.StringBuffer".equals(qualifiedName2)) {
            return null;
        }
        PsiExpressionList argumentList2 = newExpression.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        if (arguments2.length == 0) {
            return "\"\"";
        }
        if (arguments2.length != 1) {
            return null;
        }
        PsiExpression argument = arguments2[0];
        PsiType argumentType = argument.getType();
        if (PsiType.INT.equals(argumentType)) {
            return "\"\"";
        }
        return argument.getText();
    }

    @Contract(value="null -> false")
    public static boolean isEmptyCollectionInitializer(PsiExpression expression2) {
        PsiExpressionList argumentList2;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiNewExpression && (argumentList2 = ((PsiNewExpression)expression2).getArgumentList()) != null && argumentList2.getExpressions().length == 0) {
            PsiType type2 = expression2.getType();
            return InheritanceUtil.isInheritor(type2, "java.util.Collection") || InheritanceUtil.isInheritor(type2, "java.util.Map");
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            String qualifiedName2;
            PsiClass aClass2;
            PsiMethod method;
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2;
            String name = call2.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList3 = call2.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList3.getExpressions().length == 0 && (method = call2.resolveMethod()) != null && method.getParameterList().getParametersCount() == 0 && (aClass2 = method.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName2 = aClass2.getQualifiedName())) {
                return true;
            }
        }
        return ConstructionUtils.isCustomizedEmptyCollectionInitializer(expression2);
    }

    @Contract(value="null -> false")
    public static boolean isCustomizedEmptyCollectionInitializer(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiNewExpression) {
            PsiExpressionList argumentList2 = ((PsiNewExpression)expression2).getArgumentList();
            if (argumentList2 == null || argumentList2.getExpressions().length == 0) {
                return false;
            }
            PsiMethod constructor = ((PsiNewExpression)expression2).resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass2 = constructor.getContainingClass();
            if (!(aClass2 == null || aClass2.getQualifiedName() != null && aClass2.getQualifiedName().startsWith("java.util."))) {
                return false;
            }
            if (!InheritanceUtil.isInheritor(aClass2, "java.util.Collection") && !InheritanceUtil.isInheritor(aClass2, "java.util.Map")) {
                return false;
            }
            Predicate<PsiType> allowedParameterType = t -> t instanceof PsiPrimitiveType || InheritanceUtil.isInheritor(t, "java.lang.Class");
            return Stream.of(constructor.getParameterList().getParameters()).map(PsiParameter::getType).allMatch(allowedParameterType);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            String qualifiedName2;
            PsiClass aClass3;
            PsiMethod method;
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2;
            if (ENUM_SET_NONE_OF.test(call2)) {
                return true;
            }
            String name = call2.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList3 = call2.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList3.getExpressions().length > 0 && (method = call2.resolveMethod()) != null && method.getParameterList().getParametersCount() > 0 && (aClass3 = method.getContainingClass()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName2 = aClass3.getQualifiedName())) {
                return Stream.of(method.getParameterList().getParameters()).allMatch(p2 -> p2.getType() instanceof PsiPrimitiveType);
            }
        }
        return false;
    }

    public static boolean isEmptyArrayInitializer(@Nullable PsiExpression expression2) {
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression2;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }
}

