/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtils {
    private ControlFlowUtils() {
    }

    public static boolean isElseIf(PsiIfStatement ifStatement) {
        PsiElement parent2 = ifStatement.getParent();
        if (parent2 instanceof PsiCodeBlock && ((PsiCodeBlock)parent2).getStatements().length == 1 && parent2.getParent() instanceof PsiBlockStatement) {
            parent2 = parent2.getParent().getParent();
        }
        if (!(parent2 instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement parentStatement = (PsiIfStatement)parent2;
        PsiStatement elseBranch = parentStatement.getElseBranch();
        return ifStatement.equals(elseBranch);
    }

    public static boolean statementMayCompleteNormally(@Nullable PsiStatement statement2) {
        if (statement2 == null) {
            return true;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiThrowStatement) {
            return false;
        }
        if (statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiForeachStatement) {
            return true;
        }
        if (statement2 instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression2 = expressionStatement.getExpression();
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return true;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return true;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return true;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return true;
            }
            String className2 = aClass2.getQualifiedName();
            return !"java.lang.System".equals(className2);
        }
        if (statement2 instanceof PsiForStatement) {
            return ControlFlowUtils.forStatementMayCompleteNormally((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ControlFlowUtils.whileStatementMayCompleteNormally((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ControlFlowUtils.doWhileStatementMayCompleteNormally((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiCodeBlock body2 = ((PsiSynchronizedStatement)statement2).getBody();
            return ControlFlowUtils.codeBlockMayCompleteNormally(body2);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)statement2).getCodeBlock();
            return ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            return ControlFlowUtils.labeledStatementMayCompleteNormally((PsiLabeledStatement)statement2);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ControlFlowUtils.ifStatementMayCompleteNormally((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ControlFlowUtils.tryStatementMayCompleteNormally((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return ControlFlowUtils.switchStatementMayCompleteNormally((PsiSwitchStatement)statement2);
        }
        if (statement2 instanceof PsiTemplateStatement || statement2 instanceof PsiClassLevelDeclarationStatement) {
            return true;
        }
        assert (false) : "unknown statement type: " + statement2.getClass();
        return true;
    }

    private static boolean doWhileStatementMayCompleteNormally(@NotNull PsiDoWhileStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(0);
        }
        PsiExpression condition = loopStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement body2 = loopStatement.getBody();
        return ControlFlowUtils.statementMayCompleteNormally(body2) && value != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget(loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor(loopStatement);
    }

    private static boolean whileStatementMayCompleteNormally(@NotNull PsiWhileStatement loopStatement) {
        PsiExpression condition;
        Object value;
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(1);
        }
        return (value = ExpressionUtils.computeConstantExpression(condition = loopStatement.getCondition())) != Boolean.TRUE || ControlFlowUtils.statementIsBreakTarget(loopStatement) || ControlFlowUtils.statementContainsContinueToAncestor(loopStatement);
    }

    private static boolean forStatementMayCompleteNormally(@NotNull PsiForStatement loopStatement) {
        if (loopStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(2);
        }
        if (ControlFlowUtils.statementIsBreakTarget(loopStatement)) {
            return true;
        }
        if (ControlFlowUtils.statementContainsContinueToAncestor(loopStatement)) {
            return true;
        }
        PsiExpression condition = loopStatement.getCondition();
        if (condition == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return Boolean.TRUE != value;
    }

    private static boolean switchStatementMayCompleteNormally(@NotNull PsiSwitchStatement switchStatement) {
        if (switchStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(3);
        }
        if (ControlFlowUtils.statementIsBreakTarget(switchStatement)) {
            return true;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return true;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return true;
        }
        int numCases = 0;
        boolean hasDefaultCase = false;
        for (PsiStatement statement2 : statements) {
            PsiBreakStatement breakStatement;
            if (statement2 instanceof PsiSwitchLabelStatement) {
                ++numCases;
                PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)statement2;
                if (switchLabelStatement.isDefaultCase()) {
                    hasDefaultCase = true;
                }
            }
            if (!(statement2 instanceof PsiBreakStatement) || (breakStatement = (PsiBreakStatement)statement2).getLabelIdentifier() != null) continue;
            return true;
        }
        boolean isEnum = ControlFlowUtils.isEnumSwitch(switchStatement);
        if (!hasDefaultCase && !isEnum) {
            return true;
        }
        if (!hasDefaultCase) {
            PsiExpression expression2 = switchStatement.getExpression();
            if (expression2 == null) {
                return true;
            }
            PsiClassType type2 = (PsiClassType)expression2.getType();
            if (type2 == null) {
                return true;
            }
            PsiClass aClass2 = type2.resolve();
            if (aClass2 == null) {
                return true;
            }
            if (!ControlFlowUtils.hasChildrenOfTypeCount(aClass2, numCases, PsiEnumConstant.class)) {
                return true;
            }
        }
        return ControlFlowUtils.statementMayCompleteNormally(statements[statements.length - 1]);
    }

    private static boolean isEnumSwitch(PsiSwitchStatement statement2) {
        PsiExpression expression2 = statement2.getExpression();
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        if (type2 == null) {
            return false;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClass aClass2 = ((PsiClassType)type2).resolve();
        return aClass2 != null && aClass2.isEnum();
    }

    private static boolean tryStatementMayCompleteNormally(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock[] catchBlocks;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(4);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && !ControlFlowUtils.codeBlockMayCompleteNormally(finallyBlock)) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (ControlFlowUtils.codeBlockMayCompleteNormally(tryBlock)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : catchBlocks = tryStatement.getCatchBlocks()) {
            if (!ControlFlowUtils.codeBlockMayCompleteNormally(catchBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayCompleteNormally(@NotNull PsiIfStatement ifStatement) {
        PsiStatement branch2;
        PsiStatement branch1;
        if (ifStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(5);
        }
        PsiExpression condition = ifStatement.getCondition();
        Object value = ExpressionUtils.computeConstantExpression(condition);
        PsiStatement thenBranch = ifStatement.getThenBranch();
        if (value == Boolean.TRUE) {
            return ControlFlowUtils.statementMayCompleteNormally(thenBranch);
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (value == Boolean.FALSE) {
            return ControlFlowUtils.statementMayCompleteNormally(elseBranch);
        }
        if ((thenBranch == null ? 0 : thenBranch.getTextLength()) < (elseBranch == null ? 0 : elseBranch.getTextLength())) {
            branch1 = thenBranch;
            branch2 = elseBranch;
        } else {
            branch2 = thenBranch;
            branch1 = elseBranch;
        }
        return ControlFlowUtils.statementMayCompleteNormally(branch1) || ControlFlowUtils.statementMayCompleteNormally(branch2);
    }

    private static boolean labeledStatementMayCompleteNormally(@NotNull PsiLabeledStatement labeledStatement) {
        PsiStatement statement2;
        if (labeledStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(6);
        }
        if ((statement2 = labeledStatement.getStatement()) == null) {
            return false;
        }
        return ControlFlowUtils.statementMayCompleteNormally(statement2) || ControlFlowUtils.statementIsBreakTarget(statement2);
    }

    public static boolean codeBlockMayCompleteNormally(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return true;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement2)) continue;
            return false;
        }
        return true;
    }

    private static boolean statementIsBreakTarget(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(7);
        }
        BreakFinder breakFinder = new BreakFinder(statement2);
        statement2.accept(breakFinder);
        return breakFinder.breakFound();
    }

    private static boolean statementContainsContinueToAncestor(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(8);
        }
        PsiElement parent2 = statement2.getParent();
        while (parent2 instanceof PsiLabeledStatement) {
            statement2 = (PsiStatement)parent2;
            parent2 = parent2.getParent();
        }
        ContinueToAncestorFinder continueToAncestorFinder = new ContinueToAncestorFinder(statement2);
        statement2.accept(continueToAncestorFinder);
        return continueToAncestorFinder.continueToAncestorFound();
    }

    public static boolean containsReturn(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(9);
        }
        ReturnFinder returnFinder = new ReturnFinder();
        element.accept(returnFinder);
        return returnFinder.returnFound();
    }

    public static boolean statementIsContinueTarget(@NotNull PsiStatement statement2) {
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(10);
        }
        ContinueFinder continueFinder = new ContinueFinder(statement2);
        statement2.accept(continueFinder);
        return continueFinder.continueFound();
    }

    public static boolean containsSystemExit(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(11);
        }
        SystemExitFinder systemExitFinder = new SystemExitFinder();
        element.accept(systemExitFinder);
        return systemExitFinder.exitFound();
    }

    public static boolean elementContainsCallToMethod(PsiElement context, String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        MethodCallFinder methodCallFinder = new MethodCallFinder(containingClassName, returnType, methodName, parameterTypes);
        context.accept(methodCallFinder);
        return methodCallFinder.containsCallToMethod();
    }

    public static boolean isInLoop(@NotNull PsiElement element) {
        PsiLoopStatement loopStatement;
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(12);
        }
        if ((loopStatement = PsiTreeUtil.getParentOfType(element, PsiLoopStatement.class, true, PsiClass.class)) == null) {
            return false;
        }
        PsiStatement body2 = loopStatement.getBody();
        return body2 != null && PsiTreeUtil.isAncestor(body2, element, true);
    }

    public static boolean isInFinallyBlock(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(13);
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = PsiTreeUtil.getParentOfType(currentElement, PsiTryStatement.class, true, PsiClass.class, PsiLambdaExpression.class)) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null && PsiTreeUtil.isAncestor(finallyBlock, currentElement, true)) {
                PsiMethod elementMethod = PsiTreeUtil.getParentOfType(currentElement, PsiMethod.class);
                PsiMethod finallyMethod = PsiTreeUtil.getParentOfType((PsiElement)finallyBlock, PsiMethod.class);
                return elementMethod != null && elementMethod.equals(finallyMethod);
            }
            currentElement = tryStatement;
        }
        return false;
    }

    public static boolean isInCatchBlock(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtils.$$$reportNull$$$0(14);
        }
        return PsiTreeUtil.getParentOfType(element, PsiCatchSection.class, true, PsiClass.class) != null;
    }

    public static boolean isInExitStatement(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(15);
        }
        return ControlFlowUtils.isInReturnStatementArgument(expression2) || ControlFlowUtils.isInThrowStatementArgument(expression2);
    }

    private static boolean isInReturnStatementArgument(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(16);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiReturnStatement.class) != null;
    }

    public static boolean isInThrowStatementArgument(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiThrowStatement.class) != null;
    }

    @Nullable
    public static PsiStatement stripBraces(@Nullable PsiStatement statement2) {
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement block = (PsiBlockStatement)statement2;
            PsiStatement onlyStatement = ControlFlowUtils.getOnlyStatementInBlock(block.getCodeBlock());
            return onlyStatement != null ? onlyStatement : block;
        }
        return statement2;
    }

    @NotNull
    public static PsiStatement[] unwrapBlock(@Nullable PsiStatement statement2) {
        PsiStatement[] psiStatementArray;
        PsiBlockStatement block = ObjectUtils.tryCast(statement2, PsiBlockStatement.class);
        if (block != null) {
            PsiStatement[] psiStatementArray2 = block.getCodeBlock().getStatements();
            if (psiStatementArray2 == null) {
                ControlFlowUtils.$$$reportNull$$$0(18);
            }
            return psiStatementArray2;
        }
        if (statement2 == null) {
            psiStatementArray = PsiStatement.EMPTY_ARRAY;
        } else {
            PsiStatement[] psiStatementArray3 = new PsiStatement[1];
            psiStatementArray = psiStatementArray3;
            psiStatementArray3[0] = statement2;
        }
        if (psiStatementArray == null) {
            ControlFlowUtils.$$$reportNull$$$0(19);
        }
        return psiStatementArray;
    }

    public static boolean statementCompletesWithStatement(@NotNull PsiStatement containingStatement, @NotNull PsiStatement statement2) {
        if (containingStatement == null) {
            ControlFlowUtils.$$$reportNull$$$0(20);
        }
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(21);
        }
        PsiElement statementToCheck = statement2;
        while (!statementToCheck.equals(containingStatement)) {
            PsiElement container2 = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container2 == null) {
                return false;
            }
            if (container2 instanceof PsiCodeBlock && !ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container2, statementToCheck)) {
                return false;
            }
            if (container2 instanceof PsiLoopStatement) {
                return false;
            }
            statementToCheck = container2;
        }
        return true;
    }

    public static boolean blockCompletesWithStatement(@NotNull PsiCodeBlock body2, @NotNull PsiStatement statement2) {
        if (body2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(22);
        }
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(23);
        }
        PsiElement statementToCheck = statement2;
        while (statementToCheck != null) {
            PsiElement container2 = ControlFlowUtils.getContainingStatementOrBlock(statementToCheck);
            if (container2 == null) {
                return false;
            }
            if (container2 instanceof PsiLoopStatement) {
                return false;
            }
            if (container2 instanceof PsiCodeBlock) {
                if (!ControlFlowUtils.statementIsLastInBlock((PsiCodeBlock)container2, statementToCheck)) {
                    return false;
                }
                if (container2.equals(body2)) {
                    return true;
                }
                statementToCheck = PsiTreeUtil.getParentOfType(container2, PsiStatement.class);
                continue;
            }
            statementToCheck = container2;
        }
        return false;
    }

    @Nullable
    private static PsiElement getContainingStatementOrBlock(@NotNull PsiElement statement2) {
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(24);
        }
        return PsiTreeUtil.getParentOfType(statement2, PsiStatement.class, PsiCodeBlock.class);
    }

    private static boolean statementIsLastInBlock(@NotNull PsiCodeBlock block, @NotNull PsiStatement statement2) {
        if (block == null) {
            ControlFlowUtils.$$$reportNull$$$0(25);
        }
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(26);
        }
        for (PsiElement child = block.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof PsiStatement)) continue;
            PsiStatement childStatement = (PsiStatement)child;
            if (statement2.equals(childStatement)) {
                return true;
            }
            if (statement2 instanceof PsiEmptyStatement) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public static PsiStatement getFirstStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return PsiTreeUtil.getChildOfType(codeBlock, PsiStatement.class);
    }

    @Nullable
    public static PsiStatement getLastStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getLastChildOfType(codeBlock, PsiStatement.class);
    }

    private static <T extends PsiElement> T getLastChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(27);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!aClass2.isInstance(child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static PsiStatement getOnlyStatementInBlock(@Nullable PsiCodeBlock codeBlock) {
        return ControlFlowUtils.getOnlyChildOfType(codeBlock, PsiStatement.class);
    }

    static <T extends PsiElement> T getOnlyChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(28);
        }
        if (element == null) {
            return null;
        }
        PsiElement result2 = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child)) continue;
            if (result2 == null) {
                result2 = child;
                continue;
            }
            return null;
        }
        return (T)result2;
    }

    public static boolean hasStatementCount(@Nullable PsiCodeBlock codeBlock, int count2) {
        return ControlFlowUtils.hasChildrenOfTypeCount(codeBlock, count2, PsiStatement.class);
    }

    public static <T extends PsiElement> boolean hasChildrenOfTypeCount(@Nullable PsiElement element, int count2, @NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(29);
        }
        if (element == null) {
            return false;
        }
        int i2 = 0;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!aClass2.isInstance(child) || ++i2 <= count2) continue;
            return false;
        }
        return i2 == count2;
    }

    public static boolean isEmptyCodeBlock(PsiCodeBlock codeBlock) {
        return ControlFlowUtils.hasStatementCount(codeBlock, 0);
    }

    public static boolean methodAlwaysThrowsException(@NotNull PsiMethod method) {
        PsiCodeBlock body2;
        if (method == null) {
            ControlFlowUtils.$$$reportNull$$$0(30);
        }
        if ((body2 = method.getBody()) == null) {
            return true;
        }
        return !ControlFlowUtils.containsReturn(body2) && !ControlFlowUtils.codeBlockMayCompleteNormally(body2);
    }

    public static boolean lambdaExpressionAlwaysThrowsException(PsiLambdaExpression expression2) {
        PsiElement body2 = expression2.getBody();
        if (body2 instanceof PsiExpression) {
            return false;
        }
        if (!(body2 instanceof PsiCodeBlock)) {
            return true;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)body2;
        return !ControlFlowUtils.containsReturn(codeBlock) && !ControlFlowUtils.codeBlockMayCompleteNormally(codeBlock);
    }

    public static boolean statementContainsNakedBreak(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        NakedBreakFinder breakFinder = new NakedBreakFinder();
        statement2.accept(breakFinder);
        return breakFinder.breakFound();
    }

    @Contract(value="null, _ -> false")
    public static boolean statementBreaksLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (statement2 instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)statement2).findExitedStatement() == loop;
        }
        if (statement2 instanceof PsiReturnStatement) {
            PsiElement nextElement;
            PsiExpression returnValue = ((PsiReturnStatement)statement2).getReturnValue();
            PsiElement cur = loop;
            PsiElement parent2 = cur.getParent();
            while (true) {
                if (parent2 instanceof PsiLabeledStatement) {
                    cur = parent2;
                } else if (parent2 instanceof PsiCodeBlock) {
                    PsiCodeBlock block = (PsiCodeBlock)parent2;
                    PsiStatement[] statements = block.getStatements();
                    if (!(block.getParent() instanceof PsiBlockStatement) || statements.length <= 0 || statements[statements.length - 1] != cur) break;
                    cur = block.getParent();
                } else {
                    if (!(parent2 instanceof PsiIfStatement) || cur != ((PsiIfStatement)parent2).getThenBranch() && cur != ((PsiIfStatement)parent2).getElseBranch()) break;
                    cur = parent2;
                }
                parent2 = cur.getParent();
            }
            if ((nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward(cur)) instanceof PsiReturnStatement) {
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(returnValue, ((PsiReturnStatement)nextElement).getReturnValue());
            }
            if (returnValue == null && cur.getParent() instanceof PsiCodeBlock && cur.getParent().getParent() instanceof PsiMethod && nextElement instanceof PsiJavaToken && ((PsiJavaToken)nextElement).getTokenType().equals(JavaTokenType.RBRACE)) {
                return true;
            }
        }
        return false;
    }

    private static StreamEx<PsiExpression> conditions(PsiElement element) {
        return ((AbstractStreamEx)StreamEx.iterate((Object)element, e -> e != null && !(e instanceof PsiLambdaExpression) && !(e instanceof PsiMethod), PsiElement::getParent).pairMap((child, parent2) -> parent2 instanceof PsiIfStatement && ((PsiIfStatement)parent2).getThenBranch() == child ? parent2 : null).select(PsiIfStatement.class).map(PsiIfStatement::getCondition)).flatMap(cond -> cond instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)cond).getOperationTokenType().equals(JavaTokenType.ANDAND) ? StreamEx.of((Object[])((PsiPolyadicExpression)cond).getOperands()) : StreamEx.of((Object)cond));
    }

    public static boolean isExecutedOnceInLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (ControlFlowUtils.flowBreaksLoop(statement2, loop)) {
            return true;
        }
        if (loop instanceof PsiForStatement) {
            boolean notWritten;
            boolean hasLoopVarCheck;
            PsiLocalVariable variable2;
            PsiDeclarationStatement initialization = ObjectUtils.tryCast(((PsiForStatement)loop).getInitialization(), PsiDeclarationStatement.class);
            PsiStatement update = ((PsiForStatement)loop).getUpdate();
            if (initialization != null && update != null && (variable2 = (PsiLocalVariable)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiLocalVariable.class).findFirst(var -> VariableAccessUtils.variableIsIncremented(var, update) || VariableAccessUtils.variableIsDecremented(var, update)).orElse(null)) != null && (hasLoopVarCheck = ((StreamEx)ControlFlowUtils.conditions(statement2).select(PsiBinaryExpression.class).filter(binOp -> binOp.getOperationTokenType().equals(JavaTokenType.EQEQ))).anyMatch(binOp -> ExpressionUtils.getOtherOperand(binOp, variable2) != null)) && (notWritten = ReferencesSearch.search(variable2).forEach(ref -> {
                PsiExpression expression2 = ObjectUtils.tryCast(ref.getElement(), PsiExpression.class);
                return expression2 == null || PsiTreeUtil.isAncestor(update, expression2, false) || !PsiUtil.isAccessedForWriting(expression2);
            }))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isVariableReassigned(PsiStatement statement2, PsiVariable variable2) {
        PsiStatement sibling = ControlFlowUtils.nextExecutedStatement(statement2);
        while (sibling != null) {
            PsiExpression rValue = ExpressionUtils.getAssignmentTo(sibling, variable2);
            if (rValue != null && !VariableAccessUtils.variableIsUsed(variable2, rValue)) {
                return true;
            }
            if (VariableAccessUtils.variableIsUsed(variable2, sibling)) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean flowBreaksLoop(PsiStatement statement2, PsiLoopStatement loop) {
        if (statement2 == null || statement2 == loop) {
            return false;
        }
        PsiStatement sibling = statement2;
        while (sibling != null) {
            if (sibling instanceof PsiContinueStatement) {
                return false;
            }
            if (sibling instanceof PsiThrowStatement || sibling instanceof PsiReturnStatement) {
                return true;
            }
            if (sibling instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)sibling;
                PsiStatement exitedStatement = breakStatement.findExitedStatement();
                if (exitedStatement == loop) {
                    return true;
                }
                return ControlFlowUtils.flowBreaksLoop(ControlFlowUtils.nextExecutedStatement(exitedStatement), loop);
            }
            if ((sibling instanceof PsiIfStatement || sibling instanceof PsiSwitchStatement) && !PsiTreeUtil.collectElementsOfType(sibling, PsiContinueStatement.class).isEmpty()) {
                return false;
            }
            if (sibling instanceof PsiLoopStatement && PsiTreeUtil.collectElements(sibling, e -> e instanceof PsiContinueStatement && ((PsiContinueStatement)e).getLabelIdentifier() != null).length > 0) {
                return false;
            }
            sibling = ControlFlowUtils.nextExecutedStatement(sibling);
        }
        return false;
    }

    @Nullable
    private static PsiStatement firstStatement(@Nullable PsiStatement statement2) {
        PsiStatement[] statements;
        while (statement2 instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)statement2).getCodeBlock().getStatements()).length != 0) {
            statement2 = statements[0];
        }
        return statement2;
    }

    @Nullable
    private static PsiStatement nextExecutedStatement(PsiStatement statement2) {
        PsiStatement next = ControlFlowUtils.firstStatement(PsiTreeUtil.getNextSiblingOfType(statement2, PsiStatement.class));
        if (next == null) {
            PsiElement parent2 = statement2.getParent();
            if (parent2 instanceof PsiCodeBlock) {
                PsiElement gParent = parent2.getParent();
                if (gParent instanceof PsiBlockStatement || gParent instanceof PsiSwitchStatement) {
                    return ControlFlowUtils.nextExecutedStatement((PsiStatement)gParent);
                }
            } else if (parent2 instanceof PsiLabeledStatement || parent2 instanceof PsiIfStatement || parent2 instanceof PsiSwitchLabelStatement || parent2 instanceof PsiSwitchStatement) {
                return ControlFlowUtils.nextExecutedStatement((PsiStatement)parent2);
            }
        }
        return next;
    }

    private static boolean isVariableReferencedBeforeLoopEntry(ControlFlow flow, int start, PsiStatement loop, PsiVariable variable2) {
        int loopStart = flow.getStartOffset(loop);
        int loopEnd = flow.getEndOffset(loop);
        if (start == loopStart) {
            return false;
        }
        List<ControlFlowUtil.ControlFlowEdge> edges = ControlFlowUtil.getEdges(flow, start);
        Collections.reverse(edges);
        BitSet referenced = new BitSet();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ControlFlowUtil.ControlFlowEdge edge : edges) {
                int from = edge.myFrom;
                int to = edge.myTo;
                if (referenced.get(from)) {
                    if (to == loopStart && (from < loopStart || from >= loopEnd)) {
                        return true;
                    }
                    if (referenced.get(to)) continue;
                    referenced.set(to);
                    changed = true;
                    continue;
                }
                if (!ControlFlowUtil.isVariableAccess(flow, from, variable2)) continue;
                referenced.set(from);
                referenced.set(to);
                if (to == loopStart) {
                    return true;
                }
                changed = true;
            }
        }
        return false;
    }

    @NotNull
    public static InitializerUsageStatus getInitializerUsageStatus(PsiVariable var, PsiStatement statement2) {
        ControlFlow controlFlow;
        if (!(var instanceof PsiLocalVariable) || var.getInitializer() == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(31);
            }
            return initializerUsageStatus;
        }
        if (ControlFlowUtils.isDeclarationJustBefore(var, statement2)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.DECLARED_JUST_BEFORE;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(32);
            }
            return initializerUsageStatus;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)var, PsiLambdaExpression.class, PsiMethod.class) != PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiLambdaExpression.class, PsiMethod.class)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(33);
            }
            return initializerUsageStatus;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock(var, null);
        if (block == null) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(34);
            }
            return initializerUsageStatus;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(statement2.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException ignored) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(35);
            }
            return initializerUsageStatus;
        }
        int start = controlFlow.getEndOffset(var.getInitializer()) + 1;
        int stop = controlFlow.getStartOffset(statement2);
        if (ControlFlowUtils.isVariableReferencedBeforeLoopEntry(controlFlow, start, statement2, var)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.UNKNOWN;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(36);
            }
            return initializerUsageStatus;
        }
        if (!ControlFlowUtil.isValueUsedWithoutVisitingStop(controlFlow, start, stop, var)) {
            InitializerUsageStatus initializerUsageStatus = InitializerUsageStatus.AT_WANTED_PLACE_ONLY;
            if (initializerUsageStatus == null) {
                ControlFlowUtils.$$$reportNull$$$0(37);
            }
            return initializerUsageStatus;
        }
        InitializerUsageStatus initializerUsageStatus = var.hasModifierProperty("final") ? InitializerUsageStatus.UNKNOWN : InitializerUsageStatus.AT_WANTED_PLACE;
        if (initializerUsageStatus == null) {
            ControlFlowUtils.$$$reportNull$$$0(38);
        }
        return initializerUsageStatus;
    }

    static boolean isDeclarationJustBefore(PsiVariable var, PsiStatement nextStatement) {
        PsiElement[] elements;
        PsiElement declaration = var.getParent();
        PsiElement nextStatementParent = nextStatement.getParent();
        if (nextStatementParent instanceof PsiLabeledStatement) {
            nextStatement = (PsiStatement)nextStatementParent;
        }
        return declaration instanceof PsiDeclarationStatement && ArrayUtil.getLastElement(elements = ((PsiDeclarationStatement)declaration).getDeclaredElements()) == var && nextStatement.equals(PsiTreeUtil.skipWhitespacesAndCommentsForward(declaration));
    }

    @Contract(value="null -> false")
    public static boolean statementIsEmpty(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (statement2 instanceof PsiEmptyStatement) {
            return true;
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiStatement[] codeBlockStatements;
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            for (PsiStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                if (ControlFlowUtils.statementIsEmpty(codeBlockStatement)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canExtractStatement(PsiExpression expression2) {
        return ControlFlowUtils.canExtractStatement(expression2, true);
    }

    public static boolean canExtractStatement(PsiExpression expression2, boolean checkExecuted) {
        PsiElement grandParent;
        PsiElement cur = expression2;
        PsiElement parent2 = cur.getParent();
        while (parent2 instanceof PsiExpression || parent2 instanceof PsiExpressionList) {
            PsiReferenceExpression methodExpression;
            PsiPolyadicExpression polyadicExpression;
            IElementType type2;
            if (parent2 instanceof PsiLambdaExpression) {
                return true;
            }
            if (checkExecuted && parent2 instanceof PsiPolyadicExpression && ((type2 = (polyadicExpression = (PsiPolyadicExpression)parent2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type2.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != cur) {
                return false;
            }
            if (checkExecuted && parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getCondition() != cur) {
                return false;
            }
            if (parent2 instanceof PsiMethodCallExpression && ((methodExpression = ((PsiMethodCallExpression)parent2).getMethodExpression()).textMatches("this") || methodExpression.textMatches("super"))) {
                return false;
            }
            cur = parent2;
            parent2 = cur.getParent();
        }
        if (parent2 instanceof PsiStatement) {
            grandParent = parent2.getParent();
            if (checkExecuted && grandParent instanceof PsiForStatement && ((PsiForStatement)grandParent).getUpdate() == parent2) {
                return false;
            }
        }
        if (parent2 instanceof PsiReturnStatement || parent2 instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent2 instanceof PsiLocalVariable && (grandParent = parent2.getParent()) instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)grandParent).getDeclaredElements().length == 1) {
            return true;
        }
        if (parent2 instanceof PsiField) {
            PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward(parent2);
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward(parent2);
            boolean multipleFieldsDeclaration = prev instanceof PsiJavaToken && ((PsiJavaToken)prev).getTokenType() == JavaTokenType.COMMA || next instanceof PsiJavaToken && ((PsiJavaToken)next).getTokenType() == JavaTokenType.COMMA;
            return !multipleFieldsDeclaration;
        }
        if (parent2 instanceof PsiForeachStatement && ((PsiForeachStatement)parent2).getIteratedValue() == cur) {
            return true;
        }
        return parent2 instanceof PsiIfStatement && ((PsiIfStatement)parent2).getCondition() == cur;
    }

    @Nullable
    public static PsiReturnStatement getNextReturnStatement(PsiStatement statement2) {
        PsiElement nextStatement;
        while (!((nextStatement = PsiTreeUtil.skipWhitespacesAndCommentsForward(statement2)) instanceof PsiReturnStatement)) {
            PsiElement parent2 = statement2.getParent();
            if (parent2 instanceof PsiCodeBlock) {
                PsiStatement[] statements = ((PsiCodeBlock)parent2).getStatements();
                if (statements.length == 0 || statements[statements.length - 1] != statement2) {
                    return null;
                }
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiIfStatement) && !(parent2 instanceof PsiBlockStatement)) {
                return null;
            }
            statement2 = (PsiStatement)parent2;
        }
        return (PsiReturnStatement)nextStatement;
    }

    public static boolean isReachable(@NotNull PsiStatement statement2) {
        ControlFlow flow;
        PsiCodeBlock block;
        if (statement2 == null) {
            ControlFlowUtils.$$$reportNull$$$0(39);
        }
        if ((block = PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiCodeBlock.class)) == null) {
            return true;
        }
        try {
            flow = ControlFlowFactory.getInstance(statement2.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return ControlFlowUtil.isInstructionReachable(flow, flow.getStartOffset(statement2), 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ControlFlowUtils";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingStatement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapBlock";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializerUsageStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doWhileStatementMayCompleteNormally";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementMayCompleteNormally";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forStatementMayCompleteNormally";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "switchStatementMayCompleteNormally";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementMayCompleteNormally";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementMayCompleteNormally";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "labeledStatementMayCompleteNormally";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "statementIsBreakTarget";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "statementContainsContinueToAncestor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsReturn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "statementIsContinueTarget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsSystemExit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInLoop";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInFinallyBlock";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInCatchBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInExitStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInReturnStatementArgument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInThrowStatementArgument";
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "statementCompletesWithStatement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesWithStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContainingStatementOrBlock";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "statementIsLastInBlock";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLastChildOfType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyChildOfType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasChildrenOfTypeCount";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "methodAlwaysThrowsException";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isReachable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContinueToAncestorFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiStatement statement;
        private boolean found;

        private ContinueToAncestorFinder(PsiStatement statement2) {
            this.statement = statement2;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitContinueStatement(PsiContinueStatement continueStatement) {
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (labelIdentifier == null) {
                return;
            }
            PsiStatement continuedStatement = continueStatement.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(continuedStatement, this.statement, true)) {
                this.found = true;
            }
        }

        private boolean continueToAncestorFound() {
            return this.found;
        }
    }

    private static class MethodCallFinder
    extends JavaRecursiveElementWalkingVisitor {
        private final String containingClassName;
        private final PsiType returnType;
        private final String methodName;
        private final PsiType[] parameterTypeNames;
        private boolean containsCallToMethod;

        private MethodCallFinder(String containingClassName, PsiType returnType, String methodName, PsiType ... parameterTypeNames) {
            this.containingClassName = containingClassName;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameterTypeNames = parameterTypeNames;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.containsCallToMethod) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, this.containingClassName, this.returnType, this.methodName, this.parameterTypeNames)) {
                return;
            }
            this.containsCallToMethod = true;
        }

        private boolean containsCallToMethod() {
            return this.containsCallToMethod;
        }
    }

    private static class ContinueFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private ContinueFinder(@NotNull PsiStatement target) {
            if (target == null) {
                ContinueFinder.$$$reportNull$$$0(0);
            }
            this.m_target = target;
        }

        private boolean continueFound() {
            return this.m_found;
        }

        @Override
        public void visitContinueStatement(@NotNull PsiContinueStatement statement2) {
            if (statement2 == null) {
                ContinueFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitContinueStatement(statement2);
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (continuedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(continuedStatement, this.m_target, false)) {
                this.m_found = true;
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept(this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$ContinueFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;
        private final PsiStatement m_target;

        private BreakFinder(@NotNull PsiStatement target) {
            if (target == null) {
                BreakFinder.$$$reportNull$$$0(0);
            }
            this.m_target = target;
        }

        private boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitBreakStatement(@NotNull PsiBreakStatement statement2) {
            if (statement2 == null) {
                BreakFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitBreakStatement(statement2);
            PsiStatement exitedStatement = statement2.findExitedStatement();
            if (exitedStatement == null) {
                return;
            }
            if (PsiTreeUtil.isAncestor(exitedStatement, this.m_target, false)) {
                this.m_found = true;
            }
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement2) {
            PsiStatement elseBranch;
            PsiStatement thenBranch;
            if (this.m_found) {
                return;
            }
            PsiExpression condition = statement2.getCondition();
            Object value = ExpressionUtils.computeConstantExpression(condition);
            if (Boolean.FALSE != value && (thenBranch = statement2.getThenBranch()) != null) {
                thenBranch.accept(this);
            }
            if (Boolean.TRUE != value && (elseBranch = statement2.getElseBranch()) != null) {
                elseBranch.accept(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$BreakFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myFound;

        private ReturnFinder() {
        }

        private boolean returnFound() {
            return this.myFound;
        }

        @Override
        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ReturnFinder.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression expression2) {
        }

        @Override
        public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
            if (returnStatement == null) {
                ReturnFinder.$$$reportNull$$$0(1);
            }
            this.myFound = true;
            this.stopWalking();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$ReturnFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SystemExitFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private SystemExitFinder() {
        }

        private boolean exitFound() {
            return this.m_found;
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                SystemExitFinder.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SystemExitFinder.$$$reportNull$$$0(1);
            }
            if (this.m_found) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            if (!methodName.equals("exit")) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            String className2 = aClass2.getQualifiedName();
            if (!"java.lang.System".equals(className2) && !"java.lang.Runtime".equals(className2)) {
                return;
            }
            this.m_found = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/ControlFlowUtils$SystemExitFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NakedBreakFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean m_found;

        private NakedBreakFinder() {
        }

        private boolean breakFound() {
            return this.m_found;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.m_found) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
        }

        @Override
        public void visitBreakStatement(PsiBreakStatement statement2) {
            if (statement2.getLabelIdentifier() != null) {
                return;
            }
            this.m_found = true;
        }

        @Override
        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        }

        @Override
        public void visitForStatement(PsiForStatement statement2) {
        }

        @Override
        public void visitForeachStatement(PsiForeachStatement statement2) {
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement2) {
        }

        @Override
        public void visitSwitchStatement(PsiSwitchStatement statement2) {
        }
    }

    public static enum InitializerUsageStatus {
        DECLARED_JUST_BEFORE,
        AT_WANTED_PLACE_ONLY,
        AT_WANTED_PLACE,
        UNKNOWN;

    }
}

