/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FormatUtils {
    @NonNls
    public static final Set<String> formatMethodNames = new HashSet<String>(2);
    public static final Set<String> formatClassNames = new HashSet<String>(4);

    private FormatUtils() {
    }

    public static boolean isFormatCall(PsiMethodCallExpression expression2) {
        return FormatUtils.isFormatCall(expression2, Collections.emptyList(), Collections.emptyList());
    }

    public static boolean isFormatCall(PsiMethodCallExpression expression2, List<String> optionalMethods, List<String> optionalClasses) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!formatMethodNames.contains(name) && !optionalMethods.contains(name)) {
            return false;
        }
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className2 = containingClass.getQualifiedName();
        return formatClassNames.contains(className2) || optionalClasses.contains(className2);
    }

    public static boolean isFormatCallArgument(PsiElement element) {
        PsiExpressionList expressionList = PsiTreeUtil.getParentOfType(element, PsiExpressionList.class, true, PsiCodeBlock.class, PsiStatement.class, PsiClass.class);
        if (expressionList == null) {
            return false;
        }
        PsiElement parent2 = expressionList.getParent();
        return parent2 instanceof PsiMethodCallExpression && FormatUtils.isFormatCall((PsiMethodCallExpression)parent2);
    }

    @Nullable
    public static PsiExpression getFormatArgument(PsiExpressionList argumentList2) {
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        if (arguments2.length == 0) {
            return null;
        }
        PsiExpression firstArgument = arguments2[0];
        PsiType type2 = firstArgument.getType();
        if (type2 == null) {
            return null;
        }
        int formatArgumentIndex = "java.util.Locale".equals(type2.getCanonicalText()) && arguments2.length > 1 ? 1 : 0;
        return arguments2[formatArgumentIndex];
    }

    static {
        formatMethodNames.add("format");
        formatMethodNames.add("printf");
        formatClassNames.add("java.io.Console");
        formatClassNames.add("java.io.PrintWriter");
        formatClassNames.add("java.io.PrintStream");
        formatClassNames.add("java.util.Formatter");
        formatClassNames.add("java.lang.String");
    }
}

