/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import one.util.streamex.StreamEx;

public class FunctionalExpressionUtils {
    public static boolean isFunctionalReferenceTo(PsiExpression expression2, String className2, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression2;
            if (!methodName.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method = ObjectUtils.tryCast(methodRef.resolve(), PsiMethod.class);
            PsiReferenceExpression ref = ObjectUtils.tryCast(methodRef.getQualifier(), PsiReferenceExpression.class);
            return ref != null && method != null && MethodUtils.methodMatches(method, className2, returnType, methodName, parameterTypes) && ref.isReferenceTo(method.getContainingClass());
        }
        if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiExpression body2 = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
            PsiMethodCallExpression call2 = ObjectUtils.tryCast(body2, PsiMethodCallExpression.class);
            if (call2 == null || !MethodCallUtils.isCallToMethod(call2, className2, returnType, methodName, parameterTypes)) {
                return false;
            }
            Object[] parameters2 = lambda2.getParameterList().getParameters();
            Object[] args = call2.getArgumentList().getExpressions();
            PsiMethod method = call2.resolveMethod();
            if (method != null && !method.hasModifierProperty("static")) {
                args = ArrayUtil.prepend(call2.getMethodExpression().getQualifierExpression(), args);
            }
            if (parameters2.length != args.length || StreamEx.zip((Object[])args, (Object[])parameters2, ExpressionUtils::isReferenceTo).has(false)) {
                return false;
            }
            return MethodCallUtils.isCallToMethod(call2, className2, returnType, methodName, parameterTypes);
        }
        return false;
    }
}

