/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportUtils {
    private ImportUtils() {
    }

    public static void addImportIfNeeded(@NotNull PsiClass aClass2, @NotNull PsiElement context) {
        PsiElement brace;
        PsiFile file2;
        if (aClass2 == null) {
            ImportUtils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(1);
        }
        if (!((file2 = context.getContainingFile()) instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        PsiClass outerClass2 = aClass2.getContainingClass();
        if (outerClass2 == null ? PsiTreeUtil.isAncestor(javaFile, aClass2, true) : PsiTreeUtil.isAncestor(outerClass2, context, true) && (brace = outerClass2.getLBrace()) != null && brace.getTextOffset() < context.getTextOffset()) {
            return;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        if (qualifiedName2 == null) {
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        String containingPackageName = javaFile.getPackageName();
        String packageName = ClassUtil.extractPackageName(qualifiedName2);
        if ("java.lang".equals(packageName)) {
            return;
        }
        if (containingPackageName.equals(packageName) || importList.findSingleClassImportStatement(qualifiedName2) != null) {
            return;
        }
        if (importList.findOnDemandImportStatement(packageName) != null && !ImportUtils.hasOnDemandImportConflict(qualifiedName2, javaFile)) {
            return;
        }
        if (ImportUtils.hasExactImportConflict(qualifiedName2, javaFile)) {
            return;
        }
        Project project = importList.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        PsiImportStatement importStatement = elementFactory.createImportStatement(aClass2);
        importList.add(importStatement);
    }

    private static boolean hasAccessibleMemberWithName(@NotNull PsiClass containingClass, @NotNull String memberName, @NotNull PsiElement context) {
        PsiMethod[] methods2;
        PsiField field;
        if (containingClass == null) {
            ImportUtils.$$$reportNull$$$0(2);
        }
        if (memberName == null) {
            ImportUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(4);
        }
        if ((field = containingClass.findFieldByName(memberName, true)) != null && PsiUtil.isAccessible(field, context, null)) {
            return true;
        }
        for (PsiMethod method : methods2 = containingClass.findMethodsByName(memberName, true)) {
            if (!PsiUtil.isAccessible(method, context, null)) continue;
            return true;
        }
        PsiClass innerClass = containingClass.findInnerClassByName(memberName, true);
        return innerClass != null && PsiUtil.isAccessible(innerClass, context, null);
    }

    public static boolean nameCanBeImported(@NotNull String fqName2, @NotNull PsiElement context) {
        PsiJavaFile file2;
        PsiFile containingFile;
        if (fqName2 == null) {
            ImportUtils.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(6);
        }
        if (!((containingFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(context, PsiClass.class);
        if (containingClass != null) {
            PsiClass[] innerClasses2;
            String shortName = ClassUtil.extractClassName(fqName2);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(context.getProject()).getResolveHelper();
            if (resolveHelper.resolveAccessibleReferencedVariable(shortName, context) != null) {
                return false;
            }
            for (PsiClass innerClass : innerClasses2 = containingClass.getAllInnerClasses()) {
                if (innerClass.hasModifierProperty("private") && !containingClass.equals(innerClass.getContainingClass()) || innerClass.hasModifierProperty("packageLocal") && !ClassUtils.inSamePackage(innerClass, containingClass) || !shortName.equals(innerClass.getName())) continue;
                return fqName2.equals(innerClass.getQualifiedName());
            }
            while (containingClass != null) {
                if (shortName.equals(containingClass.getName())) {
                    return fqName2.equals(containingClass.getQualifiedName());
                }
                containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
            }
        }
        if (ImportUtils.hasExactImportConflict(fqName2, file2 = (PsiJavaFile)containingFile)) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict(fqName2, file2, true)) {
            return false;
        }
        if (ImportUtils.containsConflictingReference(file2, fqName2)) {
            return false;
        }
        if (ImportUtils.containsConflictingClassName(fqName2, file2)) {
            return false;
        }
        return !ImportUtils.containsConflictingTypeParameter(fqName2, context);
    }

    private static boolean containsConflictingTypeParameter(String fqName2, PsiElement context) {
        String shortName = ClassUtil.extractClassName(fqName2);
        for (PsiElement parent2 = context.getParent(); parent2 != null && !(parent2 instanceof PsiFile); parent2 = parent2.getParent()) {
            if (!(parent2 instanceof PsiTypeParameterListOwner)) continue;
            for (PsiTypeParameter parameter : ((PsiTypeParameterListOwner)parent2).getTypeParameters()) {
                if (!shortName.equals(parameter.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsConflictingClassName(String fqName2, PsiJavaFile file2) {
        PsiClass[] classes2;
        String shortName = ClassUtil.extractClassName(fqName2);
        for (PsiClass aClass2 : classes2 = file2.getClasses()) {
            if (!shortName.equals(aClass2.getName()) || fqName2.equals(aClass2.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportConflict(String fqName2, PsiJavaFile file2) {
        PsiImportList imports = file2.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        String shortName = ClassUtil.extractClassName(fqName2);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName2) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnDemandImportConflict(@NotNull String fqName2, @NotNull PsiElement context) {
        if (fqName2 == null) {
            ImportUtils.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(8);
        }
        return ImportUtils.hasOnDemandImportConflict(fqName2, context, false);
    }

    private static boolean hasOnDemandImportConflict(@NotNull String fqName2, @NotNull PsiElement context, boolean strict) {
        PsiFile containingFile;
        if (fqName2 == null) {
            ImportUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(10);
        }
        if (!((containingFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList imports = javaFile.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatementBase[] importStatements = imports.getAllImportStatements();
        String shortName = ClassUtil.extractClassName(fqName2);
        String packageName = ClassUtil.extractPackageName(fqName2);
        for (PsiImportStatementBase importStatement : importStatements) {
            PsiMethod[] methods2;
            String qualifiedName2;
            String packageText;
            PsiJavaCodeReferenceElement importReference;
            if (!importStatement.isOnDemand() || (importReference = importStatement.getImportReference()) == null || (packageText = importReference.getText()).equals(packageName)) continue;
            PsiElement element = importReference.resolve();
            if (element instanceof PsiPackage) {
                PsiClass[] classes2;
                PsiPackage aPackage = (PsiPackage)element;
                if (!strict) {
                    if (aPackage.findClassByShortName(shortName, containingFile.getResolveScope()).length <= 0) continue;
                    return true;
                }
                for (PsiClass aClass2 : classes2 = aPackage.findClassByShortName(shortName, containingFile.getResolveScope())) {
                    String qualifiedClassName = aClass2.getQualifiedName();
                    if (qualifiedClassName == null || fqName2.equals(qualifiedClassName)) continue;
                    return ImportUtils.containsConflictingReference(containingFile, qualifiedClassName);
                }
                continue;
            }
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass3 = (PsiClass)element;
            PsiClass innerClass = aClass3.findInnerClassByName(shortName, true);
            if (importStatement instanceof PsiImportStatement) {
                if (innerClass == null || !PsiUtil.isAccessible(innerClass, containingFile, null) || fqName2.equals(qualifiedName2 = innerClass.getQualifiedName()) || strict && !ImportUtils.containsConflictingReference(containingFile, qualifiedName2)) continue;
                return true;
            }
            if (innerClass != null && PsiUtil.isAccessible(innerClass, containingFile, null) && innerClass.hasModifierProperty("static") && !fqName2.equals(qualifiedName2 = innerClass.getQualifiedName()) && (!strict || ImportUtils.memberReferenced(innerClass, javaFile))) {
                return true;
            }
            PsiField field = aClass3.findFieldByName(shortName, true);
            if (field != null && PsiUtil.isAccessible(field, containingFile, null) && field.hasModifierProperty("static")) {
                PsiClass containingClass = field.getContainingClass();
                if (containingClass == null) continue;
                String qualifiedName3 = containingClass.getQualifiedName() + '.' + field.getName();
                if (!(fqName2.equals(qualifiedName3) || strict && !ImportUtils.memberReferenced(field, javaFile))) {
                    return true;
                }
            }
            for (PsiMethod method : methods2 = aClass3.findMethodsByName(shortName, true)) {
                String qualifiedName4;
                PsiClass containingClass;
                if (!PsiUtil.isAccessible(method, containingFile, null) || !method.hasModifierProperty("static") || (containingClass = method.getContainingClass()) == null || fqName2.equals(qualifiedName4 = containingClass.getQualifiedName() + '.' + method.getName()) || strict && !ImportUtils.memberReferenced(method, javaFile)) continue;
                return true;
            }
        }
        return ImportUtils.hasJavaLangImportConflict(fqName2, javaFile) || ImportUtils.hasDefaultImportConflict(fqName2, javaFile);
    }

    private static boolean hasDefaultImportConflict(String fqName2, PsiJavaFile file2) {
        String shortName = ClassUtil.extractClassName(fqName2);
        String packageName = ClassUtil.extractPackageName(fqName2);
        String filePackageName = file2.getPackageName();
        if (filePackageName.equals(packageName)) {
            return false;
        }
        Project project = file2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiPackage filePackage = psiFacade.findPackage(filePackageName);
        return filePackage != null && filePackage.containsClassNamed(shortName);
    }

    private static boolean hasJavaLangImportConflict(String fqName2, PsiJavaFile file2) {
        String shortName = ClassUtil.extractClassName(fqName2);
        String packageName = ClassUtil.extractPackageName(fqName2);
        if ("java.lang".equals(packageName)) {
            return false;
        }
        Project project = file2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiPackage javaLangPackage = psiFacade.findPackage("java.lang");
        return javaLangPackage != null && javaLangPackage.containsClassNamed(shortName);
    }

    public static boolean addStaticImport(@NotNull String qualifierClass, @NonNls @NotNull String memberName, @NotNull PsiElement context) {
        PsiFile contextFile;
        PsiClass containingClass;
        if (qualifierClass == null) {
            ImportUtils.$$$reportNull$$$0(11);
        }
        if (memberName == null) {
            ImportUtils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(13);
        }
        if ((containingClass = PsiTreeUtil.getParentOfType(context, PsiClass.class)) != null) {
            if (InheritanceUtil.isInheritor(containingClass, qualifierClass)) {
                return true;
            }
            if (ImportUtils.hasAccessibleMemberWithName(containingClass, memberName, context)) {
                return false;
            }
        }
        if (!((contextFile = context.getContainingFile()) instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)contextFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement != null) {
            if (existingImportStatement instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)existingImportStatement;
                if (!memberName.equals(importStaticStatement.getReferenceName())) {
                    return false;
                }
                PsiClass targetClass = importStaticStatement.resolveTargetClass();
                return targetClass != null && qualifierClass.equals(targetClass.getQualifiedName());
            }
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, qualifierClass);
        if (onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(qualifierClass + '.' + memberName, javaFile)) {
            return true;
        }
        Project project = context.getProject();
        GlobalSearchScope scope = context.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass aClass2 = psiFacade.findClass(qualifierClass, scope);
        if (aClass2 == null || !PsiUtil.isAccessible(aClass2, contextFile, null) || !ImportUtils.hasAccessibleMemberWithName(aClass2, memberName, contextFile)) {
            return false;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        if (qualifiedName2 == null) {
            return false;
        }
        List<PsiImportStaticStatement> imports = ImportUtils.getMatchingImports(importList, qualifiedName2);
        int onDemandCount = JavaCodeStyleSettingsFacade.getInstance(project).getNamesCountToUseImportOnDemand();
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (imports.size() + 1 < onDemandCount) {
            importList.add(elementFactory.createImportStaticStatement(aClass2, memberName));
        } else {
            for (PsiImportStaticStatement importStatement : imports) {
                importStatement.delete();
            }
            importList.add(elementFactory.createImportStaticStatement(aClass2, "*"));
        }
        return true;
    }

    @Nullable
    private static PsiImportStaticStatement findOnDemandImportStaticStatement(PsiImportList importList, String qualifierClass) {
        PsiImportStaticStatement[] importStaticStatements;
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String text2;
            PsiJavaCodeReferenceElement importReference;
            if (!importStaticStatement.isOnDemand() || (importReference = importStaticStatement.getImportReference()) == null || !qualifierClass.equals(text2 = importReference.getText())) continue;
            return importStaticStatement;
        }
        return null;
    }

    private static List<PsiImportStaticStatement> getMatchingImports(@NotNull PsiImportList importList, @NotNull String className2) {
        if (importList == null) {
            ImportUtils.$$$reportNull$$$0(14);
        }
        if (className2 == null) {
            ImportUtils.$$$reportNull$$$0(15);
        }
        ArrayList<PsiImportStaticStatement> imports = new ArrayList<PsiImportStaticStatement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !className2.equals(psiClass.getQualifiedName())) continue;
            imports.add(staticStatement);
        }
        return imports;
    }

    public static boolean isStaticallyImported(@NotNull PsiMember member, @NotNull PsiElement context) {
        PsiClass importClass;
        PsiClass memberClass;
        if (member == null) {
            ImportUtils.$$$reportNull$$$0(16);
        }
        if (context == null) {
            ImportUtils.$$$reportNull$$$0(17);
        }
        if ((memberClass = member.getContainingClass()) == null) {
            return false;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType(context, PsiClass.class);
        if (InheritanceUtil.isInheritorOrSelf(containingClass, memberClass, true)) {
            return false;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        String memberName = member.getName();
        if (memberName == null) {
            return false;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement instanceof PsiImportStaticStatement && InheritanceUtil.isInheritorOrSelf(importClass = ((PsiImportStaticStatement)existingImportStatement).resolveTargetClass(), memberClass, true)) {
            return true;
        }
        String memberClassName = memberClass.getQualifiedName();
        if (memberClassName == null) {
            return false;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, memberClassName);
        return onDemandImportStatement != null && !ImportUtils.hasOnDemandImportConflict(memberClassName + '.' + memberName, javaFile);
    }

    private static boolean memberReferenced(PsiMember member, PsiElement context) {
        MemberReferenceVisitor visitor2 = new MemberReferenceVisitor(member);
        context.accept(visitor2);
        return visitor2.isReferenceFound();
    }

    private static boolean containsConflictingReference(PsiFile element, String fullyQualifiedName) {
        Map cachedValue2 = (Map)CachedValuesManager.getCachedValue(element, () -> new CachedValueProvider.Result(Collections.synchronizedMap(new HashMap()), PsiModificationTracker.MODIFICATION_COUNT));
        Boolean conflictingRef = (Boolean)cachedValue2.get(fullyQualifiedName);
        if (conflictingRef != null) {
            return conflictingRef;
        }
        ConflictingClassReferenceVisitor visitor2 = new ConflictingClassReferenceVisitor(fullyQualifiedName);
        element.accept(visitor2);
        conflictingRef = visitor2.isConflictingReferenceFound();
        cachedValue2.put(fullyQualifiedName, conflictingRef);
        return conflictingRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ImportUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAccessibleMemberWithName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "nameCanBeImported";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasOnDemandImportConflict";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addStaticImport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatchingImports";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticallyImported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConflictingClassReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final String name;
        private final String fullyQualifiedName;
        private boolean referenceFound;

        ConflictingClassReferenceVisitor(String fullyQualifiedName) {
            this.name = ClassUtil.extractClassName(fullyQualifiedName);
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public void visitElement(PsiElement element) {
            if (this.referenceFound) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.getQualifier() != null) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) {
                return;
            }
            PsiClass aClass2 = (PsiClass)element;
            String testClassName = aClass2.getName();
            String testClassQualifiedName = aClass2.getQualifiedName();
            if (testClassQualifiedName == null || testClassName == null || testClassQualifiedName.equals(this.fullyQualifiedName) || !testClassName.equals(this.name)) {
                return;
            }
            this.referenceFound = true;
        }

        boolean isConflictingReferenceFound() {
            return this.referenceFound;
        }
    }

    private static class MemberReferenceVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMember[] members;
        private boolean referenceFound;

        MemberReferenceVisitor(PsiMember member) {
            this.members = new PsiMember[]{member};
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            for (PsiMember member : this.members) {
                if (!member.equals(target)) continue;
                this.referenceFound = true;
                return;
            }
        }

        boolean isReferenceFound() {
            return this.referenceFound;
        }
    }
}

