/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.BaseInspection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodMatcher {
    private final List<String> myMethodNamePatterns = ContainerUtil.newArrayList();
    private final List<String> myClassNames = ContainerUtil.newArrayList();
    private final Map<String, Pattern> myPatternCache = ContainerUtil.newHashMap();
    private final boolean myWriteDefaults;
    private final String myOptionName;
    private String myDefaultSettings = null;

    public MethodMatcher() {
        this(false, "METHOD_MATCHER_CONFIG");
    }

    public MethodMatcher(boolean writeDefaults, String optionName) {
        this.myWriteDefaults = writeDefaults;
        this.myOptionName = optionName;
    }

    public MethodMatcher add(@NotNull String className2, @NotNull String methodNamePattern) {
        if (className2 == null) {
            MethodMatcher.$$$reportNull$$$0(0);
        }
        if (methodNamePattern == null) {
            MethodMatcher.$$$reportNull$$$0(1);
        }
        this.myClassNames.add(className2);
        this.myMethodNamePatterns.add(methodNamePattern);
        return this;
    }

    public void add(@NotNull PsiMethodCallExpression expression2) {
        PsiMethod method;
        if (expression2 == null) {
            MethodMatcher.$$$reportNull$$$0(2);
        }
        if ((method = expression2.resolveMethod()) != null) {
            this.add(method);
        }
    }

    public void add(@NotNull PsiMethod method) {
        PsiClass aClass2;
        if (method == null) {
            MethodMatcher.$$$reportNull$$$0(3);
        }
        if ((aClass2 = method.getContainingClass()) == null) {
            return;
        }
        String fqName2 = aClass2.getQualifiedName();
        int index2 = this.myClassNames.indexOf(fqName2);
        String methodName = method.getName();
        if (index2 < 0) {
            this.myClassNames.add(fqName2);
            this.myMethodNamePatterns.add(methodName);
        } else {
            String[] names2;
            String pattern = this.myMethodNamePatterns.get(index2);
            if (pattern.isEmpty()) {
                this.myMethodNamePatterns.set(index2, methodName);
                return;
            }
            if (".*".equals(pattern)) {
                return;
            }
            for (String name : names2 = pattern.split("\\|")) {
                if (!methodName.equals(name)) continue;
                return;
            }
            this.myMethodNamePatterns.set(index2, pattern + '|' + methodName);
        }
        ProjectInspectionProfileManager.getInstance(method.getProject()).fireProfileChanged();
    }

    @NotNull
    protected String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            MethodMatcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    public List<String> getMethodNamePatterns() {
        return this.myMethodNamePatterns;
    }

    public List<String> getClassNames() {
        return this.myClassNames;
    }

    public boolean matches(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        String methodName = method.getName();
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return false;
        }
        int size = this.myMethodNamePatterns.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String className2;
            Pattern pattern = this.getPattern(i2);
            if (pattern == null || !pattern.matcher(methodName).matches() || !InheritanceUtil.isInheritor(aClass2, className2 = this.myClassNames.get(i2))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(PsiCall call2) {
        return this.matches(call2.resolveMethod());
    }

    private Pattern getPattern(int i2) {
        String methodNamePattern = this.myMethodNamePatterns.get(i2);
        Pattern pattern = this.myPatternCache.get(methodNamePattern);
        if (pattern == null) {
            try {
                pattern = Pattern.compile(methodNamePattern);
                this.myPatternCache.put(methodNamePattern, pattern);
            }
            catch (NullPointerException | PatternSyntaxException ignore) {
                return null;
            }
        }
        return pattern;
    }

    public MethodMatcher finishDefault() {
        if (this.myDefaultSettings != null) {
            throw new IllegalStateException();
        }
        this.myDefaultSettings = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        return this;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            MethodMatcher.$$$reportNull$$$0(5);
        }
        String settings2 = null;
        for (Element option2 : node.getChildren("option")) {
            if (!option2.getAttributeValue("name").equals(this.getOptionName())) continue;
            settings2 = option2.getAttributeValue("value");
            break;
        }
        if (settings2 == null) {
            return;
        }
        this.myPatternCache.clear();
        this.myClassNames.clear();
        this.myMethodNamePatterns.clear();
        BaseInspection.parseString(settings2, this.myClassNames, this.myMethodNamePatterns);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            MethodMatcher.$$$reportNull$$$0(6);
        }
        String settings2 = BaseInspection.formatString(this.myClassNames, this.myMethodNamePatterns);
        if (!this.myWriteDefaults && settings2.equals(this.myDefaultSettings)) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", this.getOptionName()).setAttribute("value", settings2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNamePattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/MethodMatcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/MethodMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

