/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementWalkingVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean usedInInnerClass;
    private int inInnerClassCount;

    VariableUsedInInnerClassVisitor(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            VariableUsedInInnerClassVisitor.$$$reportNull$$$0(0);
        }
        this.variable = variable2;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            VariableUsedInInnerClassVisitor.$$$reportNull$$$0(1);
        }
        if (!this.usedInInnerClass) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        PsiElement parent2 = token.getParent();
        if (parent2 instanceof PsiClass) {
            PsiClass aClass2 = (PsiClass)parent2;
            if (token.getTokenType() == JavaTokenType.LBRACE && aClass2.getLBrace() == token) {
                ++this.inInnerClassCount;
            }
            if (token.getTokenType() == JavaTokenType.RBRACE && aClass2.getRBrace() == token) {
                --this.inInnerClassCount;
            }
        }
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        super.visitLambdaExpression(expression2);
        ++this.inInnerClassCount;
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            VariableUsedInInnerClassVisitor.$$$reportNull$$$0(2);
        }
        super.elementFinished(element);
        if (element instanceof PsiLambdaExpression) {
            --this.inInnerClassCount;
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        PsiElement target;
        if (referenceExpression == null) {
            VariableUsedInInnerClassVisitor.$$$reportNull$$$0(3);
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        if (this.inInnerClassCount > 0 && this.variable.equals(target = referenceExpression.resolve())) {
            this.usedInInnerClass = true;
        }
    }

    boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "elementFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

