/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class IOResourceInspectionBase
extends ResourceInspection {
    protected static final String[] IO_TYPES = new String[]{"java.io.InputStream", "java.io.OutputStream", "java.io.Reader", "java.io.Writer", "java.io.RandomAccessFile", "java.util.zip.ZipFile", "java.io.Closeable"};
    final List<String> ignoredTypes = new ArrayList<String>();
    public String ignoredTypesString = "java.io.ByteArrayOutputStream,java.io.ByteArrayInputStream,java.io.StringBufferInputStream,java.io.CharArrayWriter,java.io.CharArrayReader,java.io.StringWriter,java.io.StringReader";

    public IOResourceInspectionBase() {
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    @NotNull
    public String getID() {
        if ("IOResourceOpenedButNotSafelyClosed" == null) {
            IOResourceInspectionBase.$$$reportNull$$$0(0);
        }
        return "IOResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("i.o.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            IOResourceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            IOResourceInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        IOResourceInspectionBase.parseString(this.ignoredTypesString, this.ignoredTypes);
    }

    @Override
    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            IOResourceInspectionBase.$$$reportNull$$$0(3);
        }
        this.ignoredTypesString = IOResourceInspectionBase.formatString(this.ignoredTypes);
        super.writeSettings(element);
    }

    @Override
    public boolean isResourceCreation(PsiExpression expression2) {
        if (expression2 instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, IO_TYPES) != null && !this.isIgnoredType(expression2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getResourceAsStream".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Class", "java.lang.ClassLoader") == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.io.InputStream");
        }
        return false;
    }

    private boolean isIgnoredType(PsiExpression expression2) {
        return TypeUtils.expressionHasTypeOrSubtype(expression2, this.ignoredTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/IOResourceInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/IOResourceInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

