/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class JNDIResourceInspection
extends ResourceInspection {
    @Override
    @NotNull
    public String getID() {
        if ("JNDIResourceOpenedButNotSafelyClosed" == null) {
            JNDIResourceInspection.$$$reportNull$$$0(0);
        }
        return "JNDIResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jndi.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            JNDIResourceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("list".equals(methodName) || "listBindings".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.Context");
            }
            if ("getAll".equals(methodName)) {
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return false;
                }
                return TypeUtils.expressionHasTypeOrSubtype(qualifier, "javax.naming.directory.Attribute", "javax.naming.directory.Attributes") != null;
            }
            return false;
        }
        if (expression2 instanceof PsiNewExpression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression2, "javax.naming.InitialContext");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/resources/JNDIResourceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

