/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class PublicStaticArrayFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.static.array.field.display.name", new Object[0]);
        if (string == null) {
            PublicStaticArrayFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("public.static.array.field.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicStaticArrayFieldInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicStaticArrayFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/PublicStaticArrayFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PublicStaticArrayFieldVisitor
    extends BaseInspectionVisitor {
        private PublicStaticArrayFieldVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                PublicStaticArrayFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("public")) {
                return;
            }
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiType type2 = field.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            if (CollectionUtils.isConstantEmptyArray(field)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/security/PublicStaticArrayFieldInspection$PublicStaticArrayFieldVisitor", "visitField"));
        }
    }
}

