/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemPropertiesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("AccessOfSystemProperties" == null) {
            SystemPropertiesInspection.$$$reportNull$$$0(0);
        }
        return "AccessOfSystemProperties";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("system.properties.display.name", new Object[0]);
        if (string == null) {
            SystemPropertiesInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        boolean isGetSystemProperty = (Boolean)infos2[0];
        boolean isIntegerGetInteger = (Boolean)infos2[1];
        if (isGetSystemProperty) {
            String string = InspectionGadgetsBundle.message("system.set.problem.descriptor", new Object[0]);
            if (string == null) {
                SystemPropertiesInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (isIntegerGetInteger) {
            String string = InspectionGadgetsBundle.message("system.properties.problem.descriptor", new Object[0]);
            if (string == null) {
                SystemPropertiesInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("system.properties.problem.descriptor1", new Object[0]);
        if (string == null) {
            SystemPropertiesInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemPropertiesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/security/SystemPropertiesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SystemPropertiesVisitor
    extends BaseInspectionVisitor {
        private SystemPropertiesVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SystemPropertiesVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            boolean isGetSystemProperty = SystemPropertiesVisitor.isGetSystemProperty(expression2);
            boolean isIntegerGetInteger = SystemPropertiesVisitor.isIntegerGetInteger(expression2);
            boolean isBooleanGetBoolean = SystemPropertiesVisitor.isBooleanGetBoolean(expression2);
            if (!(isGetSystemProperty || isIntegerGetInteger || isBooleanGetBoolean)) {
                return;
            }
            this.registerMethodCallError(expression2, isGetSystemProperty, isIntegerGetInteger);
        }

        private static boolean isGetSystemProperty(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("getProperty".equals(methodName) || "getProperties".equals(methodName) || "setProperty".equals(methodName) || "setProperties".equals(methodName) || "clearProperties".equals(methodName))) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            if (className2 == null) {
                return false;
            }
            return "java.lang.System".equals(className2);
        }

        private static boolean isIntegerGetInteger(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getInteger".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            if (className2 == null) {
                return false;
            }
            return "java.lang.Integer".equals(className2);
        }

        private static boolean isBooleanGetBoolean(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getBoolean".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            if (className2 == null) {
                return false;
            }
            return "java.lang.Boolean".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/security/SystemPropertiesInspection$SystemPropertiesVisitor", "visitMethodCallExpression"));
        }
    }
}

