/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.jetbrains.annotations.NotNull;

class SerializableInnerClassWithNonSerializableOuterClassVisitor
extends BaseInspectionVisitor {
    private final SerializableInspectionBase inspection;

    public SerializableInnerClassWithNonSerializableOuterClassVisitor(SerializableInspectionBase inspection) {
        this.inspection = inspection;
    }

    @Override
    public void visitClass(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            SerializableInnerClassWithNonSerializableOuterClassVisitor.$$$reportNull$$$0(0);
        }
        if (aClass2.isInterface() || aClass2.isAnnotationType() || aClass2.isEnum()) {
            return;
        }
        if (aClass2 instanceof PsiTypeParameter) {
            return;
        }
        if (this.inspection.ignoreAnonymousInnerClasses && aClass2 instanceof PsiAnonymousClass) {
            return;
        }
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)aClass2, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        if (aClass2.hasModifierProperty("static")) {
            return;
        }
        PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement(aClass2, containingClass);
        if (staticElement != null) {
            return;
        }
        if (!SerializationUtils.isSerializable(aClass2)) {
            return;
        }
        if (SerializationUtils.isSerializable(containingClass)) {
            return;
        }
        if (this.inspection.isIgnoredSubclass(aClass2)) {
            return;
        }
        this.registerClassError(aClass2, new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableInnerClassWithNonSerializableOuterClassVisitor", "visitClass"));
    }
}

