/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListIndexOfReplaceableByContainsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("indexof.replaceable.by.contains.display.name", new Object[0]);
        if (string == null) {
            ListIndexOfReplaceableByContainsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String text2;
        PsiBinaryExpression expression2 = (PsiBinaryExpression)infos2[0];
        PsiExpression lhs = expression2.getLOperand();
        if (lhs instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            text2 = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression2.getOperationTokenType());
        } else {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression2.getROperand();
            assert (callExpression != null);
            text2 = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression2.getOperationTokenType());
        }
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", text2);
        if (string == null) {
            ListIndexOfReplaceableByContainsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new IndexOfReplaceableByContainsFix();
    }

    static String createContainsExpressionText(@NotNull PsiMethodCallExpression call2, boolean flipped, IElementType tokenType) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (call2 == null) {
            ListIndexOfReplaceableByContainsInspection.$$$reportNull$$$0(2);
        }
        String qualifierText = (qualifierExpression = (methodExpression = call2.getMethodExpression()).getQualifierExpression()) == null ? "" : qualifierExpression.getText();
        PsiExpressionList argumentList2 = call2.getArgumentList();
        PsiExpression expression2 = argumentList2.getExpressions()[0];
        String newExpressionText = qualifierText + ".contains(" + expression2.getText() + ')';
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            return '!' + newExpressionText;
        }
        if (!flipped && (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE))) {
            return '!' + newExpressionText;
        }
        if (flipped && (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE))) {
            return '!' + newExpressionText;
        }
        return newExpressionText;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IndexOfReplaceableByContainsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createContainsExpressionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IndexOfReplaceableByContainsVisitor
    extends BaseInspectionVisitor {
        private IndexOfReplaceableByContainsVisitor() {
        }

        @Override
        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!ComparisonUtils.isComparison(expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (lhs instanceof PsiMethodCallExpression) {
                if (IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(lhs, rhs, false, expression2.getOperationTokenType())) {
                    this.registerError((PsiElement)expression2, expression2);
                }
            } else if (rhs instanceof PsiMethodCallExpression && IndexOfReplaceableByContainsVisitor.canBeReplacedByContains(rhs, lhs, true, expression2.getOperationTokenType())) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }

        private static boolean canBeReplacedByContains(PsiExpression lhs, PsiExpression rhs, boolean flipped, IElementType tokenType) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
            if (!IndexOfReplaceableByContainsVisitor.isIndexOfCall(callExpression)) {
                return false;
            }
            Object object = ExpressionUtils.computeConstantExpression(rhs);
            if (!(object instanceof Integer)) {
                return false;
            }
            Integer integer = (Integer)object;
            int constant = integer;
            if (flipped) {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.LT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.GE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.LE.equals(tokenType) || JavaTokenType.GT.equals(tokenType))) {
                    return true;
                }
            } else {
                if (constant == -1 && (JavaTokenType.NE.equals(tokenType) || JavaTokenType.GT.equals(tokenType) || JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.LE.equals(tokenType))) {
                    return true;
                }
                if (constant == 0 && (JavaTokenType.GE.equals(tokenType) || JavaTokenType.LT.equals(tokenType))) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isIndexOfCall(@NotNull PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression;
            String methodName;
            if (expression2 == null) {
                IndexOfReplaceableByContainsVisitor.$$$reportNull$$$0(0);
            }
            if (!"indexOf".equals(methodName = (methodExpression = expression2.getMethodExpression()).getReferenceName())) {
                return false;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length != 1) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType qualifierType = qualifier.getType();
            if (qualifierType == null) {
                return false;
            }
            Project project = expression2.getProject();
            GlobalSearchScope projectScope = GlobalSearchScope.allScope(project);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
            PsiClass javaUtilListClass = psiFacade.findClass("java.util.List", projectScope);
            if (javaUtilListClass == null) {
                return false;
            }
            PsiElementFactory factory2 = psiFacade.getElementFactory();
            PsiClassType javaUtilListType = factory2.createType(javaUtilListClass);
            return javaUtilListType.isAssignableFrom(qualifierType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsVisitor", "isIndexOfCall"));
        }
    }

    private static class IndexOfReplaceableByContainsFix
    extends InspectionGadgetsFix {
        private IndexOfReplaceableByContainsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            String newExpressionText;
            PsiBinaryExpression expression2 = (PsiBinaryExpression)descriptor2.getPsiElement();
            PsiExpression lhs = expression2.getLOperand();
            PsiExpression rhs = expression2.getROperand();
            if (lhs instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)lhs;
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, false, expression2.getOperationTokenType());
            } else {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)rhs;
                assert (callExpression != null);
                newExpressionText = ListIndexOfReplaceableByContainsInspection.createContainsExpressionText(callExpression, true, expression2.getOperationTokenType());
            }
            PsiReplacementUtil.replaceExpression(expression2, newExpressionText);
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.indexof.with.contains.quickfix", new Object[0]);
            if (string == null) {
                IndexOfReplaceableByContainsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ListIndexOfReplaceableByContainsInspection$IndexOfReplaceableByContainsFix", "getFamilyName"));
        }
    }
}

