/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnclearBinaryExpressionInspection
extends BaseInspection {
    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("UnclearExpression" == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(0);
        }
        return "UnclearExpression";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.display.name", new Object[0]);
        if (string == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unclear.binary.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            UnclearBinaryExpressionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new UnclearBinaryExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnclearBinaryExpressionVisitor();
    }

    public static boolean mightBeConfusingExpression(@Nullable PsiElement element) {
        return element instanceof PsiPolyadicExpression || element instanceof PsiConditionalExpression || element instanceof PsiInstanceOfExpression || element instanceof PsiAssignmentExpression || element instanceof PsiParenthesizedExpression;
    }

    @Contract(value="null, _ -> false")
    public static boolean isUnclearExpression(PsiExpression expression2, PsiElement parent2) {
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression nestedAssignment;
            IElementType nestedTokenType;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (parent2 instanceof PsiVariable ? !tokenType.equals(JavaTokenType.EQ) : parent2 instanceof PsiAssignmentExpression && !tokenType.equals(nestedTokenType = (nestedAssignment = (PsiAssignmentExpression)parent2).getOperationTokenType())) {
                return true;
            }
            return UnclearBinaryExpressionInspection.isUnclearExpression(assignmentExpression.getRExpression(), assignmentExpression);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            if (PsiUtilCore.hasErrorElementChild(expression2)) {
                return false;
            }
            return parent2 instanceof PsiConditionalExpression || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getCondition(), conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getThenExpression(), conditionalExpression) || UnclearBinaryExpressionInspection.isUnclearExpression(conditionalExpression.getElseExpression(), conditionalExpression);
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            if (parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiPolyadicExpression || parent2 instanceof PsiInstanceOfExpression) {
                return true;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                PsiType type2 = operand.getType();
                if (type2 == null || type2.equalsToText("java.lang.String")) {
                    return false;
                }
                if (!UnclearBinaryExpressionInspection.isUnclearExpression(operand, polyadicExpression)) continue;
                return true;
            }
        } else {
            if (expression2 instanceof PsiInstanceOfExpression) {
                if (parent2 instanceof PsiPolyadicExpression || parent2 instanceof PsiConditionalExpression) {
                    return true;
                }
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
                return UnclearBinaryExpressionInspection.isUnclearExpression(instanceOfExpression.getOperand(), instanceOfExpression);
            }
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                PsiExpression nestedExpression = parenthesizedExpression.getExpression();
                return UnclearBinaryExpressionInspection.isUnclearExpression(nestedExpression, parenthesizedExpression);
            }
        }
        return false;
    }

    public static void replaceElement(PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        String newExpressionText = UnclearBinaryExpressionInspection.createReplacementText(expression2, new StringBuilder()).toString();
        PsiReplacementUtil.replaceExpression(expression2, newExpressionText);
    }

    private static StringBuilder createReplacementText(@Nullable PsiExpression expression2, StringBuilder out) {
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiElement parent2 = expression2.getParent();
            boolean parentheses = parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiInstanceOfExpression || parent2 instanceof PsiPolyadicExpression;
            UnclearBinaryExpressionInspection.appendText(polyadicExpression, parentheses, out);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            for (PsiElement child : expression2.getChildren()) {
                if (child instanceof PsiExpression) {
                    PsiExpression unwrappedExpression = (PsiExpression)child;
                    UnclearBinaryExpressionInspection.createReplacementText(unwrappedExpression, out);
                    continue;
                }
                out.append(child.getText());
            }
        } else if (expression2 instanceof PsiInstanceOfExpression) {
            PsiElement parent3 = expression2.getParent();
            boolean parentheses = parent3 instanceof PsiPolyadicExpression || parent3 instanceof PsiConditionalExpression;
            UnclearBinaryExpressionInspection.appendText(expression2, parentheses, out);
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiElement parent4 = expression2.getParent();
            boolean parentheses = parent4 instanceof PsiConditionalExpression || parent4 instanceof PsiPolyadicExpression || parent4 instanceof PsiInstanceOfExpression;
            UnclearBinaryExpressionInspection.appendText(expression2, parentheses, out);
        } else if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            PsiElement parent5 = expression2.getParent();
            boolean parentheses = !UnclearBinaryExpressionInspection.isSimpleAssignment(assignmentExpression, parent5);
            UnclearBinaryExpressionInspection.appendText(assignmentExpression, parentheses, out);
        } else if (expression2 != null) {
            out.append(expression2.getText());
        }
        return out;
    }

    private static boolean isSimpleAssignment(PsiAssignmentExpression assignmentExpression, PsiElement parent2) {
        IElementType parentTokenType;
        if (parent2 instanceof PsiExpressionStatement) {
            return true;
        }
        if (parent2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression parentAssignmentExpression = (PsiAssignmentExpression)parent2;
            parentTokenType = parentAssignmentExpression.getOperationTokenType();
        } else if (parent2 instanceof PsiVariable) {
            parentTokenType = JavaTokenType.EQ;
        } else {
            return false;
        }
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        return parentTokenType.equals(tokenType);
    }

    private static void appendText(PsiExpression expression2, boolean parentheses, StringBuilder out) {
        if (parentheses) {
            out.append('(');
        }
        for (PsiElement child : expression2.getChildren()) {
            if (child instanceof PsiExpression) {
                UnclearBinaryExpressionInspection.createReplacementText((PsiExpression)child, out);
                continue;
            }
            out.append(child.getText());
        }
        if (parentheses) {
            out.append(')');
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnclearBinaryExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnclearBinaryExpressionVisitor
    extends BaseInspectionVisitor {
        private UnclearBinaryExpressionVisitor() {
        }

        @Override
        public void visitExpression(PsiExpression expression2) {
            super.visitExpression(expression2);
            PsiElement parent2 = expression2.getParent();
            if (UnclearBinaryExpressionInspection.mightBeConfusingExpression(parent2) || !UnclearBinaryExpressionInspection.isUnclearExpression(expression2, parent2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class UnclearBinaryExpressionFix
    extends InspectionGadgetsFix {
        private UnclearBinaryExpressionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unclear.binary.expression.quickfix", new Object[0]);
            if (string == null) {
                UnclearBinaryExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            UnclearBinaryExpressionInspection.replaceElement(descriptor2.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnclearBinaryExpressionInspection$UnclearBinaryExpressionFix", "getFamilyName"));
        }
    }
}

