/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySemicolonInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.semicolon.display.name", new Object[0]);
        if (string == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unnecessary.semicolon.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySemicolonInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySemicolonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new UnnecessarySemicolonFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file2) {
        return !LanguageUtil.isInTemplateLanguageFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarySemicolonInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarySemicolonVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySemicolonVisitor() {
        }

        @Override
        public void visitFile(PsiFile file2) {
            this.findTopLevelSemicolons(file2);
            super.visitFile(file2);
        }

        @Override
        public void visitImportList(PsiImportList list2) {
            this.findTopLevelSemicolons(list2);
            super.visitImportList(list2);
        }

        @Override
        public void visitModule(PsiJavaModule module2) {
            this.findTopLevelSemicolons(module2);
            super.visitModule(module2);
        }

        private void findTopLevelSemicolons(PsiElement element) {
            PsiElement sibling = element.getFirstChild();
            while (sibling != null) {
                if (sibling instanceof PsiErrorElement) {
                    return;
                }
                if (PsiUtil.isJavaToken(sibling, JavaTokenType.SEMICOLON)) {
                    this.registerError(sibling, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                }
                sibling = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(sibling);
            }
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiElement element;
            if (aClass2 == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass2);
            this.findUnnecessarySemicolonsAfterEnumConstants(aClass2);
            if (!aClass2.isEnum()) {
                return;
            }
            PsiField[] fields2 = aClass2.getFields();
            if (fields2.length > 0) {
                PsiField lastField = fields2[fields2.length - 1];
                if (!(lastField instanceof PsiEnumConstant)) {
                    return;
                }
                element = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(lastField);
            } else {
                PsiElement lBrace = aClass2.getLBrace();
                element = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(lBrace);
            }
            if (!(element instanceof PsiJavaToken)) {
                return;
            }
            PsiJavaToken token = (PsiJavaToken)element;
            IElementType tokenType = token.getTokenType();
            if (!tokenType.equals(JavaTokenType.SEMICOLON)) {
                return;
            }
            PsiElement next = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(element);
            if (next == null || !next.equals(aClass2.getRBrace())) {
                return;
            }
            this.registerError(element, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private void findUnnecessarySemicolonsAfterEnumConstants(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                UnnecessarySemicolonVisitor.$$$reportNull$$$0(1);
            }
            PsiElement child = aClass2.getFirstChild();
            while (child != null) {
                PsiElement prevSibling;
                PsiJavaToken token;
                IElementType tokenType;
                if (child instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)child).getTokenType()).equals(JavaTokenType.SEMICOLON) && !((prevSibling = UnnecessarySemicolonVisitor.skipBackwardWhiteSpacesAndComments(child)) instanceof PsiEnumConstant)) {
                    if (prevSibling instanceof PsiJavaToken) {
                        IElementType prevTokenType = ((PsiJavaToken)prevSibling).getTokenType();
                        if (!JavaTokenType.COMMA.equals(prevTokenType) && !JavaTokenType.LBRACE.equals(prevTokenType)) {
                            this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                    } else {
                        this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                    }
                }
                child = UnnecessarySemicolonVisitor.skipForwardWhiteSpacesAndComments(child);
            }
        }

        @Nullable
        private static PsiElement skipForwardWhiteSpacesAndComments(PsiElement element) {
            return PsiTreeUtil.skipWhitespacesAndCommentsForward(element);
        }

        @Nullable
        private static PsiElement skipBackwardWhiteSpacesAndComments(PsiElement element) {
            return PsiTreeUtil.skipWhitespacesAndCommentsBackward(element);
        }

        @Override
        public void visitEmptyStatement(PsiEmptyStatement statement2) {
            super.visitEmptyStatement(statement2);
            PsiElement parent2 = statement2.getParent();
            if (parent2 instanceof PsiCodeBlock) {
                PsiElement semicolon = statement2.getFirstChild();
                if (semicolon == null) {
                    return;
                }
                this.registerError(semicolon, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }

        @Override
        public void visitResourceList(PsiResourceList resourceList) {
            PsiElement prev;
            super.visitResourceList(resourceList);
            PsiElement last2 = resourceList.getLastChild();
            if (PsiUtil.isJavaToken(last2, JavaTokenType.RPARENTH) && PsiUtil.isJavaToken(prev = UnnecessarySemicolonVisitor.skipBackwardWhiteSpacesAndComments(last2), JavaTokenType.SEMICOLON)) {
                this.registerError(prev, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "aClass";
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findUnnecessarySemicolonsAfterEnumConstants";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnnecessarySemicolonFix
    extends InspectionGadgetsFix {
        private UnnecessarySemicolonFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.semicolon.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySemicolonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement semicolonElement = descriptor2.getPsiElement();
            PsiElement parent2 = semicolonElement.getParent();
            if (parent2 instanceof PsiEmptyStatement) {
                PsiElement lastChild = parent2.getLastChild();
                if (lastChild instanceof PsiComment) {
                    parent2.replace(lastChild);
                } else {
                    UnnecessarySemicolonFix.deleteElement(parent2);
                }
            } else {
                UnnecessarySemicolonFix.deleteElement(semicolonElement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarySemicolonInspection$UnnecessarySemicolonFix", "getFamilyName"));
        }
    }
}

