/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AssertHint {
    private final int myArgIndex;
    private final boolean myMessageOnFirstPosition;
    private final PsiExpression myMessage;
    private final PsiMethod myMethod;

    private AssertHint(int index2, boolean messageOnFirstPosition, PsiExpression message, PsiMethod method) {
        this.myArgIndex = index2;
        this.myMessageOnFirstPosition = messageOnFirstPosition;
        this.myMessage = message;
        this.myMethod = method;
    }

    public boolean isMessageOnFirstPosition() {
        return this.myMessageOnFirstPosition;
    }

    public int getArgIndex() {
        return this.myArgIndex;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiExpression getPosition(PsiExpression[] arguments2) {
        return arguments2[this.myArgIndex];
    }

    @Nullable
    public PsiExpression getMessage() {
        return this.myMessage;
    }

    public static AssertHint createAssertEqualsHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, methodName -> "assertEquals".equals(methodName) ? Integer.valueOf(2) : null, checkTestNG);
    }

    public static AssertHint createAssertTrueFalseHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, methodName -> "assertTrue".equals(methodName) || "assertFalse".equals(methodName) ? Integer.valueOf(1) : null, checkTestNG);
    }

    public static AssertHint create(PsiMethodCallExpression expression2, Function<String, Integer> methodNameToParamCount, boolean checkTestNG) {
        int argumentIndex;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length < minimumParamCount) {
            return null;
        }
        PsiExpressionList argumentList2 = expression2.getArgumentList();
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        PsiExpression message = null;
        if (messageOnFirstPosition) {
            if (parameters2.length > 0 && parameters2[0].getType().equalsToText("java.lang.String") && parameters2.length > minimumParamCount) {
                argumentIndex = 1;
                message = arguments2[0];
            } else {
                argumentIndex = 0;
            }
        } else {
            int lastParameterIdx;
            argumentIndex = 0;
            if (parameters2.length > minimumParamCount && minimumParamCount >= 0 && parameters2[lastParameterIdx = parameters2.length - 1].getType() instanceof PsiClassType) {
                message = arguments2[lastParameterIdx];
            }
        }
        return new AssertHint(argumentIndex, messageOnFirstPosition, message, method);
    }

    public static boolean isMessageOnFirstPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName2 = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.AssertJUnit".equals(qualifiedName2) || "org.testng.Assert".equals(qualifiedName2) && "fail".equals(method.getName());
        }
        return "junit.framework.Assert".equals(qualifiedName2) || "org.junit.Assert".equals(qualifiedName2) || "junit.framework.TestCase".equals(qualifiedName2) || "org.junit.Assume".equals(qualifiedName2);
    }

    public static boolean isMessageOnLastPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName2 = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.Assert".equals(qualifiedName2) && !"fail".equals(method.getName());
        }
        return "org.junit.jupiter.api.Assertions".equals(qualifiedName2) || "org.junit.jupiter.api.Assumptions".equals(qualifiedName2);
    }

    public static String areExpectedActualTypesCompatible(PsiMethodCallExpression expression2, boolean checkTestNG) {
        int argIndex;
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, checkTestNG);
        if (assertHint == null) {
            return null;
        }
        PsiExpression[] arguments2 = expression2.getArgumentList().getExpressions();
        PsiType type1 = arguments2[argIndex = assertHint.getArgIndex()].getType();
        if (type1 == null) {
            return null;
        }
        PsiType type2 = arguments2[argIndex + 1].getType();
        if (type2 == null) {
            return null;
        }
        PsiParameter[] parameters2 = assertHint.getMethod().getParameterList().getParameters();
        PsiType parameterType1 = parameters2[argIndex].getType();
        PsiType parameterType2 = parameters2[argIndex + 1].getType();
        PsiClassType objectType = TypeUtils.getObjectType(expression2);
        if (!objectType.equals(parameterType1) || !objectType.equals(parameterType2)) {
            return null;
        }
        if (TypeUtils.areConvertible(type1, type2)) {
            return null;
        }
        String comparedTypeText = type1.getPresentableText();
        String comparisonTypeText = type2.getPresentableText();
        return InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXml(comparedTypeText), StringUtil.escapeXml(comparisonTypeText));
    }

    public static class JUnitCommonAssertNames {
        @NonNls
        public static final Map<String, Integer> ASSERT_METHOD_2_PARAMETER_COUNT;

        static {
            HashMap<String, Integer> map2 = new HashMap<String, Integer>(13);
            map2.put("assertArrayEquals", 2);
            map2.put("assertEquals", 2);
            map2.put("assertNotEquals", 2);
            map2.put("assertFalse", 1);
            map2.put("assumeFalse", 1);
            map2.put("assertNotNull", 1);
            map2.put("assertNotSame", 2);
            map2.put("assertNull", 1);
            map2.put("assertSame", 2);
            map2.put("assertThat", 2);
            map2.put("assertTrue", 1);
            map2.put("assumeTrue", 1);
            map2.put("fail", 0);
            ASSERT_METHOD_2_PARAMETER_COUNT = Collections.unmodifiableMap(map2);
        }
    }
}

