/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class SimplifiableAssertionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos2[0]);
        if (string == null) {
            SimplifiableAssertionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos2) {
        return new SimplifyAssertFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    protected abstract boolean checkTestNG();

    static boolean isAssertThatCouldBeFail(PsiExpression position, boolean checkTrue) {
        return (checkTrue ? "true" : "false").equals(position.getText());
    }

    boolean isAssertEqualsThatCouldBeAssertLiteral(PsiMethodCallExpression expression2) {
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, this.checkTestNG());
        if (assertHint == null) {
            return false;
        }
        PsiExpressionList argumentList2 = expression2.getArgumentList();
        PsiExpression[] arguments2 = argumentList2.getExpressions();
        int argIndex = assertHint.getArgIndex();
        PsiExpression firstTestArgument = arguments2[argIndex];
        PsiExpression secondTestArgument = arguments2[argIndex + 1];
        if (firstTestArgument == null || secondTestArgument == null) {
            return false;
        }
        return SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument) || SimplifiableAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression1.getText();
        if ("null".equals(text2)) {
            return true;
        }
        if (!"true".equals(text2) && !"false".equals(text2)) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return PsiType.BOOLEAN.equals(type2);
    }

    private static boolean isEqualityComparison(PsiExpression expression2) {
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type2 = lhs.getType();
            return type2 != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(type2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call2 = (PsiMethodCallExpression)expression2;
            if (!MethodCallUtils.isEqualsCall(call2)) {
                return false;
            }
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            return methodExpression.getQualifierExpression() != null;
        }
        return false;
    }

    private static boolean isIdentityComparison(PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        if (!ComparisonUtils.isEqualityComparison(binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static boolean isAssertTrue(AssertHint assertTrueFalseHint) {
        return "assertTrue".equals(assertTrueFalseHint.getMethod().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection", "buildErrorString"));
    }

    private class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SimplifiableJUnitAssertionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(expression2)) {
                this.registerMethodCallError(expression2, this.getReplacementMethodName(expression2));
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(expression2, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(expression2.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.registerMethodCallError(expression2, this.hasEqEqExpressionArgument(position) ? "assertNull()" : "assertNotNull()");
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.registerMethodCallError(expression2, this.hasEqEqExpressionArgument(position) ? "assertSame()" : "assertNotSame()");
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.registerMethodCallError(expression2, "assertEquals()");
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.registerMethodCallError(expression2, "fail()");
                }
            }
        }

        @NonNls
        private String getReplacementMethodName(PsiMethodCallExpression expression2) {
            PsiLiteralExpression literalExpression;
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            PsiExpression firstArgument = arguments2[0];
            PsiExpression secondArgument = arguments2[1];
            if (firstArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)firstArgument;
            } else if (secondArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)secondArgument;
            } else {
                return "";
            }
            Object value = literalExpression.getValue();
            if (value == Boolean.TRUE) {
                return "assertTrue()";
            }
            if (value == Boolean.FALSE) {
                return "assertFalse()";
            }
            if (value == null) {
                return "assertNull()";
            }
            return "";
        }

        private boolean hasEqEqExpressionArgument(PsiExpression argument) {
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifiableJUnitAssertionVisitor", "visitMethodCallExpression"));
        }
    }

    private class SimplifyAssertFix
    extends InspectionGadgetsFix {
        private SimplifyAssertFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifyAssertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement methodNameIdentifier = descriptor2.getPsiElement();
            PsiElement parent2 = methodNameIdentifier.getParent();
            if (parent2 == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent2.getParent();
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(callExpression)) {
                this.replaceAssertEqualsWithAssertLiteral(callExpression);
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(callExpression.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.replaceAssertWithAssertNull(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.replaceAssertWithAssertSame(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.replaceAssertTrueWithAssertEquals(callExpression, position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.replaceAssertWithFail(callExpression, assertTrueFalseHint.getMessage());
                }
            }
        }

        private void addStaticImportOrQualifier(String methodName, PsiMethodCallExpression originalMethodCall, StringBuilder out) {
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = originalMethodCall.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className2 = containingClass.getQualifiedName();
                if (className2 == null) {
                    return;
                }
                if (!ImportUtils.addStaticImport(className2, methodName, originalMethodCall)) {
                    out.append(className2).append(".");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private void replaceAssertWithFail(PsiMethodCallExpression callExpression, PsiExpression message) {
            StringBuilder newExpression = new StringBuilder();
            this.addStaticImportOrQualifier("fail", callExpression, newExpression);
            newExpression.append("fail(");
            if (message != null) {
                newExpression.append(message.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void replaceAssertTrueWithAssertEquals(PsiMethodCallExpression callExpression, PsiExpression position, PsiExpression message, int positionIndex) {
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (position instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)position;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else if (position instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call2 = (PsiMethodCallExpression)position;
                PsiReferenceExpression equalityMethodExpression = call2.getMethodExpression();
                PsiExpressionList equalityArgumentList = call2.getArgumentList();
                PsiExpression[] equalityArgs = equalityArgumentList.getExpressions();
                rhs = equalityArgs[0];
                lhs = equalityMethodExpression.getQualifierExpression();
            }
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assertEquals";
            StringBuilder buf = new StringBuilder();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher(lhs)) {
                if (this.isPrimitiveAndBoxedInteger(lhsType, rhsType)) {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(rhsType);
                    assert (unboxedType != null);
                    buf.append(lhs.getText()).append(",(").append(unboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else if (this.isPrimitiveAndBoxedInteger(rhsType, lhsType)) {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(lhsType);
                    assert (unboxedType != null);
                    buf.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                } else {
                    buf.append(lhs.getText()).append(',').append(rhs.getText());
                }
            } else {
                buf.append(lhs.getText()).append(',').append(rhs.getText());
            }
            if (TypeUtils.hasFloatingPointType(lhs) || TypeUtils.hasFloatingPointType(rhs) || this.isPrimitiveAndBoxedFloat(lhsType, rhsType) || this.isPrimitiveAndBoxedFloat(rhsType, lhsType)) {
                buf.append(",0.0");
            }
            this.compoundMethodCall(callExpression, "assertEquals", message, positionIndex, buf.toString(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private boolean isPrimitiveAndBoxedInteger(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.LONG.isAssignableFrom(rhsType);
        }

        private boolean isPrimitiveAndBoxedFloat(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.DOUBLE.equals(rhsType) && PsiType.FLOAT.equals(rhsType);
        }

        private void replaceAssertWithAssertNull(PsiMethodCallExpression callExpression, PsiBinaryExpression binaryExpression, PsiExpression message, int positionIndex) {
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                rhs = lhs;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            this.compoundMethodCall(callExpression, memberName, message, positionIndex, rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void compoundMethodCall(PsiMethodCallExpression callExpression, String methodName, PsiExpression message, int positionIndex, String args, StringBuilder newExpression) {
            this.addStaticImportOrQualifier(methodName, callExpression, newExpression);
            newExpression.append(methodName).append('(');
            if (message != null && positionIndex != 0) {
                newExpression.append(message.getText()).append(',');
            }
            newExpression.append(args);
            if (message != null && positionIndex == 0) {
                newExpression.append(',').append(message.getText());
            }
            newExpression.append(')');
        }

        private void replaceAssertWithAssertSame(PsiMethodCallExpression callExpression, PsiBinaryExpression position, PsiExpression message, int positionIndex) {
            PsiExpression lhs = position.getLOperand();
            PsiExpression rhs = position.getROperand();
            IElementType tokenType = position.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            this.compoundMethodCall(callExpression, memberName, message, positionIndex, lhs.getText() + "," + rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private void replaceAssertEqualsWithAssertLiteral(PsiMethodCallExpression callExpression) {
            String compareValue;
            String literalValue;
            PsiExpression secondTestArgument;
            int argIndex;
            AssertHint assertHint = AssertHint.createAssertEqualsHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList2 = callExpression.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            PsiExpression firstTestArgument = arguments2[argIndex = assertHint.getArgIndex()];
            if (SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = arguments2[argIndex + 1])) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assert" + uppercaseLiteralValue;
            this.compoundMethodCall(callExpression, methodName, assertHint.getMessage(), argIndex, compareValue, newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten(callExpression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/SimplifiableAssertionInspection$SimplifyAssertFix", "getFamilyName"));
        }
    }
}

