/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SleepWhileHoldingLockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("sleep.while.holding.lock.display.name", new Object[0]);
        if (string == null) {
            SleepWhileHoldingLockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("sleep.while.holding.lock.problem.descriptor", new Object[0]);
        if (string == null) {
            SleepWhileHoldingLockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SleepWhileHoldingLockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SleepWhileHoldingLockInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SleepWhileHoldingLockVisitor
    extends BaseInspectionVisitor {
        private SleepWhileHoldingLockVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiSynchronizedStatement containingSyncStatement;
            if (expression2 == null) {
                SleepWhileHoldingLockVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"sleep".equals(methodName)) {
                return;
            }
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, true, PsiClass.class, PsiLambdaExpression.class);
            boolean isSynced = false;
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                isSynced = true;
            }
            if ((containingSyncStatement = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiSynchronizedStatement.class, true, PsiClass.class, PsiLambdaExpression.class)) != null) {
                isSynced = true;
            }
            if (!isSynced) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null || !InheritanceUtil.isInheritor(methodClass, "java.lang.Thread")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SleepWhileHoldingLockInspection$SleepWhileHoldingLockVisitor", "visitMethodCallExpression"));
        }
    }
}

