/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreadPriorityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("CallToThreadSetPriority" == null) {
            ThreadPriorityInspection.$$$reportNull$$$0(0);
        }
        return "CallToThreadSetPriority";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.priority.display.name", new Object[0]);
        if (string == null) {
            ThreadPriorityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("thread.priority.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadPriorityInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadSetPriorityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/ThreadPriorityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThreadSetPriorityVisitor
    extends BaseInspectionVisitor {
        private ThreadSetPriorityVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                ThreadSetPriorityVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(methodCallExpression);
            if (!ThreadSetPriorityVisitor.isThreadSetPriority(methodCallExpression)) {
                return;
            }
            if (ThreadSetPriorityVisitor.hasNormalPriorityArgument(methodCallExpression)) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }

        private static boolean isThreadSetPriority(@NotNull PsiMethodCallExpression methodCallExpression) {
            if (methodCallExpression == null) {
                ThreadSetPriorityVisitor.$$$reportNull$$$0(1);
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String setPriority = "setPriority";
            if (!"setPriority".equals(methodName)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return false;
            }
            String className2 = aClass2.getQualifiedName();
            return "java.lang.Thread".equals(className2);
        }

        private static boolean hasNormalPriorityArgument(@NotNull PsiMethodCallExpression methodCallExpression) {
            PsiExpressionList argumentList2;
            PsiExpression[] expressions;
            if (methodCallExpression == null) {
                ThreadSetPriorityVisitor.$$$reportNull$$$0(2);
            }
            if ((expressions = (argumentList2 = methodCallExpression.getArgumentList()).getExpressions()).length != 1) {
                return false;
            }
            PsiExpression expression2 = expressions[0];
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            String referenceName = referenceExpression.getReferenceName();
            String normPriority = "NORM_PRIORITY";
            if (!"NORM_PRIORITY".equals(referenceName)) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (!(element instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)element;
            PsiClass aClass2 = field.getContainingClass();
            String className2 = aClass2.getQualifiedName();
            return "java.lang.Thread".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "methodCallExpression";
            objectArray2[1] = "com/siyeh/ig/threading/ThreadPriorityInspection$ThreadSetPriorityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isThreadSetPriority";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasNormalPriorityArgument";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

