/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UnconditionalWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unconditional.wait.display.name", new Object[0]);
        if (string == null) {
            UnconditionalWaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("unconditional.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            UnconditionalWaitInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/UnconditionalWaitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                UnconditionalWaitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                this.checkBody(body2);
            }
        }

        @Override
        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            if (statement2 == null) {
                UnconditionalWaitVisitor.$$$reportNull$$$0(1);
            }
            super.visitSynchronizedStatement(statement2);
            PsiCodeBlock body2 = statement2.getBody();
            if (body2 != null) {
                this.checkBody(body2);
            }
        }

        private void checkBody(PsiCodeBlock body2) {
            PsiStatement[] statements = body2.getStatements();
            if (statements.length == 0) {
                return;
            }
            for (PsiStatement statement2 : statements) {
                PsiType parameterType;
                PsiParameterList parameterList;
                int numParams;
                PsiMethod method;
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                String methodName;
                PsiExpression firstExpression;
                if (UnconditionalWaitVisitor.isConditional(statement2)) {
                    return;
                }
                if (!(statement2 instanceof PsiExpressionStatement) || !((firstExpression = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiMethodCallExpression) || !"wait".equals(methodName = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)firstExpression).getMethodExpression()).getReferenceName()) || (method = methodCallExpression.resolveMethod()) == null || (numParams = (parameterList = method.getParameterList()).getParametersCount()) > 2) continue;
                PsiParameter[] parameters2 = parameterList.getParameters();
                if (numParams > 0 && !(parameterType = parameters2[0].getType()).equals(PsiType.LONG) || numParams > 1 && !(parameterType = parameters2[1].getType()).equals(PsiType.INT)) continue;
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(PsiStatement statement2) {
            return statement2 instanceof PsiIfStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/UnconditionalWaitInspection$UnconditionalWaitVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

