/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @Override
    @NotNull
    public String getID() {
        if ("LocalVariableHidesMemberVariable" == null) {
            LocalVariableHidingMemberVariableInspectionBase.$$$reportNull$$$0(0);
        }
        return "LocalVariableHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.display.name", new Object[0]);
        if (string == null) {
            LocalVariableHidingMemberVariableInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass aClass2 = (PsiClass)infos2[0];
        String string = InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", aClass2.getName());
        if (string == null) {
            LocalVariableHidingMemberVariableInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        @Override
        public void visitLocalVariable(@NotNull PsiLocalVariable variable2) {
            if (variable2 == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitLocalVariable(variable2);
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && this.isContainedInStaticMethod(variable2)) {
                return;
            }
            PsiClass aClass2 = this.checkFieldNames(variable2);
            if (aClass2 == null) {
                return;
            }
            this.registerVariableError(variable2, aClass2);
        }

        @Override
        public void visitParameter(@NotNull PsiParameter variable2) {
            if (variable2 == null) {
                LocalVariableHidingMemberVariableVisitor.$$$reportNull$$$0(1);
            }
            super.visitParameter(variable2);
            PsiElement declarationScope = variable2.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection) && !(declarationScope instanceof PsiForeachStatement)) {
                return;
            }
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && this.isContainedInStaticMethod(variable2)) {
                return;
            }
            PsiClass aClass2 = this.checkFieldNames(variable2);
            if (aClass2 == null) {
                return;
            }
            this.registerVariableError(variable2, aClass2);
        }

        @Nullable
        private PsiClass checkFieldNames(PsiVariable variable2) {
            PsiClass aClass2 = ClassUtils.getContainingClass(variable2);
            String variableName = variable2.getName();
            if (variableName == null) {
                return null;
            }
            while (aClass2 != null) {
                PsiField[] fields2;
                for (PsiField field : fields2 = aClass2.getAllFields()) {
                    String fieldName = field.getName();
                    if (!variableName.equals(fieldName) || LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass2)) continue;
                    return aClass2;
                }
                if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && (aClass2.hasModifierProperty("static") || this.isContainedInStaticMethod(aClass2))) {
                    return null;
                }
                aClass2 = ClassUtils.getContainingClass(aClass2);
            }
            return null;
        }

        private boolean isContainedInStaticMethod(PsiElement element) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiClassInitializer.class, PsiClass.class);
            if (member instanceof PsiClass) {
                return false;
            }
            return member != null && member.hasModifierProperty("static");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/siyeh/ig/visibility/LocalVariableHidingMemberVariableInspectionBase$LocalVariableHidingMemberVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

