/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Platform;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.platform.win32.User32;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;

public class KeyboardUtils {
    static final NativeKeyboardUtils INSTANCE;

    public static boolean isPressed(int keycode, int location2) {
        return INSTANCE.isPressed(keycode, location2);
    }

    public static boolean isPressed(int keycode) {
        return INSTANCE.isPressed(keycode);
    }

    static {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("KeyboardUtils requires a keyboard");
        }
        if (Platform.isWindows()) {
            INSTANCE = new W32KeyboardUtils();
        } else {
            if (Platform.isMac()) {
                INSTANCE = new MacKeyboardUtils();
                throw new UnsupportedOperationException("No support (yet) for " + System.getProperty("os.name"));
            }
            INSTANCE = new X11KeyboardUtils();
        }
    }

    private static class X11KeyboardUtils
    extends NativeKeyboardUtils {
        private X11KeyboardUtils() {
        }

        private int toKeySym(int code2, int location2) {
            if (code2 >= 65 && code2 <= 90) {
                return 97 + (code2 - 65);
            }
            if (code2 >= 48 && code2 <= 57) {
                return 48 + (code2 - 48);
            }
            if (code2 == 16) {
                if ((location2 & 3) != 0) {
                    return 65505;
                }
                return 65505;
            }
            if (code2 == 17) {
                if ((location2 & 3) != 0) {
                    return 65508;
                }
                return 65507;
            }
            if (code2 == 18) {
                if ((location2 & 3) != 0) {
                    return 65514;
                }
                return 65513;
            }
            if (code2 == 157) {
                if ((location2 & 3) != 0) {
                    return 65512;
                }
                return 65511;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPressed(int keycode, int location2) {
            X11 lib = X11.INSTANCE;
            X11.Display dpy = lib.XOpenDisplay(null);
            if (dpy == null) {
                throw new Error("Can't open X Display");
            }
            try {
                byte[] keys2 = new byte[32];
                lib.XQueryKeymap(dpy, keys2);
                int keysym = this.toKeySym(keycode, location2);
                for (int code2 = 5; code2 < 256; ++code2) {
                    int sym;
                    int idx = code2 / 8;
                    int shift = code2 % 8;
                    if ((keys2[idx] & 1 << shift) == 0 || (sym = lib.XKeycodeToKeysym(dpy, (byte)code2, 0).intValue()) != keysym) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                lib.XCloseDisplay(dpy);
            }
            return false;
        }
    }

    private static class MacKeyboardUtils
    extends NativeKeyboardUtils {
        private MacKeyboardUtils() {
        }

        @Override
        public boolean isPressed(int keycode, int location2) {
            return false;
        }
    }

    private static class W32KeyboardUtils
    extends NativeKeyboardUtils {
        private W32KeyboardUtils() {
        }

        private int toNative(int code2, int loc) {
            if (code2 >= 65 && code2 <= 90 || code2 >= 48 && code2 <= 57) {
                return code2;
            }
            if (code2 == 16) {
                if ((loc & 3) != 0) {
                    return 161;
                }
                if ((loc & 2) != 0) {
                    return 160;
                }
                return 16;
            }
            if (code2 == 17) {
                if ((loc & 3) != 0) {
                    return 163;
                }
                if ((loc & 2) != 0) {
                    return 162;
                }
                return 17;
            }
            if (code2 == 18) {
                if ((loc & 3) != 0) {
                    return 165;
                }
                if ((loc & 2) != 0) {
                    return 164;
                }
                return 18;
            }
            return 0;
        }

        @Override
        public boolean isPressed(int keycode, int location2) {
            User32 lib = User32.INSTANCE;
            return (lib.GetAsyncKeyState(this.toNative(keycode, location2)) & 0x8000) != 0;
        }
    }

    private static abstract class NativeKeyboardUtils {
        private NativeKeyboardUtils() {
        }

        public abstract boolean isPressed(int var1, int var2);

        public boolean isPressed(int keycode) {
            return this.isPressed(keycode, 0);
        }
    }
}

