/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.VariableDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueParameterDescriptorImpl
extends VariableDescriptorImpl
implements ValueParameterDescriptor {
    private final ValueParameterDescriptor original;
    private final int index;
    private final boolean declaresDefaultValue;
    private final boolean isCrossinline;
    private final boolean isNoinline;
    @Nullable
    private final KotlinType varargElementType;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public CallableDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = super.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
        }
        return (CallableDescriptor)declarationDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean declaresDefaultValue() {
        if (!this.declaresDefaultValue) return false;
        CallableDescriptor callableDescriptor = this.getContainingDeclaration();
        if (callableDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
        }
        CallableMemberDescriptor.Kind kind = ((CallableMemberDescriptor)callableDescriptor).getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)kind, "(containingDeclaration a\u2026bleMemberDescriptor).kind");
        if (!kind.isReal()) return false;
        return true;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor getOriginal() {
        return this.original == this ? (ValueParameterDescriptor)this : this.original.getOriginal();
    }

    @Override
    @NotNull
    public ValueParameterDescriptor substitute(@NotNull TypeSubstitutor substitutor2) {
        Intrinsics.checkParameterIsNotNull(substitutor2, "substitutor");
        if (substitutor2.isEmpty()) {
            return this;
        }
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitValueParameterDescriptor(this, data2);
    }

    @Override
    public boolean isVar() {
        return false;
    }

    @Nullable
    public Void getCompileTimeInitializer() {
        return null;
    }

    @Override
    @NotNull
    public ValueParameterDescriptor copy(@NotNull CallableDescriptor newOwner, @NotNull Name newName2, int newIndex) {
        Intrinsics.checkParameterIsNotNull(newOwner, "newOwner");
        Intrinsics.checkParameterIsNotNull(newName2, "newName");
        Annotations annotations2 = this.getAnnotations();
        Intrinsics.checkExpressionValueIsNotNull(annotations2, "annotations");
        KotlinType kotlinType = this.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
        boolean bl = this.declaresDefaultValue();
        boolean bl2 = this.isCrossinline();
        boolean bl3 = this.isNoinline();
        KotlinType kotlinType2 = this.getVarargElementType();
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkExpressionValueIsNotNull(sourceElement, "SourceElement.NO_SOURCE");
        return new ValueParameterDescriptorImpl(newOwner, null, newIndex, annotations2, newName2, kotlinType, bl, bl2, bl3, kotlinType2, sourceElement);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return Visibilities.LOCAL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<ValueParameterDescriptor> getOverriddenDescriptors() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<? extends CallableDescriptor> collection = this.getContainingDeclaration().getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection, "containingDeclaration.overriddenDescriptors");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CallableDescriptor callableDescriptor = (CallableDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            ValueParameterDescriptor valueParameterDescriptor = v1.getValueParameters().get(this.getIndex());
            collection2.add(valueParameterDescriptor);
        }
        return (List)var3_3;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isCrossinline() {
        return this.isCrossinline;
    }

    @Override
    public boolean isNoinline() {
        return this.isNoinline;
    }

    @Override
    @Nullable
    public KotlinType getVarargElementType() {
        return this.varargElementType;
    }

    public ValueParameterDescriptorImpl(@NotNull CallableDescriptor containingDeclaration, @Nullable ValueParameterDescriptor original, int index2, @NotNull Annotations annotations2, @NotNull Name name, @NotNull KotlinType outType, boolean declaresDefaultValue, boolean isCrossinline, boolean isNoinline, @Nullable KotlinType varargElementType, @NotNull SourceElement source2) {
        Intrinsics.checkParameterIsNotNull(containingDeclaration, "containingDeclaration");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(outType, "outType");
        Intrinsics.checkParameterIsNotNull(source2, "source");
        super(containingDeclaration, annotations2, name, outType, source2);
        this.index = index2;
        this.declaresDefaultValue = declaresDefaultValue;
        this.isCrossinline = isCrossinline;
        this.isNoinline = isNoinline;
        this.varargElementType = varargElementType;
        ValueParameterDescriptor valueParameterDescriptor = original;
        if (valueParameterDescriptor == null) {
            valueParameterDescriptor = this;
        }
        this.original = valueParameterDescriptor;
    }

    @Override
    public boolean isLateInit() {
        return ValueParameterDescriptor.DefaultImpls.isLateInit(this);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

