/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import kotlin.reflect.jvm.internal.impl.serialization.PackageData;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedDescriptorResolver {
    @NotNull
    public DeserializationComponents components;
    @NotNull
    private static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS;
    private static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
    private static final JvmMetadataVersion KOTLIN_1_1_EAP_METADATA_VERSION;
    public static final Companion Companion;

    @NotNull
    public final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        return deserializationComponents;
    }

    public final void setComponents(@NotNull DeserializationComponentsForJava components) {
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.components = components.getComponents();
    }

    private final boolean getSkipMetadataVersionCheck() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        return deserializationComponents.getConfiguration().getSkipMetadataVersionCheck();
    }

    @Nullable
    public final ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass2) {
        Intrinsics.checkParameterIsNotNull(kotlinClass2, "kotlinClass");
        ClassDataWithSource classDataWithSource = this.readClassData$descriptors_jvm(kotlinClass2);
        if (classDataWithSource == null) {
            return null;
        }
        ClassDataWithSource classData = classDataWithSource;
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        return deserializationComponents.getClassDeserializer().deserializeClass(kotlinClass2.getClassId(), classData);
    }

    @Nullable
    public final ClassDataWithSource readClassData$descriptors_jvm(@NotNull KotlinJvmBinaryClass kotlinClass2) {
        ClassData classData;
        Intrinsics.checkParameterIsNotNull(kotlinClass2, "kotlinClass");
        String[] stringArray = this.readData$descriptors_jvm(kotlinClass2, Companion.getKOTLIN_CLASS$descriptors_jvm());
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        String[] stringArray2 = kotlinClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            return null;
        }
        String[] strings = stringArray2;
        DeserializedDescriptorResolver this_$iv = this;
        try {
            try {
                classData = JvmProtoBufUtil.readClassDataFrom(data2, strings);
            }
            catch (InvalidProtocolBufferException e$iv) {
                throw (Throwable)new IllegalStateException("Could not read data from " + kotlinClass2.getLocation(), e$iv);
            }
        }
        catch (Throwable e$iv) {
            if (this_$iv.getSkipMetadataVersionCheck() || kotlinClass2.getClassHeader().getMetadataVersion().isCompatible()) {
                throw e$iv;
            }
            classData = null;
        }
        if (classData == null) {
            return null;
        }
        ClassData classData2 = classData;
        KotlinJvmBinarySourceElement source2 = new KotlinJvmBinarySourceElement(kotlinClass2, this.getIncompatibility(kotlinClass2), this.isPreReleaseInvisible(kotlinClass2));
        return new ClassDataWithSource(classData2, source2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MemberScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass2) {
        void nameResolver;
        PackageData packageData;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(kotlinClass2, "kotlinClass");
        String[] stringArray = this.readData$descriptors_jvm(kotlinClass2, DeserializedDescriptorResolver.Companion.getKOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART());
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        String[] stringArray2 = kotlinClass2.getClassHeader().getStrings();
        if (stringArray2 == null) {
            return null;
        }
        String[] strings = stringArray2;
        DeserializedDescriptorResolver this_$iv = this;
        try {
            try {
                packageData = JvmProtoBufUtil.readPackageDataFrom(data2, strings);
            }
            catch (InvalidProtocolBufferException e$iv) {
                throw (Throwable)new IllegalStateException("Could not read data from " + kotlinClass2.getLocation(), e$iv);
            }
        }
        catch (Throwable e$iv) {
            if (this_$iv.getSkipMetadataVersionCheck() || kotlinClass2.getClassHeader().getMetadataVersion().isCompatible()) {
                throw e$iv;
            }
            packageData = null;
        }
        if (packageData == null) {
            return null;
        }
        PackageData packageData2 = packageData;
        NameResolver nameResolver2 = packageData2.component1();
        ProtoBuf.Package packageProto = packageData2.component2();
        JvmPackagePartSource source2 = new JvmPackagePartSource(kotlinClass2, packageProto, (NameResolver)nameResolver, this.getIncompatibility(kotlinClass2), this.isPreReleaseInvisible(kotlinClass2));
        DeserializedContainerSource deserializedContainerSource = source2;
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        return new DeserializedPackageMemberScope(descriptor2, packageProto, (NameResolver)nameResolver, deserializedContainerSource, deserializationComponents, createKotlinPackagePartScope.2.INSTANCE);
    }

    private final IncompatibleVersionErrorData<JvmMetadataVersion> getIncompatibility(@NotNull KotlinJvmBinaryClass $receiver) {
        if (this.getSkipMetadataVersionCheck() || $receiver.getClassHeader().getMetadataVersion().isCompatible()) {
            return null;
        }
        return new IncompatibleVersionErrorData<BinaryVersion>($receiver.getClassHeader().getMetadataVersion(), JvmMetadataVersion.INSTANCE, $receiver.getLocation(), $receiver.getClassId());
    }

    private final boolean isPreReleaseInvisible(@NotNull KotlinJvmBinaryClass $receiver) {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents == null) {
            Intrinsics.throwUninitializedPropertyAccessException("components");
        }
        return deserializationComponents.getConfiguration().getReportErrorsOnPreReleaseDependencies() && ($receiver.getClassHeader().isPreRelease() || Intrinsics.areEqual($receiver.getClassHeader().getMetadataVersion(), DeserializedDescriptorResolver.Companion.getKOTLIN_1_1_EAP_METADATA_VERSION()));
    }

    @Nullable
    public final String[] readData$descriptors_jvm(@NotNull KotlinJvmBinaryClass kotlinClass2, @NotNull Set<? extends KotlinClassHeader.Kind> expectedKinds) {
        Object object;
        Intrinsics.checkParameterIsNotNull(kotlinClass2, "kotlinClass");
        Intrinsics.checkParameterIsNotNull(expectedKinds, "expectedKinds");
        KotlinClassHeader header2 = kotlinClass2.getClassHeader();
        String[] stringArray = header2.getData();
        if (stringArray == null) {
            stringArray = header2.getIncompatibleData();
        }
        if (stringArray != null) {
            String[] stringArray2;
            String[] it = stringArray2 = stringArray;
            object = expectedKinds.contains((Object)header2.getKind()) ? stringArray2 : null;
        } else {
            object = null;
        }
        return object;
    }

    static {
        Companion = new Companion(null);
        KOTLIN_CLASS = SetsKt.setOf(KotlinClassHeader.Kind.CLASS);
        KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf(new KotlinClassHeader.Kind[]{KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART});
        KOTLIN_1_1_EAP_METADATA_VERSION = new JvmMetadataVersion(1, 1, 2);
    }

    public static final class Companion {
        @NotNull
        public final Set<KotlinClassHeader.Kind> getKOTLIN_CLASS$descriptors_jvm() {
            return KOTLIN_CLASS;
        }

        private final Set<KotlinClassHeader.Kind> getKOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART() {
            return KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
        }

        private final JvmMetadataVersion getKOTLIN_1_1_EAP_METADATA_VERSION() {
            return KOTLIN_1_1_EAP_METADATA_VERSION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

