/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodSignatureMappingKt {
    @NotNull
    public static final String computeJvmDescriptor(@NotNull FunctionDescriptor $receiver, boolean withReturnType) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        if ($receiver instanceof ConstructorDescriptor) {
            string = "<init>";
        } else {
            String string2 = $receiver.getName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "name.asString()");
        }
        $receiver2.append(string);
        $receiver2.append("(");
        List<ValueParameterDescriptor> list2 = $receiver.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "valueParameters");
        Iterable $receiver$iv = list2;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it;
            ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
            MethodSignatureMappingKt.appendErasedType($receiver2, kotlinType);
        }
        $receiver2.append(")");
        if (withReturnType) {
            if (TypeSignatureMappingKt.hasVoidReturnType($receiver)) {
                $receiver2.append("V");
            } else {
                KotlinType kotlinType = $receiver.getReturnType();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "returnType!!");
                MethodSignatureMappingKt.appendErasedType($receiver2, kotlinType);
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl);
    }

    public static final boolean forceSingleValueParameterBoxing(@NotNull CallableDescriptor f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (!(f instanceof FunctionDescriptor)) {
            return false;
        }
        if (((FunctionDescriptor)f).getValueParameters().size() != 1 || SpecialBuiltinMembers.isFromJavaOrBuiltins((CallableMemberDescriptor)f) || Intrinsics.areEqual(((FunctionDescriptor)f).getName().asString(), "remove") ^ true) {
            return false;
        }
        FunctionDescriptor functionDescriptor = ((FunctionDescriptor)f).getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "f.original");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "f.original.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.single(list2);
        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "f.original.valueParameters.single()");
        KotlinType kotlinType = valueParameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "f.original.valueParameters.single().type");
        JvmType jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
        if (!(jvmType instanceof JvmType.Primitive)) {
            jvmType = null;
        }
        JvmType.Primitive primitive = (JvmType.Primitive)jvmType;
        if ((primitive != null ? primitive.getJvmPrimitiveType() : null) != JvmPrimitiveType.INT) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)f);
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor overridden = functionDescriptor2;
        FunctionDescriptor functionDescriptor3 = overridden.getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor3, "overridden.original");
        List<ValueParameterDescriptor> list3 = functionDescriptor3.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "overridden.original.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor2 = CollectionsKt.single(list3);
        Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor2, "overridden.original.valueParameters.single()");
        KotlinType kotlinType2 = valueParameterDescriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "overridden.original.valueParameters.single().type");
        JvmType overriddenParameterType = MethodSignatureMappingKt.mapToJvmType(kotlinType2);
        DeclarationDescriptor declarationDescriptor = overridden.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "overridden.containingDeclaration");
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor), KotlinBuiltIns.FQ_NAMES.mutableCollection.toUnsafe()) && overriddenParameterType instanceof JvmType.Object && Intrinsics.areEqual(((JvmType.Object)overriddenParameterType).getInternalName(), "java/lang/Object");
    }

    @Nullable
    public static final String computeJvmSignature(@NotNull CallableDescriptor $receiver) {
        SignatureBuildingComponents signatureBuildingComponents;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SignatureBuildingComponents $receiver2 = signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        if (DescriptorUtils.isLocal($receiver)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        Name name = classDescriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "classDescriptor.name");
        if (name.isSpecial()) {
            return null;
        }
        CallableDescriptor callableDescriptor = $receiver.getOriginal();
        if (!(callableDescriptor instanceof SimpleFunctionDescriptor)) {
            callableDescriptor = null;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)callableDescriptor;
        if (simpleFunctionDescriptor == null) {
            return null;
        }
        String string = MethodSignatureMappingKt.computeJvmDescriptor$default(simpleFunctionDescriptor, false, 1, null);
        Intrinsics.checkExpressionValueIsNotNull(string, "(original as? SimpleFunc\u2026l).computeJvmDescriptor()");
        return $receiver2.signature(classDescriptor2, string);
    }

    @NotNull
    public static final String getInternalName(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameSafe($receiver).toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fqNameSafe.toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId != null) {
            ClassId classId2;
            ClassId it = classId2 = classId;
            JvmClassName jvmClassName = JvmClassName.byClassId(it);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(it)");
            String string = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(it).internalName");
            return string;
        }
        return TypeSignatureMappingKt.computeInternalName$default($receiver, null, 2, null);
    }

    private static final void appendErasedType(@NotNull StringBuilder $receiver, KotlinType type2) {
        $receiver.append(MethodSignatureMappingKt.mapToJvmType(type2));
    }

    @NotNull
    public static final JvmType mapToJvmType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (JvmType)TypeSignatureMappingKt.mapType$default($receiver, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

