/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationWithTarget;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.Flags;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotationsWithPossibleTargets;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            SimpleType lowerBound = this.simpleType(proto, additionalAnnotations);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            SimpleType upperBound = this.simpleType(type2, additionalAnnotations);
            FlexibleTypeDeserializer flexibleTypeDeserializer = this.c.getComponents().getFlexibleTypeDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull(string, "id");
            return flexibleTypeDeserializer.create(proto, string, lowerBound, upperBound);
        }
        return this.simpleType(proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleType simpleType(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        SimpleType localClassifierType;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        SimpleType simpleType2 = proto.hasClassName() ? this.computeLocalClassifierReplacementType(proto.getClassName()) : (localClassifierType = proto.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(proto.getTypeAliasName()) : null);
        if (localClassifierType != null) {
            return localClassifierType;
        }
        TypeConstructor constructor = this.typeConstructor(proto);
        if (ErrorUtils.isError(constructor.getDeclarationDescriptor())) {
            SimpleType simpleType3 = ErrorUtils.createErrorTypeWithCustomConstructor(constructor.toString(), constructor);
            Intrinsics.checkExpressionValueIsNotNull(simpleType3, "ErrorUtils.createErrorTy\u2026.toString(), constructor)");
            return simpleType3;
        }
        DeserializedAnnotationsWithPossibleTargets annotations2 = new DeserializedAnnotationsWithPossibleTargets(this.c.getStorageManager(), (Function0<? extends List<AnnotationWithTarget>>)new Function0<List<? extends AnnotationWithTarget>>(this, proto, additionalAnnotations){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;
            final /* synthetic */ Annotations $additionalAnnotations;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AnnotationWithTarget> invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv = TypeDeserializer.access$getC$p(this.this$0).getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(this.$proto, TypeDeserializer.access$getC$p(this.this$0).getNameResolver());
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    AnnotationWithTarget annotationWithTarget = new AnnotationWithTarget((AnnotationDescriptor)it, null);
                    collection.add(annotationWithTarget);
                }
                return CollectionsKt.toList((Iterable)CollectionsKt.plus((Collection)((List)var3_3), (Iterable)this.$additionalAnnotations.getAllAnnotations()));
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type2;
                this.$additionalAnnotations = annotations2;
                super(0);
            }
        });
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> collectAllArguments$ = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                List<ProtoBuf.Type.Argument> list2 = $receiver.getArgumentList();
                Intrinsics.checkExpressionValueIsNotNull(list2, "argumentList");
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($receiver, TypeDeserializer.access$getC$p(this.this$0).getTypeTable());
                List<ProtoBuf.Type.Argument> list3 = type2 != null ? this.invoke(type2) : null;
                Collection collection = list2;
                List<ProtoBuf.Type.Argument> list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                List<ProtoBuf.Type.Argument> list5 = list4;
                return CollectionsKt.plus(collection, (Iterable)list5);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        };
        Iterable iterable = $receiver$iv = (Iterable)collectAllArguments$.invoke(proto);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void proto2;
            void index2;
            int n = index$iv$iv++;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            List<TypeParameterDescriptor> list2 = constructor.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "constructor.parameters");
            TypeProjection typeProjection = this.typeArgument(CollectionsKt.getOrNull(list2, (int)index2), (ProtoBuf.Type.Argument)proto2);
            collection.add(typeProjection);
        }
        List arguments2 = CollectionsKt.toList((List)destination$iv$iv);
        Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull(bl, "Flags.SUSPEND_TYPE.get(proto.flags)");
        SimpleType simpleType4 = bl != false ? this.createSuspendFunctionType(annotations2, constructor, arguments2, proto.getNullable()) : KotlinTypeFactory.simpleType(annotations2, constructor, arguments2, proto.getNullable());
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.c.getTypeTable());
        if (type2 == null) {
            return simpleType4;
        }
        ProtoBuf.Type abbreviatedTypeProto = type2;
        return SpecialTypesKt.withAbbreviation(simpleType4, this.simpleType(abbreviatedTypeProto, additionalAnnotations));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.simpleType(type2, annotations2);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        Object object;
        Function1<Integer, ClassDescriptor> notFoundClass$ = new Function1<Integer, ClassDescriptor>(this, proto){
            final /* synthetic */ TypeDeserializer this$0;
            final /* synthetic */ ProtoBuf.Type $proto;

            @NotNull
            public final ClassDescriptor invoke(int classIdIndex) {
                ClassId classId = TypeDeserializer.access$getC$p(this.this$0).getNameResolver().getClassId(classIdIndex);
                List<Integer> typeParametersCount2 = SequencesKt.toMutableList(SequencesKt.map(SequencesKt.generateSequence(this.$proto, (Function1)new Function1<ProtoBuf.Type, ProtoBuf.Type>(this){
                    final /* synthetic */ typeConstructor.1 this$0;

                    @Nullable
                    public final ProtoBuf.Type invoke(@NotNull ProtoBuf.Type it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return ProtoTypeTableUtilKt.outerType(it, TypeDeserializer.access$getC$p(this.this$0.this$0).getTypeTable());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), typeConstructor.typeParametersCount.2.INSTANCE));
                int classNestingLevel2 = SequencesKt.count(SequencesKt.generateSequence(classId, (Function1)typeConstructor.classNestingLevel.1.INSTANCE));
                while (typeParametersCount2.size() < classNestingLevel2) {
                    typeParametersCount2.add(0);
                }
                NotFoundClasses notFoundClasses = TypeDeserializer.access$getC$p(this.this$0).getComponents().getNotFoundClasses();
                ClassId classId2 = classId;
                Intrinsics.checkExpressionValueIsNotNull(classId2, "classId");
                return notFoundClasses.getClass(classId2, typeParametersCount2);
            }
            {
                this.this$0 = typeDeserializer;
                this.$proto = type2;
                super(1);
            }
        };
        if (proto.hasClassName()) {
            ClassDescriptor classDescriptor = this.classDescriptors.invoke(proto.getClassName());
            if (classDescriptor == null) {
                classDescriptor = notFoundClass$.invoke(proto.getClassName());
            }
            TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
            object = typeConstructor2;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "(classDescriptors(proto.\u2026assName)).typeConstructor");
        } else if (proto.hasTypeParameter()) {
            object = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (object == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorTypeConstructor("Unknown type parameter " + proto.getTypeParameter());
                object = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "ErrorUtils.createErrorTy\u2026 ${proto.typeParameter}\")");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v4;
            String name;
            DeclarationDescriptor container2;
            block13: {
                Iterable iterable;
                container2 = this.c.getContainingDeclaration();
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable2 = iterable = (Iterable)this.getOwnTypeParameters();
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v4 = t;
                    break block13;
                }
                v4 = null;
            }
            if ((object = (parameter = (TypeParameterDescriptor)v4)) == null || (object = object.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor4 = ErrorUtils.createErrorTypeConstructor("Deserialized type parameter " + name + " in " + container2);
                object = typeConstructor4;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "ErrorUtils.createErrorTy\u2026ter $name in $container\")");
            }
        } else if (proto.hasTypeAliasName()) {
            ClassifierDescriptor classifierDescriptor = this.typeAliasDescriptors.invoke(proto.getTypeAliasName());
            if (classifierDescriptor == null) {
                classifierDescriptor = notFoundClass$.invoke(proto.getTypeAliasName());
            }
            TypeConstructor typeConstructor5 = classifierDescriptor.getTypeConstructor();
            object = typeConstructor5;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor5, "(typeAliasDescriptors(pr\u2026iasName)).typeConstructor");
        } else {
            TypeConstructor typeConstructor6 = ErrorUtils.createErrorTypeConstructor("Unknown type");
            object = typeConstructor6;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor6, "ErrorUtils.createErrorTy\u2026nstructor(\"Unknown type\")");
        }
        return object;
    }

    private final SimpleType createSuspendFunctionType(Annotations annotations2, TypeConstructor functionTypeConstructor, List<? extends TypeProjection> arguments2, boolean nullable) {
        SimpleType result2;
        SimpleType simpleType2;
        SimpleType simpleType3;
        switch (functionTypeConstructor.getParameters().size() - arguments2.size()) {
            case 0: {
                SimpleType functionType;
                SimpleType simpleType4;
                SimpleType it = simpleType4 = (functionType = KotlinTypeFactory.simpleType(annotations2, functionTypeConstructor, arguments2, nullable));
                SimpleType simpleType5 = FunctionTypesKt.isFunctionType(it) ? simpleType4 : null;
                if (simpleType5 != null) {
                    simpleType4 = simpleType5;
                    KotlinType p1 = simpleType4;
                    simpleType3 = SuspendFunctionTypesKt.transformRuntimeFunctionTypeToSuspendFunction(p1);
                    break;
                }
                simpleType3 = null;
                break;
            }
            case 1: {
                int arity = arguments2.size() - 1;
                if (arity >= 0) {
                    ClassDescriptor classDescriptor = functionTypeConstructor.getBuiltIns().getSuspendFunction(arity);
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "functionTypeConstructor.\u2026getSuspendFunction(arity)");
                    TypeConstructor typeConstructor2 = classDescriptor.getTypeConstructor();
                    Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "functionTypeConstructor.\u2026on(arity).typeConstructor");
                    simpleType3 = KotlinTypeFactory.simpleType(annotations2, typeConstructor2, arguments2, nullable);
                    break;
                }
                simpleType3 = null;
                break;
            }
            default: {
                simpleType3 = null;
            }
        }
        if ((simpleType2 = (result2 = simpleType3)) == null) {
            SimpleType simpleType6 = ErrorUtils.createErrorTypeWithArguments("Bad suspend function in metadata with constructor: " + functionTypeConstructor, arguments2);
            simpleType2 = simpleType6;
            Intrinsics.checkExpressionValueIsNotNull(simpleType6, "ErrorUtils.createErrorTy\u2026eConstructor\", arguments)");
        }
        return simpleType2;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = object.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            object = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return object;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id;
        ClassId classId = id = this.c.getNameResolver().getClassId(fqNameIndex);
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        if (classId.isLocal()) {
            return this.c.getComponents().deserializeClass(id);
        }
        return FindClassInModuleKt.findClassAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final SimpleType computeLocalClassifierReplacementType(int className2) {
        ClassId classId = this.c.getNameResolver().getClassId(className2);
        Intrinsics.checkExpressionValueIsNotNull(classId, "c.nameResolver.getClassId(className)");
        if (classId.isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int fqNameIndex) {
        ClassId id;
        ClassId classId = id = this.c.getNameResolver().getClassId(fqNameIndex);
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        if (classId.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), id);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor parameter, ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            TypeProjection typeProjection;
            if (parameter == null) {
                SimpleType simpleType2 = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(simpleType2);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    /*
     * WARNING - void declaration
     */
    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent2, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Map map2;
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent2;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassifierDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassifierDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeTypeAliasDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        TypeDeserializer typeDeserializer = this;
        if (typeParameterProtos.isEmpty()) {
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            Map map3 = MapsKt.emptyMap();
            typeDeserializer = typeDeserializer2;
            map2 = map3;
        } else {
            LinkedHashMap result2 = new LinkedHashMap();
            boolean bl = false;
            for (ProtoBuf.TypeParameter proto : (Iterable)typeParameterProtos) {
                void index2;
                Map map4 = result2;
                Integer n = proto.getId();
                DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(this.c, proto, (int)index2);
                TypeDeserializer typeDeserializer3 = typeDeserializer;
                map4.put(n, deserializedTypeParameterDescriptor);
                TypeDeserializer typeDeserializer4 = typeDeserializer3;
                ++index2;
            }
            map2 = result2;
        }
        typeDeserializer.typeParameterDescriptors = map2;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @Nullable
    public static final /* synthetic */ ClassifierDescriptor access$computeTypeAliasDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeTypeAliasDescriptor(fqNameIndex);
    }
}

