/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection c, Transformer t) {
        HashMap buckets = new HashMap();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            Object key = t.transform(value);
            LinkedList bucket = (LinkedList)buckets.get(key);
            if (bucket == null) {
                bucket = new LinkedList();
                buckets.put(key, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static void reverse(Map source2, Map target) {
        Iterator it = source2.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            target.put(source2.get(key), key);
        }
    }

    public static Collection filter(Collection c, Predicate p2) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (p2.evaluate(it.next())) continue;
            it.remove();
        }
        return c;
    }

    public static List transform(Collection c, Transformer t) {
        ArrayList<Object> result2 = new ArrayList<Object>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            result2.add(t.transform(it.next()));
        }
        return result2;
    }

    public static Map getIndexMap(List list2) {
        HashMap indexes = new HashMap();
        int index2 = 0;
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            indexes.put(it.next(), new Integer(index2++));
        }
        return indexes;
    }
}

