/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.BaseStreamEx;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.IntStreamEx;
import one.util.streamex.LongStreamEx;
import one.util.streamex.OrderedCancellableSpliterator;
import one.util.streamex.StreamContext;
import one.util.streamex.StreamEx;
import one.util.streamex.StreamExInternals;
import one.util.streamex.UnorderedCancellableSpliterator;

public abstract class AbstractStreamEx<T, S extends AbstractStreamEx<T, S>>
extends BaseStreamEx<T, Stream<T>, Spliterator<T>, S>
implements Iterable<T>,
Stream<T> {
    AbstractStreamEx(Stream<? extends T> stream2, StreamContext context) {
        super(stream2, context);
    }

    AbstractStreamEx(Spliterator<? extends T> spliterator, StreamContext context) {
        super(spliterator, context);
    }

    @Override
    final Stream<T> createStream() {
        return StreamSupport.stream(this.spliterator, this.context.parallel);
    }

    <R, A> R rawCollect(Collector<? super T, A, R> collector2) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(collector2, ((Stream)this.stream())::collect);
        }
        return ((Stream)this.stream()).collect(collector2);
    }

    abstract S supply(Stream<T> var1);

    @Override
    public Iterator<T> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public S sequential() {
        return (S)((AbstractStreamEx)super.sequential());
    }

    @Override
    public S parallel() {
        return (S)((AbstractStreamEx)super.parallel());
    }

    @Override
    public S unordered() {
        return (S)((AbstractStreamEx)super.unordered());
    }

    @Override
    public S onClose(Runnable closeHandler) {
        return (S)((AbstractStreamEx)super.onClose(closeHandler));
    }

    public S filter(Predicate<? super T> predicate) {
        return this.supply(((Stream)this.stream()).filter(predicate));
    }

    @Override
    public <R> StreamEx<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return new StreamEx(((Stream)this.stream()).flatMap(mapper), this.context);
    }

    @Override
    public <R> StreamEx<R> map(Function<? super T, ? extends R> mapper) {
        return new StreamEx<R>(((Stream)this.stream()).map(mapper), this.context);
    }

    @Override
    public IntStreamEx mapToInt(ToIntFunction<? super T> mapper) {
        return new IntStreamEx(((Stream)this.stream()).mapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx mapToLong(ToLongFunction<? super T> mapper) {
        return new LongStreamEx(((Stream)this.stream()).mapToLong(mapper), this.context);
    }

    @Override
    public DoubleStreamEx mapToDouble(ToDoubleFunction<? super T> mapper) {
        return new DoubleStreamEx(((Stream)this.stream()).mapToDouble(mapper), this.context);
    }

    @Override
    public IntStreamEx flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return new IntStreamEx(((Stream)this.stream()).flatMapToInt(mapper), this.context);
    }

    @Override
    public LongStreamEx flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return new LongStreamEx(((Stream)this.stream()).flatMapToLong(mapper), this.context);
    }

    @Override
    public DoubleStreamEx flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return new DoubleStreamEx(((Stream)this.stream()).flatMapToDouble(mapper), this.context);
    }

    public S distinct() {
        return this.supply(((Stream)this.stream()).distinct());
    }

    public S sorted() {
        return this.supply(((Stream)this.stream()).sorted());
    }

    public S sorted(Comparator<? super T> comparator) {
        return this.supply(((Stream)this.stream()).sorted(comparator));
    }

    public S peek(Consumer<? super T> action2) {
        return this.supply(((Stream)this.stream()).peek(action2));
    }

    public S limit(long maxSize) {
        return this.supply(((Stream)this.stream()).limit(maxSize));
    }

    public S skip(long n) {
        return this.supply(((Stream)this.stream()).skip(n));
    }

    @Override
    public void forEach(Consumer<? super T> action2) {
        if (this.spliterator != null && !this.isParallel()) {
            this.spliterator().forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((Stream)this.stream()).forEach(action2);
                return null;
            });
        } else {
            ((Stream)this.stream()).forEach(action2);
        }
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action2) {
        if (this.spliterator != null && !this.isParallel()) {
            this.spliterator().forEachRemaining(action2);
        } else if (this.context.fjp != null) {
            this.context.terminate(() -> {
                ((Stream)this.stream()).forEachOrdered(action2);
                return null;
            });
        } else {
            ((Stream)this.stream()).forEachOrdered(action2);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        if (this.context.fjp != null) {
            return this.context.terminate(generator, ((Stream)this.stream())::toArray);
        }
        return ((Stream)this.stream()).toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        if (this.context.fjp != null) {
            return (T)this.context.terminate(() -> ((Stream)this.stream()).reduce(identity, accumulator));
        }
        return ((Stream)this.stream()).reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        if (this.context.fjp != null) {
            return this.context.terminate(accumulator, ((Stream)this.stream())::reduce);
        }
        return ((Stream)this.stream()).reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        if (this.context.fjp != null) {
            return (U)this.context.terminate(() -> ((Stream)this.stream()).reduce(identity, accumulator, combiner));
        }
        return ((Stream)this.stream()).reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        if (this.context.fjp != null) {
            return (R)this.context.terminate(() -> ((Stream)this.stream()).collect(supplier, accumulator, combiner));
        }
        return ((Stream)this.stream()).collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector2) {
        Predicate finished = StreamExInternals.finished(collector2);
        if (finished != null) {
            BiConsumer acc = collector2.accumulator();
            BinaryOperator<A> combiner = collector2.combiner();
            Spliterator spliterator = this.spliterator();
            if (!this.isParallel()) {
                Object a2 = collector2.supplier().get();
                if (!finished.test(a2)) {
                    try {
                        spliterator.forEachRemaining(e -> {
                            acc.accept(a2, (Object)e);
                            if (finished.test(a2)) {
                                throw new StreamExInternals.CancelException();
                            }
                        });
                    }
                    catch (StreamExInternals.CancelException cancelException) {
                        // empty catch block
                    }
                }
                return collector2.finisher().apply(a2);
            }
            StreamExInternals.CloneableSpliterator spltr = !spliterator.hasCharacteristics(16) || collector2.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? new UnorderedCancellableSpliterator<T, A>(spliterator, collector2.supplier(), acc, combiner, finished) : new OrderedCancellableSpliterator<T, A>(spliterator, collector2.supplier(), acc, combiner, finished);
            return collector2.finisher().apply(new StreamEx(StreamSupport.stream(spltr, true), this.context).findFirst().get());
        }
        return this.rawCollect(collector2);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.minBy(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.maxBy(comparator));
    }

    @Override
    public long count() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::count);
        }
        return ((Stream)this.stream()).count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((Stream)this.stream())::anyMatch);
        }
        return ((Stream)this.stream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        if (this.context.fjp != null) {
            return this.context.terminate(predicate, ((Stream)this.stream())::allMatch);
        }
        return ((Stream)this.stream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::findFirst);
        }
        return ((Stream)this.stream()).findFirst();
    }

    @Override
    public Optional<T> findAny() {
        if (this.context.fjp != null) {
            return this.context.terminate(((Stream)this.stream())::findAny);
        }
        return ((Stream)this.stream()).findAny();
    }

    @Override
    public List<T> toList() {
        return new ArrayList<Object>(new StreamExInternals.ArrayCollection(this.toArray(Object[]::new)));
    }
}

