/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.commonmark.CommonMarkMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMConstraints;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0014J$\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "markerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "getMarkerBlockProviders", "populateConstraintsTokens", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Factory", "intellij-markdown"})
public final class GFMMarkerProcessor
extends CommonMarkMarkerProcessor {
    private final List<MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    @Override
    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    @Override
    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        int offset2;
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        Intrinsics.checkParameterIsNotNull(constraints, "constraints");
        Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
        if (!(constraints instanceof GFMConstraints) || !((GFMConstraints)constraints).hasCheckbox()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        String line = pos.getCurrentLine();
        for (offset2 = pos.getOffsetInCurrentLine(); offset2 < line.length() && line.charAt(offset2) != '['; ++offset2) {
        }
        if (offset2 == line.length()) {
            super.populateConstraintsTokens(pos, constraints, productionHolder);
            return;
        }
        Character c = constraints.getLastType();
        IElementType type2 = Intrinsics.areEqual(c, Character.valueOf('>')) ? MarkdownTokenTypes.BLOCK_QUOTE : (Intrinsics.areEqual(c, Character.valueOf('.')) || Intrinsics.areEqual(c, Character.valueOf(')')) ? MarkdownTokenTypes.LIST_NUMBER : MarkdownTokenTypes.LIST_BULLET);
        int middleOffset = pos.getOffset() - pos.getOffsetInCurrentLine() + offset2;
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + constraints.getCharsEaten(pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node[]{new SequentialParser.Node(new IntRange(pos.getOffset(), middleOffset), type2), new SequentialParser.Node(new IntRange(middleOffset, endOffset), GFMTokenTypes.CHECK_BOX)}));
    }

    /*
     * WARNING - void declaration
     */
    public GFMMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
        Intrinsics.checkParameterIsNotNull(constraintsBase, "constraintsBase");
        super(productionHolder, constraintsBase);
        Iterable iterable = super.getMarkerBlockProviders();
        GFMMarkerProcessor gFMMarkerProcessor = this;
        void var4_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MarkerBlockProvider it = (MarkerBlockProvider)element$iv$iv;
            if (it instanceof AtxHeaderProvider) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        gFMMarkerProcessor.markerBlockProviders = CollectionsKt.plus((Collection)list2, (Iterable)CollectionsKt.listOf(new MarkerBlockProvider[]{new GitHubTableMarkerProvider(), new AtxHeaderProvider(false)}));
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "intellij-markdown"})
    public static final class Factory
    implements MarkerProcessorFactory {
        public static final Factory INSTANCE;

        @Override
        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkParameterIsNotNull(productionHolder, "productionHolder");
            return new GFMMarkerProcessor(productionHolder, GFMConstraints.Companion.getBASE());
        }

        private Factory() {
            INSTANCE = this;
        }

        static {
            new Factory();
        }
    }
}

