/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.DocumentationModule;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.DocumentationOptions;
import org.jetbrains.dokka.FileGeneratorKt;
import org.jetbrains.dokka.FileLocation;
import org.jetbrains.dokka.FormatService;
import org.jetbrains.dokka.FormatServiceKt;
import org.jetbrains.dokka.LocationKt;
import org.jetbrains.dokka.NodeLocationAwareGenerator;
import org.jetbrains.dokka.OutlineFormatService;
import org.jetbrains.dokka.PackageListService;
import org.jetbrains.dokka.PathKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010%\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u0016\u0010&\u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\b\u0010'\u001a\u00020!H\u0016J\u001a\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020$2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020$H\u0016J\u000e\u0010.\u001a\u00020-2\u0006\u0010)\u001a\u00020$R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0012@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0005\u001a\u0004\u0018\u00010\u0018@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lorg/jetbrains/dokka/FileGenerator;", "Lorg/jetbrains/dokka/NodeLocationAwareGenerator;", "root", "Ljava/io/File;", "(Ljava/io/File;)V", "<set-?>", "Lorg/jetbrains/dokka/FormatService;", "formatService", "getFormatService", "()Lorg/jetbrains/dokka/FormatService;", "setFormatService", "(Lorg/jetbrains/dokka/FormatService;)V", "Lorg/jetbrains/dokka/DocumentationOptions;", "options", "getOptions", "()Lorg/jetbrains/dokka/DocumentationOptions;", "setOptions", "(Lorg/jetbrains/dokka/DocumentationOptions;)V", "Lorg/jetbrains/dokka/OutlineFormatService;", "outlineService", "getOutlineService", "()Lorg/jetbrains/dokka/OutlineFormatService;", "setOutlineService", "(Lorg/jetbrains/dokka/OutlineFormatService;)V", "Lorg/jetbrains/dokka/PackageListService;", "packageListService", "getPackageListService", "()Lorg/jetbrains/dokka/PackageListService;", "setPackageListService", "(Lorg/jetbrains/dokka/PackageListService;)V", "getRoot", "()Ljava/io/File;", "buildOutlines", "", "nodes", "", "Lorg/jetbrains/dokka/DocumentationNode;", "buildPackageList", "buildPages", "buildSupportFiles", "fileForNode", "node", "extension", "", "location", "Lorg/jetbrains/dokka/FileLocation;", "locationWithoutExtension", "core"})
public final class FileGenerator
implements NodeLocationAwareGenerator {
    @Nullable
    private OutlineFormatService outlineService;
    @NotNull
    public FormatService formatService;
    @NotNull
    public DocumentationOptions options;
    @Nullable
    private PackageListService packageListService;
    @NotNull
    private final File root;

    @Nullable
    public final OutlineFormatService getOutlineService() {
        return this.outlineService;
    }

    @Inject(optional=true)
    public final void setOutlineService(@Nullable OutlineFormatService outlineFormatService) {
        this.outlineService = outlineFormatService;
    }

    @NotNull
    public final FormatService getFormatService() {
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        return formatService;
    }

    @Inject(optional=true)
    public final void setFormatService(@NotNull FormatService formatService) {
        Intrinsics.checkParameterIsNotNull(formatService, "<set-?>");
        this.formatService = formatService;
    }

    @NotNull
    public final DocumentationOptions getOptions() {
        DocumentationOptions documentationOptions = this.options;
        if (documentationOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException("options");
        }
        return documentationOptions;
    }

    @Inject(optional=true)
    public final void setOptions(@NotNull DocumentationOptions documentationOptions) {
        Intrinsics.checkParameterIsNotNull(documentationOptions, "<set-?>");
        this.options = documentationOptions;
    }

    @Nullable
    public final PackageListService getPackageListService() {
        return this.packageListService;
    }

    @Inject(optional=true)
    public final void setPackageListService(@Nullable PackageListService packageListService) {
        this.packageListService = packageListService;
    }

    @Override
    @NotNull
    public FileLocation location(@NotNull DocumentationNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        return new FileLocation(this.fileForNode(node, formatService.getLinkExtension()));
    }

    private final File fileForNode(DocumentationNode node, String extension) {
        return PathKt.appendExtension(new File(this.getRoot(), LocationKt.relativePathToNode(node)), extension);
    }

    static /* synthetic */ File fileForNode$default(FileGenerator fileGenerator, DocumentationNode documentationNode, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return fileGenerator.fileForNode(documentationNode, string);
    }

    @NotNull
    public final FileLocation locationWithoutExtension(@NotNull DocumentationNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        return new FileLocation(FileGenerator.fileForNode$default(this, node, null, 2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void buildPages(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Serializable key$iv$iv;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        Object $receiver$iv = nodes;
        Iterable<? extends DocumentationNode> iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            Map.Entry $receiver$iv$iv$iv;
            Object value$iv$iv$iv;
            DocumentationNode it = (DocumentationNode)element$iv$iv;
            boolean bl2 = false;
            FormatService formatService = this.formatService;
            if (formatService == null) {
                Intrinsics.throwUninitializedPropertyAccessException("formatService");
            }
            if ((value$iv$iv$iv = ($receiver$iv$iv$iv = destination$iv$iv).get(key$iv$iv = this.fileForNode(it, formatService.getExtension()))) == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put((File)key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        for (Map.Entry entry : $receiver$iv.entrySet()) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Object object;
            destination$iv$iv = entry;
            File file2 = (File)destination$iv$iv.getKey();
            destination$iv$iv = entry;
            List items = (List)destination$iv$iv.getValue();
            File file3 = file2.getParentFile();
            if (file3 != null) {
                FileGeneratorKt.access$mkdirsOrFail(file3);
            }
            try {
                destination$iv$iv = new FileOutputStream(file2);
                object = null;
                try {
                    Object it = (FileOutputStream)destination$iv$iv;
                    boolean bl = false;
                    Closeable bl2 = new OutputStreamWriter((OutputStream)it, Charsets.UTF_8);
                    key$iv$iv = null;
                    try {
                        Object it2 = (OutputStreamWriter)bl2;
                        boolean bl3 = false;
                        FormatService formatService = this.formatService;
                        if (formatService == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("formatService");
                        }
                        ((Writer)it2).write(FormatServiceKt.format(formatService, this.location((DocumentationNode)CollectionsKt.first(items)), items));
                        it2 = Unit.INSTANCE;
                    }
                    catch (Throwable it2) {
                        key$iv$iv = it2;
                        throw it2;
                    }
                    finally {
                        CloseableKt.closeFinally(bl2, (Throwable)key$iv$iv);
                    }
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    object = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)destination$iv$iv, (Throwable)object);
                }
            }
            catch (Throwable e) {
                System.out.println(e);
            }
            Iterable e = items;
            FileGenerator fileGenerator = this;
            object = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                DocumentationNode it = (DocumentationNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getMembers();
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            fileGenerator.buildPages(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void buildOutlines(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Object it;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        OutlineFormatService outlineFormatService = this.outlineService;
        if (outlineFormatService == null) {
            return;
        }
        OutlineFormatService outlineService = outlineFormatService;
        Object $receiver$iv = nodes;
        Iterable<? extends DocumentationNode> iterable = $receiver$iv;
        Map.Entry destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            it = (DocumentationNode)element$iv$iv;
            boolean bl = false;
            Map.Entry $receiver$iv$iv$iv = destination$iv$iv;
            FileLocation key$iv$iv = this.locationWithoutExtension((DocumentationNode)it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        Iterator iterator2 = $receiver$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            destination$iv$iv = entry = iterator2.next();
            FileLocation location2 = (FileLocation)destination$iv$iv.getKey();
            destination$iv$iv = entry;
            List items = (List)destination$iv$iv.getValue();
            File file2 = outlineService.getOutlineFileName(location2);
            File file3 = file2.getParentFile();
            if (file3 != null) {
                FileGeneratorKt.access$mkdirsOrFail(file3);
            }
            Closeable closeable = new FileOutputStream(file2);
            Throwable throwable = null;
            try {
                it = (FileOutputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new OutputStreamWriter((OutputStream)it, Charsets.UTF_8);
                Throwable throwable2 = null;
                try {
                    OutputStreamWriter it2 = (OutputStreamWriter)closeable2;
                    boolean bl2 = false;
                    it2.write(outlineService.formatOutline(location2, items));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    @Override
    public void buildSupportFiles() {
        FormatService formatService = this.formatService;
        if (formatService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("formatService");
        }
        formatService.enumerateSupportFiles((Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(this){
            final /* synthetic */ FileGenerator this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String resource, @NotNull String targetPath) {
                Intrinsics.checkParameterIsNotNull(resource, "resource");
                Intrinsics.checkParameterIsNotNull(targetPath, "targetPath");
                Closeable closeable = new FileOutputStream(new File(this.this$0.getRoot(), LocationKt.relativePathToNode(CollectionsKt.listOf(targetPath), false)));
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = this.this$0.getClass().getResourceAsStream(resource);
                    Intrinsics.checkExpressionValueIsNotNull(inputStream, "javaClass.getResourceAsStream(resource)");
                    long l = ByteStreamsKt.copyTo$default(inputStream, it, 0, 2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            {
                this.this$0 = fileGenerator;
                super(2);
            }
        });
    }

    @Override
    public void buildPackageList(@NotNull Iterable<? extends DocumentationNode> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        if (this.packageListService == null) {
            return;
        }
        for (DocumentationNode documentationNode : nodes) {
            File moduleRoot = this.location(documentationNode).getFile().getParentFile();
            File packageListFile = new File(moduleRoot, "package-list");
            StringBuilder stringBuilder = new StringBuilder().append("$dokka.format:");
            DocumentationOptions documentationOptions = this.options;
            if (documentationOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException("options");
            }
            StringBuilder stringBuilder2 = stringBuilder.append(documentationOptions.getOutputFormat()).append('\n');
            PackageListService packageListService = this.packageListService;
            if (packageListService == null) {
                Intrinsics.throwNpe();
            }
            DocumentationNode documentationNode2 = documentationNode;
            if (documentationNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.dokka.DocumentationModule");
            }
            FilesKt.writeText$default(packageListFile, stringBuilder2.append(packageListService.formatPackageList((DocumentationModule)documentationNode2)).toString(), null, 2, null);
        }
    }

    @Override
    @NotNull
    public File getRoot() {
        return this.root;
    }

    @Inject
    public FileGenerator(@Named(value="outputDir") @NotNull File root2) {
        Intrinsics.checkParameterIsNotNull(root2, "root");
        this.root = root2;
    }
}

