/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.Location;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u001a\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/dokka/FileLocation;", "Lorg/jetbrains/dokka/Location;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "path", "", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "relativePathTo", "anchor", "toString", "core"})
public final class FileLocation
implements Location {
    @NotNull
    private final File file;

    @Override
    @NotNull
    public String getPath() {
        String string = this.file.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.path");
        return string;
    }

    @Override
    @NotNull
    public String relativePathTo(@NotNull Location other, @Nullable String anchor2) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (!(other instanceof FileLocation)) {
            throw (Throwable)new IllegalArgumentException(other + " is not a FileLocation");
        }
        String string = this.file.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.path");
        String string2 = StringsKt.substringBeforeLast$default(string, ".", null, 2, null);
        String string3 = ((FileLocation)other).file.getPath();
        Intrinsics.checkExpressionValueIsNotNull(string3, "other.file.path");
        if (Intrinsics.areEqual(string2, StringsKt.substringBeforeLast$default(string3, ".", null, 2, null)) && anchor2 == null) {
            return "./" + this.file.getName();
        }
        File file2 = this.file.getParentFile();
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        File ownerFolder = file2;
        String relativePath = StringsKt.replace$default(((Object)ownerFolder.toPath().relativize(((FileLocation)other).file.toPath())).toString(), File.separatorChar, '/', false, 4, null);
        return anchor2 == null ? relativePath : relativePath + "#" + anchor2;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public FileLocation(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.file = file2;
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    @NotNull
    public final FileLocation copy(@NotNull File file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        return new FileLocation(file2);
    }

    @NotNull
    public static /* synthetic */ FileLocation copy$default(FileLocation fileLocation, File file2, int n, Object object) {
        if ((n & 1) != 0) {
            file2 = fileLocation.file;
        }
        return fileLocation.copy(file2);
    }

    @NotNull
    public String toString() {
        return "FileLocation(file=" + this.file + ")";
    }

    public int hashCode() {
        File file2 = this.file;
        return file2 != null ? ((Object)file2).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FileLocation)) break block3;
                FileLocation fileLocation = (FileLocation)object;
                if (!Intrinsics.areEqual(this.file, fileLocation.file)) break block3;
            }
            return true;
        }
        return false;
    }
}

