/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.Content;
import org.jetbrains.dokka.DocumentationNode;
import org.jetbrains.dokka.DocumentationNodeKt;
import org.jetbrains.dokka.DokkaConfiguration;
import org.jetbrains.dokka.NodeKind;
import org.jetbrains.dokka.RefKind;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0011\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u0004\u00a2\u0006\u0002\u0010\n\u001a\u0011\u0010\u000b\u001a\u0004\u0018\u00010\t*\u00020\u0004\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"appendSourceLink", "", "Lorg/jetbrains/dokka/DocumentationNode;", "psi", "Lcom/intellij/psi/PsiElement;", "sourceLinks", "", "Lorg/jetbrains/dokka/DokkaConfiguration$SourceLinkDefinition;", "columnNumber", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "lineNumber", "sourcePosition", "", "core"})
public final class SourceLinksKt {
    public static final void appendSourceLink(@NotNull DocumentationNode $receiver, @Nullable PsiElement psi, @NotNull List<? extends DokkaConfiguration.SourceLinkDefinition> sourceLinks) {
        Object v2;
        PsiElement target;
        Object path2;
        block7: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(sourceLinks, "sourceLinks");
            Object object = psi;
            if (object == null || (object = object.getContainingFile()) == null || (object = object.getVirtualFile()) == null || (object = ((VirtualFile)object).getPath()) == null) {
                return;
            }
            path2 = object;
            target = psi instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)psi).getNameIdentifier() : psi;
            String absPath = new File((String)path2).getAbsolutePath();
            Iterable $receiver$iv = sourceLinks;
            for (Object element$iv : $receiver$iv) {
                DokkaConfiguration.SourceLinkDefinition it = (DokkaConfiguration.SourceLinkDefinition)element$iv;
                boolean bl = false;
                String string = absPath;
                Intrinsics.checkExpressionValueIsNotNull(string, "absPath");
                if (!StringsKt.startsWith$default(string, it.getPath(), false, 2, null)) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        DokkaConfiguration.SourceLinkDefinition linkDef = v2;
        if (linkDef != null) {
            StringBuilder stringBuilder = new StringBuilder().append(linkDef.getUrl());
            Object object = path2;
            Intrinsics.checkExpressionValueIsNotNull(object, "path");
            Object object2 = object;
            int n = linkDef.getPath().length();
            StringBuilder stringBuilder2 = stringBuilder;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull(string, "(this as java.lang.String).substring(startIndex)");
            String string2 = string;
            String url = stringBuilder2.append(string2).toString();
            if (linkDef.getLineSuffix() != null) {
                Integer line;
                PsiElement psiElement = target;
                Integer n2 = line = psiElement != null ? SourceLinksKt.lineNumber(psiElement) : null;
                if (line != null) {
                    url = url + linkDef.getLineSuffix() + String.valueOf(line);
                }
            }
            DocumentationNodeKt.append($receiver, new DocumentationNode(url, Content.Companion.getEmpty(), NodeKind.SourceUrl), RefKind.Detail);
        }
        if (target != null) {
            DocumentationNodeKt.append($receiver, new DocumentationNode(SourceLinksKt.sourcePosition(target), Content.Companion.getEmpty(), NodeKind.SourcePosition), RefKind.Detail);
        }
    }

    private static final String sourcePosition(@NotNull PsiElement $receiver) {
        String string;
        PsiFile psiFile = $receiver.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull(psiFile, "containingFile");
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "containingFile.virtualFile");
        String path2 = virtualFile2.getPath();
        Integer lineNumber = SourceLinksKt.lineNumber($receiver);
        Integer columnNumber = SourceLinksKt.columnNumber($receiver);
        if (lineNumber == null) {
            String string2 = path2;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "path");
        } else {
            string = columnNumber == null ? path2 + ':' + lineNumber : path2 + ':' + lineNumber + ':' + columnNumber;
        }
        return string;
    }

    @Nullable
    public static final Integer lineNumber(@NotNull PsiElement $receiver) {
        Integer n;
        Document doc;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Document document = doc = PsiDocumentManager.getInstance($receiver.getProject()).getDocument($receiver.getContainingFile());
        if (document != null) {
            TextRange textRange = $receiver.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull(textRange, "textRange");
            n = document.getLineNumber(textRange.getStartOffset()) + 1;
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final Integer columnNumber(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Document document = PsiDocumentManager.getInstance($receiver.getProject()).getDocument($receiver.getContainingFile());
        if (document == null) {
            return null;
        }
        Document doc = document;
        TextRange textRange = $receiver.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull(textRange, "textRange");
        int lineNumber = doc.getLineNumber(textRange.getStartOffset());
        return PsiUtilsKt.getStartOffset($receiver) - doc.getLineStartOffset(lineNumber);
    }
}

