/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import gnu.trove.THashSet;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public class FieldNotUsedInToStringInspection
extends AbstractToStringInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        if ("Field not used in 'toString()' method" == null) {
            FieldNotUsedInToStringInspection.$$$reportNull$$$0(0);
        }
        return "Field not used in 'toString()' method";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("FieldNotUsedInToString" == null) {
            FieldNotUsedInToStringInspection.$$$reportNull$$$0(1);
        }
        return "FieldNotUsedInToString";
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldNotUsedInToStringInspection.$$$reportNull$$$0(2);
        }
        FieldNotUsedInToStringVisitor fieldNotUsedInToStringVisitor = new FieldNotUsedInToStringVisitor(holder);
        if (fieldNotUsedInToStringVisitor == null) {
            FieldNotUsedInToStringInspection.$$$reportNull$$$0(3);
        }
        return fieldNotUsedInToStringVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/inspection/FieldNotUsedInToStringInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/inspection/FieldNotUsedInToStringInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FieldUsedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final THashSet<PsiField> myUnusedFields = new THashSet();
        private final THashSet<PsiMethod> myUnusedMethods = new THashSet();

        FieldUsedVisitor(PsiField[] fields2, PsiMethod[] methods2) {
            Collections.addAll(this.myUnusedFields, fields2);
            Collections.addAll(this.myUnusedMethods, methods2);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.myUnusedFields.isEmpty() && this.myUnusedMethods.isEmpty()) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                this.myUnusedFields.remove(field);
            } else if (target instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)target;
                if (FieldUsedVisitor.usesReflection(method)) {
                    this.myUnusedFields.clear();
                    this.myUnusedMethods.clear();
                } else {
                    this.myUnusedMethods.remove(method);
                    PsiField field = PropertyUtilBase.findPropertyFieldByMember(method);
                    this.myUnusedFields.remove(field);
                }
            }
        }

        private static boolean usesReflection(PsiMethod method) {
            String name = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName2 = containingClass.getQualifiedName();
            if ("getDeclaredFields".equals(name)) {
                return "java.lang.Class".equals(qualifiedName2);
            }
            if ("toString".equals(name)) {
                return "org.apache.commons.lang.builder.ReflectionToStringBuilder".equals(qualifiedName2) || "java.util.Objects".equals(qualifiedName2);
            }
            return false;
        }

        THashSet<PsiField> getUnusedFields() {
            return this.myUnusedFields;
        }

        THashSet<PsiMethod> getUnusedMethods() {
            return this.myUnusedMethods;
        }
    }

    private static class FieldNotUsedInToStringVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        private FieldNotUsedInToStringVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            String methodName = method.getName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiType returnType = method.getReturnType();
            PsiClassType javaLangString = PsiType.getJavaLangString(method.getManager(), method.getResolveScope());
            if (!javaLangString.equals(returnType)) {
                return;
            }
            PsiClass aClass2 = method.getContainingClass();
            if (aClass2 == null) {
                return;
            }
            PsiField[] fields2 = GenerateToStringUtils.filterAvailableFields(aClass2, GenerateToStringContext.getConfig().getFilterPattern());
            PsiMethod[] methods2 = GenerateToStringContext.getConfig().isEnableMethods() ? GenerateToStringUtils.filterAvailableMethods(aClass2, GenerateToStringContext.getConfig().getFilterPattern()) : PsiMethod.EMPTY_ARRAY;
            FieldUsedVisitor visitor2 = new FieldUsedVisitor(fields2, methods2);
            method.accept(visitor2);
            for (PsiField field : visitor2.getUnusedFields()) {
                String fieldName = field.getName();
                this.myHolder.registerProblem((PsiElement)field.getNameIdentifier(), "Field '" + fieldName + "' is not used in 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(this.myHolder));
            }
            for (PsiMethod unusedMethod : visitor2.getUnusedMethods()) {
                PsiIdentifier identifier = unusedMethod.getNameIdentifier();
                PsiElement target = identifier == null ? unusedMethod : identifier;
                this.myHolder.registerProblem(target, "Method '" + unusedMethod.getName() + "' is not used in 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(this.myHolder));
            }
        }
    }
}

