/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.annotation.AnnotatedWithFakeAnnotations;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PropertyCodegen {
    private final GenerationState state;
    private final ClassBuilder v;
    private final FunctionCodegen functionCodegen;
    private final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    private final FieldOwnerContext context;
    private final MemberCodegen<?> memberCodegen;
    private final OwnerKind kind;

    public PropertyCodegen(@NotNull FieldOwnerContext context, @NotNull ClassBuilder v, @NotNull FunctionCodegen functionCodegen2, @NotNull MemberCodegen<?> memberCodegen) {
        this.state = functionCodegen2.state;
        this.v = v;
        this.functionCodegen = functionCodegen2;
        this.typeMapper = this.state.getTypeMapper();
        this.bindingContext = this.state.getBindingContext();
        this.context = context;
        this.memberCodegen = memberCodegen;
        this.kind = context.getContextKind();
    }

    public void gen(@NotNull KtProperty property) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property);
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Property " + property.getName() + " should have a property descriptor: " + variableDescriptor, property);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.gen(property, propertyDescriptor, property.getGetter(), property.getSetter());
    }

    public void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, entry);
        if (!(variableDescriptor instanceof PropertyDescriptor)) {
            throw ExceptionLogger.logDescriptorNotFound("Destructuring declaration entry" + entry.getName() + " should have a property descriptor: " + variableDescriptor, entry);
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variableDescriptor;
        this.genDestructuringDeclaration(entry, propertyDescriptor);
    }

    public void generateInPackageFacade(@NotNull DeserializedPropertyDescriptor deserializedProperty) {
        assert (this.context instanceof MultifileClassFacadeContext) : "should be called only for generating facade: " + this.context;
        this.gen(null, deserializedProperty, null, null);
    }

    private void gen(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2, @Nullable KtPropertyAccessor setter2) {
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS || this.kind == OwnerKind.ERASED_INLINE_CLASS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        this.genBackingFieldAndAnnotations(declaration, descriptor2, false);
        if (this.isAccessorNeeded(declaration, descriptor2, getter2)) {
            this.generateGetter(declaration, descriptor2, getter2);
        }
        if (this.isAccessorNeeded(declaration, descriptor2, setter2)) {
            this.generateSetter(declaration, descriptor2, setter2);
        }
    }

    private void genDestructuringDeclaration(@NotNull KtDestructuringDeclarationEntry entry, @NotNull PropertyDescriptor descriptor2) {
        assert (this.kind == OwnerKind.PACKAGE || this.kind == OwnerKind.IMPLEMENTATION || this.kind == OwnerKind.DEFAULT_IMPLS) : "Generating property with a wrong kind (" + (Object)((Object)this.kind) + "): " + descriptor2;
        if (UnderscoreUtilKt.isSingleUnderscore(entry)) {
            return;
        }
        this.genBackingFieldAndAnnotations(entry, descriptor2, false);
        this.generateGetter(entry, descriptor2, null);
        this.generateSetter(entry, descriptor2, null);
    }

    private void genBackingFieldAndAnnotations(@Nullable KtNamedDeclaration declaration, @NotNull PropertyDescriptor descriptor2, boolean isParameter) {
        boolean isBackingFieldOwner;
        boolean hasBackingField = JvmCodegenUtil.hasBackingField(descriptor2, this.kind, this.bindingContext);
        boolean hasDelegate = declaration instanceof KtProperty && ((KtProperty)declaration).hasDelegate();
        AnnotationSplitter annotationSplitter = AnnotationSplitter.create(LockBasedStorageManager.NO_LOCKS, descriptor2.getAnnotations(), AnnotationSplitter.getTargetSet(isParameter, descriptor2.isVar(), hasBackingField, hasDelegate));
        Annotations propertyAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY);
        boolean bl = descriptor2.isConst() && !Visibilities.isPrivate(descriptor2.getVisibility()) ? !(this.context instanceof MultifileClassPartContext) : (isBackingFieldOwner = CodegenContextUtil.isImplClassOwner(this.context));
        if (isBackingFieldOwner) {
            Annotations fieldAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.FIELD);
            Annotations delegateAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD);
            assert (declaration != null) : "Declaration is null: " + descriptor2 + " (context=" + this.context + ")";
            this.generateBackingField(declaration, descriptor2, fieldAnnotations, delegateAnnotations);
            this.generateSyntheticMethodIfNeeded(descriptor2, propertyAnnotations);
        }
        if (!propertyAnnotations.getAllAnnotations().isEmpty() && this.kind != OwnerKind.DEFAULT_IMPLS && CodegenContextUtil.isImplClassOwner(this.context)) {
            this.v.getSerializationBindings().put(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2, this.getSyntheticMethodSignature(descriptor2));
        }
    }

    private boolean isAccessorNeeded(@Nullable KtProperty declaration, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor accessor) {
        boolean isDefaultAccessor;
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        boolean bl = isDefaultAccessor = accessor == null || !accessor.hasBody();
        if (this.kind == OwnerKind.DEFAULT_IMPLS && isDefaultAccessor) {
            return false;
        }
        if (declaration == null) {
            return true;
        }
        if (declaration.hasDelegate() || declaration.getReceiverTypeReference() != null) {
            return true;
        }
        if (DescriptorUtils.isCompanionObject(descriptor2.getContainingDeclaration())) {
            return true;
        }
        if (PropertyCodegen.isNonConstTopLevelPropertyInMultifileClass(declaration, descriptor2)) {
            return true;
        }
        if (Visibilities.isPrivate(descriptor2.getVisibility())) {
            return !isDefaultAccessor;
        }
        return true;
    }

    private static boolean isNonConstTopLevelPropertyInMultifileClass(@NotNull KtProperty declaration, @NotNull PropertyDescriptor descriptor2) {
        return !descriptor2.isConst() && descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration);
    }

    private static boolean areAccessorsNeededForPrimaryConstructorProperty(@NotNull PropertyDescriptor descriptor2, @NotNull OwnerKind kind) {
        if (AnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
            return false;
        }
        if (kind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        return !Visibilities.isPrivate(descriptor2.getVisibility());
    }

    public void generatePrimaryConstructorProperty(@NotNull KtParameter p2, @NotNull PropertyDescriptor descriptor2) {
        this.genBackingFieldAndAnnotations(p2, descriptor2, true);
        if (PropertyCodegen.areAccessorsNeededForPrimaryConstructorProperty(descriptor2, this.context.getContextKind())) {
            this.generateGetter(p2, descriptor2, null);
            this.generateSetter(p2, descriptor2, null);
        }
    }

    public void generateConstructorPropertyAsMethodForAnnotationClass(@NotNull KtParameter parameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        JvmMethodGenericSignature signature2 = this.typeMapper.mapAnnotationParameterSignature(descriptor2);
        String name = parameter.getName();
        if (name == null) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(parameter, descriptor2), 1025, name, signature2.getAsmMethod().getDescriptor(), signature2.getGenericsSignature(), null);
        KtExpression defaultValue = this.loadAnnotationArgumentDefaultValue(parameter, descriptor2, expectedAnnotationConstructor);
        if (defaultValue != null) {
            ConstantValue<?> constant = ExpressionCodegen.getCompileTimeConstant(defaultValue, this.bindingContext, true, this.state.getShouldInlineConstVals());
            assert (!this.state.getClassBuilderMode().generateBodies || constant != null) : "Default value for annotation parameter should be compile time value: " + defaultValue.getText();
            if (constant != null) {
                AnnotationCodegen annotationCodegen = AnnotationCodegen.forAnnotationDefaultValue(mv, this.memberCodegen, this.typeMapper);
                annotationCodegen.generateAnnotationDefaultValue(constant, descriptor2.getType());
            }
        }
        mv.visitEnd();
    }

    private KtExpression loadAnnotationArgumentDefaultValue(@NotNull KtParameter ktParameter, @NotNull PropertyDescriptor descriptor2, @Nullable FunctionDescriptor expectedAnnotationConstructor) {
        KtExpression value = ktParameter.getDefaultValue();
        if (value != null) {
            return value;
        }
        if (expectedAnnotationConstructor != null) {
            ValueParameterDescriptor expectedParameter = CollectionsKt.single(expectedAnnotationConstructor.getValueParameters(), parameter -> parameter.getName().equals(descriptor2.getName()));
            PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(expectedParameter);
            if (!(element instanceof KtParameter)) {
                this.state.getDiagnostics().report(Errors.EXPECTED_FUNCTION_SOURCE_WITH_DEFAULT_ARGUMENTS_NOT_FOUND.on(ktParameter));
                return null;
            }
            return ((KtParameter)element).getDefaultValue();
        }
        return null;
    }

    private boolean generateBackingField(@NotNull KtNamedDeclaration p2, @NotNull PropertyDescriptor descriptor2, @NotNull Annotations backingFieldAnnotations, @NotNull Annotations delegateAnnotations) {
        if (JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) || this.kind == OwnerKind.DEFAULT_IMPLS) {
            return false;
        }
        if (this.kind == OwnerKind.ERASED_INLINE_CLASS) {
            return false;
        }
        if (p2 instanceof KtProperty && ((KtProperty)p2).hasDelegate()) {
            this.generatePropertyDelegateAccess((KtProperty)p2, descriptor2, delegateAnnotations);
        } else if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2))) {
            this.generateBackingFieldAccess(p2, descriptor2, backingFieldAnnotations);
        } else {
            return false;
        }
        return true;
    }

    private void generateSyntheticMethodIfNeeded(@NotNull PropertyDescriptor descriptor2, @NotNull Annotations annotations2) {
        if (annotations2.getAllAnnotations().isEmpty()) {
            return;
        }
        Object contextDescriptor = this.context.getContextDescriptor();
        if (!DescriptorUtils.isInterface(contextDescriptor) || FunctionCodegen.processInterface(contextDescriptor, this.kind, this.state) || this.kind == OwnerKind.DEFAULT_IMPLS && this.state.getGenerateDefaultImplsForJvm8()) {
            this.memberCodegen.generateSyntheticAnnotationsMethod(descriptor2, this.getSyntheticMethodSignature(descriptor2), annotations2, AnnotationUseSiteTarget.PROPERTY);
        }
    }

    @NotNull
    private Method getSyntheticMethodSignature(@NotNull PropertyDescriptor descriptor2) {
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedProperty(descriptor2.getName());
        String desc = receiver == null ? "()V" : "(" + this.typeMapper.mapType(receiver.getType()) + ")V";
        return new Method(name, desc);
    }

    private void generateBackingField(KtNamedDeclaration element, PropertyDescriptor propertyDescriptor, boolean isDelegate, KotlinType kotlinType, Object defaultValue, Annotations annotations2) {
        int modifiers2 = AsmUtil.getDeprecatedAccessFlag(propertyDescriptor);
        for (AnnotationCodegen.JvmFlagAnnotation flagAnnotation : AnnotationCodegen.FIELD_FLAGS) {
            if (!flagAnnotation.hasAnnotation(propertyDescriptor.getOriginal())) continue;
            modifiers2 |= flagAnnotation.getJvmFlag();
        }
        if (this.kind == OwnerKind.PACKAGE) {
            modifiers2 |= 8;
        }
        if (!(propertyDescriptor.isLateInit() || propertyDescriptor.isVar() && !isDelegate)) {
            modifiers2 |= 0x10;
        }
        if (org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt.hasJvmSyntheticAnnotation(propertyDescriptor)) {
            modifiers2 |= 0x1000;
        }
        Type type2 = this.typeMapper.mapType(kotlinType);
        ClassBuilder builder = this.v;
        FieldOwnerContext backingFieldContext = this.context;
        if (AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor)) {
            modifiers2 |= 8;
            if (JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor)) {
                ImplementationBodyCodegen codegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
                builder = codegen.v;
                backingFieldContext = codegen.context;
            }
        }
        modifiers2 |= AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegate);
        if (AsmUtil.isPropertyWithBackingFieldCopyInOuterClass(propertyDescriptor)) {
            ImplementationBodyCodegen parentBodyCodegen = (ImplementationBodyCodegen)this.memberCodegen.getParentCodegen();
            parentBodyCodegen.addCompanionObjectPropertyToCopy(propertyDescriptor, defaultValue);
        }
        String name = backingFieldContext.getFieldName(propertyDescriptor, isDelegate);
        this.v.getSerializationBindings().put(JvmSerializationBindings.FIELD_FOR_PROPERTY, propertyDescriptor, Pair.create(type2, name));
        FieldVisitor fv = builder.newField(JvmDeclarationOriginKt.OtherOrigin(element, propertyDescriptor), modifiers2, name, type2.getDescriptor(), isDelegate ? null : this.typeMapper.mapFieldSignature(kotlinType, propertyDescriptor), defaultValue);
        AnnotatedWithFakeAnnotations fieldAnnotated = new AnnotatedWithFakeAnnotations(propertyDescriptor, annotations2);
        AnnotationCodegen.forField(fv, this.memberCodegen, this.typeMapper).genAnnotations(fieldAnnotated, type2, isDelegate ? AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD : AnnotationUseSiteTarget.FIELD);
    }

    private void generatePropertyDelegateAccess(@NotNull KtProperty p2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        KotlinType delegateType = this.getDelegateTypeForProperty(p2, propertyDescriptor);
        this.generateBackingField(p2, propertyDescriptor, true, delegateType, null, annotations2);
    }

    @NotNull
    private KotlinType getDelegateTypeForProperty(@NotNull KtProperty p2, @NotNull PropertyDescriptor propertyDescriptor) {
        KotlinType delegateType = null;
        ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor);
        KtExpression delegateExpression = p2.getDelegateExpression();
        if (provideDelegateResolvedCall != null) {
            delegateType = provideDelegateResolvedCall.getResultingDescriptor().getReturnType();
        } else if (delegateExpression != null) {
            delegateType = this.bindingContext.getType(delegateExpression);
        }
        if (delegateType == null) {
            delegateType = ErrorUtils.createErrorType("Delegate type");
        }
        return delegateType;
    }

    private void generateBackingFieldAccess(@NotNull KtNamedDeclaration p2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Annotations annotations2) {
        ConstantValue<?> initializer2;
        Object value = null;
        if (this.shouldWriteFieldInitializer(propertyDescriptor) && (initializer2 = propertyDescriptor.getCompileTimeInitializer()) != null) {
            value = initializer2.getValue();
        }
        this.generateBackingField(p2, propertyDescriptor, false, propertyDescriptor.getType(), value, annotations2);
    }

    private boolean shouldWriteFieldInitializer(@NotNull PropertyDescriptor descriptor2) {
        if (!descriptor2.isVar()) {
            Type type2 = this.typeMapper.mapType(descriptor2);
            return AsmUtil.isPrimitive(type2) || "java.lang.String".equals(type2.getClassName());
        }
        return false;
    }

    private void generateGetter(@Nullable KtNamedDeclaration p2, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor getter2) {
        this.generateAccessor(p2, getter2, descriptor2.getGetter() != null ? descriptor2.getGetter() : DescriptorFactory.createDefaultGetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateSetter(@Nullable KtNamedDeclaration p2, @NotNull PropertyDescriptor descriptor2, @Nullable KtPropertyAccessor setter2) {
        if (!descriptor2.isVar()) {
            return;
        }
        this.generateAccessor(p2, setter2, descriptor2.getSetter() != null ? descriptor2.getSetter() : DescriptorFactory.createDefaultSetter(descriptor2, Annotations.Companion.getEMPTY()));
    }

    private void generateAccessor(@Nullable KtNamedDeclaration p2, @Nullable KtPropertyAccessor accessor, @NotNull PropertyAccessorDescriptor accessorDescriptor) {
        if (this.context instanceof MultifileClassFacadeContext && (Visibilities.isPrivate(accessorDescriptor.getVisibility()) || AsmUtil.getVisibilityAccessFlag(accessorDescriptor) == 2)) {
            return;
        }
        FunctionGenerationStrategy.CodegenBased strategy = accessor == null || !accessor.hasBody() ? (p2 instanceof KtProperty && ((KtProperty)p2).hasDelegate() ? new DelegatedPropertyAccessorStrategy(this.state, accessorDescriptor) : new DefaultPropertyAccessorStrategy(this.state, accessorDescriptor)) : new FunctionGenerationStrategy.FunctionDefault(this.state, accessor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(accessor != null ? accessor : p2, accessorDescriptor), accessorDescriptor, strategy);
    }

    public static StackValue invokeDelegatedPropertyConventionMethod(@NotNull ExpressionCodegen codegen, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @Nullable StackValue receiver, @NotNull PropertyDescriptor propertyDescriptor) {
        codegen.tempVariables.put(resolvedCall2.getCall().getValueArguments().get(1).asElement(), PropertyCodegen.getDelegatedPropertyMetadata(propertyDescriptor, codegen.getBindingContext()));
        return codegen.invokeFunction(resolvedCall2, receiver);
    }

    @NotNull
    public static StackValue getDelegatedPropertyMetadata(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        int index2;
        Type owner = bindingContext.get(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, descriptor2);
        assert (owner != null) : "Delegated property owner not found: " + descriptor2;
        List<VariableDescriptorWithAccessors> allDelegatedProperties = bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES, owner);
        int n = index2 = allDelegatedProperties == null ? -1 : allDelegatedProperties.indexOf(descriptor2);
        if (index2 < 0) {
            throw new AssertionError((Object)("Delegated property not found in " + owner + ": " + descriptor2));
        }
        StackValue.Field array = StackValue.field(Type.getType("[" + AsmTypes.K_PROPERTY_TYPE), owner, "$$delegatedProperties", true, StackValue.none());
        return StackValue.arrayElement(AsmTypes.K_PROPERTY_TYPE, null, array, StackValue.constant(index2, Type.INT_TYPE));
    }

    public void genDelegate(@NotNull PropertyDescriptor delegate, @NotNull PropertyDescriptor delegateTo, @NotNull StackValue field) {
        PropertySetterDescriptor setter2;
        ClassDescriptor toClass = (ClassDescriptor)delegateTo.getContainingDeclaration();
        PropertyGetterDescriptor getter2 = delegate.getGetter();
        if (getter2 != null) {
            this.functionCodegen.genDelegate(getter2, delegateTo.getGetter().getOriginal(), toClass, field);
        }
        if ((setter2 = delegate.getSetter()) != null) {
            this.functionCodegen.genDelegate(setter2, delegateTo.getSetter().getOriginal(), toClass, field);
        }
    }

    private static class DelegatedPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DelegatedPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            super(state2);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            InstructionAdapter v = codegen.v;
            BindingContext bindingContext = this.state.getBindingContext();
            ResolvedCall<FunctionDescriptor> resolvedCall2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, this.propertyAccessorDescriptor);
            assert (resolvedCall2 != null) : "Resolve call should be recorded for delegate call " + signature2.toString();
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property receiver = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            StackValue lastValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen, resolvedCall2, receiver, propertyDescriptor);
            Type asmType = signature2.getReturnType();
            lastValue.put(asmType, v);
            v.areturn(asmType);
        }
    }

    private static class DefaultPropertyAccessorStrategy
    extends FunctionGenerationStrategy.CodegenBased {
        private final PropertyAccessorDescriptor propertyAccessorDescriptor;

        public DefaultPropertyAccessorStrategy(@NotNull GenerationState state2, @NotNull PropertyAccessorDescriptor descriptor2) {
            super(state2);
            this.propertyAccessorDescriptor = descriptor2;
        }

        @Override
        public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
            InstructionAdapter v = codegen.v;
            PropertyDescriptor propertyDescriptor = this.propertyAccessorDescriptor.getCorrespondingProperty();
            StackValue.Property property = codegen.intermediateValueForProperty(propertyDescriptor, true, null, StackValue.LOCAL_0);
            PsiElement jetProperty = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor);
            if (jetProperty instanceof KtProperty || jetProperty instanceof KtParameter) {
                codegen.markLineNumber((KtElement)jetProperty, false);
            }
            if (this.propertyAccessorDescriptor instanceof PropertyGetterDescriptor) {
                Type type2 = signature2.getReturnType();
                property.put(type2, v);
                v.areturn(type2);
            } else if (this.propertyAccessorDescriptor instanceof PropertySetterDescriptor) {
                List<ValueParameterDescriptor> valueParameters = this.propertyAccessorDescriptor.getValueParameters();
                assert (valueParameters.size() == 1) : "Property setter should have only one value parameter but has " + this.propertyAccessorDescriptor;
                int parameterIndex = codegen.lookupLocalIndex(valueParameters.get(0));
                assert (parameterIndex >= 0) : "Local index for setter parameter should be positive or zero: " + this.propertyAccessorDescriptor;
                Type type3 = codegen.typeMapper.mapType(propertyDescriptor);
                property.store(StackValue.local(parameterIndex, type3), codegen.v);
                v.visitInsn(177);
            } else {
                throw new IllegalStateException("Unknown property accessor: " + this.propertyAccessorDescriptor);
            }
        }
    }
}

