/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.TypeIntersectionScope;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.Variance;

public abstract class AbstractTypeParameterDescriptor
extends DeclarationDescriptorNonRootImpl
implements TypeParameterDescriptor {
    private final Variance variance;
    private final boolean reified;
    private final int index;
    private final NotNullLazyValue<TypeConstructor> typeConstructor;
    private final NotNullLazyValue<SimpleType> defaultType;

    protected AbstractTypeParameterDescriptor(final @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Annotations annotations2, final @NotNull Name name, @NotNull Variance variance, boolean isReified, int index2, @NotNull SourceElement source2, final @NotNull SupertypeLoopChecker supertypeLoopChecker) {
        super(containingDeclaration, annotations2, name, source2);
        this.variance = variance;
        this.reified = isReified;
        this.index = index2;
        this.typeConstructor = storageManager.createLazyValue(new Function0<TypeConstructor>(){

            @Override
            public TypeConstructor invoke() {
                return new TypeParameterTypeConstructor(storageManager, supertypeLoopChecker);
            }
        });
        this.defaultType = storageManager.createLazyValue(new Function0<SimpleType>(){

            @Override
            public SimpleType invoke() {
                return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), AbstractTypeParameterDescriptor.this.getTypeConstructor(), Collections.emptyList(), false, new LazyScopeAdapter(storageManager.createLazyValue(new Function0<MemberScope>(){

                    @Override
                    public MemberScope invoke() {
                        return TypeIntersectionScope.create("Scope for type parameter " + name.asString(), AbstractTypeParameterDescriptor.this.getUpperBounds());
                    }
                })));
            }
        });
    }

    protected abstract void reportSupertypeLoopError(@NotNull KotlinType var1);

    @NotNull
    protected abstract List<KotlinType> resolveUpperBounds();

    @Override
    @NotNull
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    public boolean isReified() {
        return this.reified;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isCapturedFromOuterDeclaration() {
        return false;
    }

    @Override
    @NotNull
    public List<KotlinType> getUpperBounds() {
        return ((TypeParameterTypeConstructor)this.getTypeConstructor()).getSupertypes();
    }

    @Override
    @NotNull
    public final TypeConstructor getTypeConstructor() {
        return (TypeConstructor)this.typeConstructor.invoke();
    }

    @Override
    @NotNull
    public SimpleType getDefaultType() {
        return (SimpleType)this.defaultType.invoke();
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getOriginal() {
        return (TypeParameterDescriptor)super.getOriginal();
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        return visitor2.visitTypeParameterDescriptor(this, data2);
    }

    private class TypeParameterTypeConstructor
    extends AbstractTypeConstructor {
        private final SupertypeLoopChecker supertypeLoopChecker;

        public TypeParameterTypeConstructor(@NotNull StorageManager storageManager, SupertypeLoopChecker supertypeLoopChecker) {
            super(storageManager);
            this.supertypeLoopChecker = supertypeLoopChecker;
        }

        @Override
        @NotNull
        protected Collection<KotlinType> computeSupertypes() {
            return AbstractTypeParameterDescriptor.this.resolveUpperBounds();
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @NotNull
        public ClassifierDescriptor getDeclarationDescriptor() {
            return AbstractTypeParameterDescriptor.this;
        }

        @Override
        @NotNull
        public KotlinBuiltIns getBuiltIns() {
            return DescriptorUtilsKt.getBuiltIns(AbstractTypeParameterDescriptor.this);
        }

        public String toString() {
            return AbstractTypeParameterDescriptor.this.getName().toString();
        }

        @Override
        @NotNull
        protected SupertypeLoopChecker getSupertypeLoopChecker() {
            return this.supertypeLoopChecker;
        }

        @Override
        protected void reportSupertypeLoopError(@NotNull KotlinType type2) {
            AbstractTypeParameterDescriptor.this.reportSupertypeLoopError(type2);
        }

        @Override
        @Nullable
        protected KotlinType defaultSupertypeIfEmpty() {
            return ErrorUtils.createErrorType("Cyclic upper bounds");
        }
    }
}

