/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "ide-common"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $receiver) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType, (Collection<? extends TypeParameterDescriptor>)list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $receiver) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Annotated annotated = $receiver.getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType((KotlinType)annotated, (Collection<? extends TypeParameterDescriptor>)list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable($receiver.getType()), (Collection<? extends TypeParameterDescriptor>)$receiver.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return TypeUtilsKt.nullability($receiver.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $receiver.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if (!$receiver.getFreeParameters().contains(typeParameter)) {
            return false;
        }
        List<KotlinType> list2 = typeParameter.getUpperBounds();
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameter.upperBounds");
        KotlinType kotlinType = CollectionsKt.singleOrNull(list2);
        return kotlinType != null ? TypeUtilsKt.isAnyOrNullableAny(kotlinType) : false;
    }

    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.getFreeParameters().isEmpty()) {
            return $receiver.getType();
        }
        HashMap map2 = new HashMap();
        Iterable iterable = $receiver.getType().getArguments();
        List<TypeParameterDescriptor> list2 = $receiver.getType().getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "type.constructor.parameters");
        for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list2)) {
            TypeParameterDescriptor equalToFreeParameter;
            Object v3;
            TypeParameterDescriptor typeParameter;
            block5: {
                TypeProjection argument = (TypeProjection)pair.component1();
                typeParameter = (TypeParameterDescriptor)pair.component2();
                if (argument.getProjectionKind() != Variance.INVARIANT) continue;
                Iterable $receiver$iv = $receiver.getFreeParameters();
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    SimpleType simpleType2 = it.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "it.defaultType");
                    if (!StrictEqualityTypeChecker.INSTANCE.strictEqualTypes((UnwrappedType)simpleType2, argument.getType().unwrap())) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            if ((TypeParameterDescriptor)v3 == null) {
                continue;
            }
            Map map3 = map2;
            TypeConstructor typeConstructor2 = equalToFreeParameter.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "equalToFreeParameter.typeConstructor");
            TypeConstructor typeConstructor3 = typeConstructor2;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            SimpleType simpleType3 = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType3, "typeParameter.defaultType");
            TypeProjection typeProjection = TypeUtilsKt.createProjection(simpleType3, Variance.INVARIANT, null);
            map3.put(typeConstructor3, typeProjection);
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(map2);
        KotlinType kotlinType = substitutor2.substitute($receiver.getType(), Variance.INVARIANT);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $receiver, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(freeParameters, "freeParameters");
        return new FuzzyType($receiver, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $receiver, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            Intrinsics.checkParameterIsNotNull(other, "other");
            Intrinsics.checkParameterIsNotNull(freeParameters, "freeParameters");
            Iterable $receiver$iv = freeParameters;
            if (((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    TypeProjection substituted2;
                    TypeProjection substituted1;
                    SimpleType type2;
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    SimpleType simpleType2 = type2 = parameter.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull(simpleType2, "type");
                    boolean bl2 = $receiver.get(simpleType2) == null ? false : (other.get(type2) == null ? false : !StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(substituted1.getType().unwrap(), substituted2.getType().unwrap()) || substituted1.getProjectionKind() != substituted2.getProjectionKind());
                    if (!bl2) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $receiver, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        Intrinsics.checkParameterIsNotNull(freeParameters, "freeParameters");
        TypeSubstitution typeSubstitution = $receiver.getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution, "this.substitution");
        TypeSubstitution typeSubstitution2 = other.getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitution2, "other.substitution");
        if (FuzzyTypeUtils.hasConflictWith(typeSubstitution, typeSubstitution2, freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor($receiver.getSubstitution(), other.getSubstitution());
    }
}

