/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt$WhenMappings;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a0\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0011H\u0002\u001a8\u0010\u000b\u001a\u00060\fj\u0002`\r*\u00060\fj\u0002`\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0011H\u0002\u00a8\u0006\u0015"}, d2={"collectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "encodeSignature", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getOwnTypeParameters", "nameTypeParameters", "", "encodeForSignature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterNamer", "Lkotlin/Function1;", "projection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameter", "js.frontend"})
public final class EncodeSignatureKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String encodeSignature(@NotNull CallableDescriptor descriptor2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        StringBuilder sig = new StringBuilder();
        Map<TypeParameterDescriptor, String> typeParameterNames = EncodeSignatureKt.nameTypeParameters(descriptor2);
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.typeParameters");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor it;
            TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
            if (!(!typeParameterDescriptor.isCapturedFromOuterDeclaration())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set currentParameters = CollectionsKt.toSet((List)destination$iv$iv);
        Set usedTypeParameters = CollectionsKt.toMutableSet(currentParameters);
        Function1 typeParameterNamer2 = new Function1<TypeParameterDescriptor, String>(usedTypeParameters, typeParameterNames){
            final /* synthetic */ Set $usedTypeParameters;
            final /* synthetic */ Map $typeParameterNames;

            @NotNull
            public final String invoke(@NotNull TypeParameterDescriptor typeParameter) {
                Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
                Collection collection = this.$usedTypeParameters;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter.getOriginal();
                collection.add(typeParameterDescriptor);
                V v = this.$typeParameterNames.get(typeParameter.getOriginal());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                return (String)v;
            }
            {
                this.$usedTypeParameters = set;
                this.$typeParameterNames = map2;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverParameter.type");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer2).append('/');
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            if (valueParameter.getIndex() > 0) {
                sig.append(",");
            }
            if (valueParameter.getVarargElementType() != null) {
                sig.append("*");
            }
            ValueParameterDescriptor valueParameterDescriptor = valueParameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueParameter");
            KotlinType kotlinType = valueParameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueParameter.type");
            EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer2);
        }
        boolean first2 = true;
        Iterator iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)typeParameterNames.keySet()), (Function1)new Function1<TypeParameterDescriptor, Boolean>(usedTypeParameters){
            final /* synthetic */ Set $usedTypeParameters;

            public final boolean invoke(@NotNull TypeParameterDescriptor it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$usedTypeParameters.contains(it);
            }
            {
                this.$usedTypeParameters = set;
                super(1);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv22;
            TypeParameterDescriptor typeParameter = (TypeParameterDescriptor)iterator2.next();
            List<KotlinType> list3 = typeParameter.getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list3, "typeParameter.upperBounds");
            Iterable $i$f$filter = $receiver$iv22 = (Iterable)list3;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                KotlinType it = (KotlinType)element$iv$iv;
                if (!(!KotlinBuiltIns.isNullableAny(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List upperBounds2 = (List)destination$iv$iv2;
            if (upperBounds2.isEmpty() && !currentParameters.contains(typeParameter)) continue;
            sig.append(first2 ? "|" : ",").append(typeParameterNames.get(typeParameter));
            first2 = false;
            if (upperBounds2.isEmpty()) continue;
            sig.append("<:");
            boolean $receiver$iv22 = false;
            for (KotlinType upperBound : (Iterable)upperBounds2) {
                void boundIndex;
                if (boundIndex > 0) {
                    sig.append("&");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                EncodeSignatureKt.encodeForSignature(sig, kotlinType, typeParameterNamer2);
                ++boundIndex;
            }
        }
        String string = sig.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sig.toString()");
        return string;
    }

    private static final StringBuilder encodeForSignature(@NotNull StringBuilder $receiver, KotlinType type2, Function1<? super TypeParameterDescriptor, String> typeParameterNamer2) {
        ClassifierDescriptor declaration;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        if ((declaration = classifierDescriptor) instanceof TypeParameterDescriptor) {
            StringBuilder stringBuilder = $receiver.append(typeParameterNamer2.invoke((TypeParameterDescriptor)declaration));
            Intrinsics.checkExpressionValueIsNotNull(stringBuilder, "append(typeParameterNamer(declaration))");
            return stringBuilder;
        }
        $receiver.append(DescriptorUtils.getFqName(declaration).asString());
        ClassifierDescriptor classifierDescriptor2 = declaration;
        Intrinsics.checkExpressionValueIsNotNull(classifierDescriptor2, "declaration");
        TypeConstructor typeConstructor2 = classifierDescriptor2.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "declaration.typeConstructor");
        List<TypeParameterDescriptor> parameters2 = typeConstructor2.getParameters();
        Collection object2 = type2.getArguments();
        if (!object2.isEmpty()) {
            List<TypeParameterDescriptor> list2 = parameters2;
            Intrinsics.checkExpressionValueIsNotNull(list2, "parameters");
            Collection collection = list2;
            if (!collection.isEmpty()) {
                $receiver.append("<");
                for (Pair pair : CollectionsKt.zip((Iterable)type2.getArguments(), (Iterable)parameters2)) {
                    TypeParameterDescriptor parameter;
                    TypeProjection argument = (TypeProjection)pair.component1();
                    TypeParameterDescriptor typeParameterDescriptor = parameter = (TypeParameterDescriptor)pair.component2();
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "parameter");
                    if (typeParameterDescriptor.getIndex() > 0) {
                        $receiver.append(",");
                    }
                    EncodeSignatureKt.encodeForSignature($receiver, argument, parameter, typeParameterNamer2);
                }
                $receiver.append(">");
            }
        }
        if (type2.isMarkedNullable()) {
            $receiver.append("?");
        }
        return $receiver;
    }

    private static final StringBuilder encodeForSignature(@NotNull StringBuilder $receiver, TypeProjection projection, TypeParameterDescriptor parameter, Function1<? super TypeParameterDescriptor, String> typeParameterNamer2) {
        StringBuilder stringBuilder;
        if (projection.isStarProjection()) {
            StringBuilder stringBuilder2 = $receiver.append("*");
            stringBuilder = stringBuilder2;
            Intrinsics.checkExpressionValueIsNotNull(stringBuilder2, "append(\"*\")");
        } else {
            Variance variance = parameter.getVariance();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance, "parameter.variance");
            Variance variance2 = projection.getProjectionKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)variance2, "projection.projectionKind");
            switch (EncodeSignatureKt$WhenMappings.$EnumSwitchMapping$0[UtilsKt.getEffectiveVariance(variance, variance2).ordinal()]) {
                case 1: {
                    $receiver.append("-");
                    break;
                }
                case 2: {
                    $receiver.append("+");
                }
            }
            KotlinType kotlinType = projection.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "projection.type");
            stringBuilder = EncodeSignatureKt.encodeForSignature($receiver, kotlinType, typeParameterNamer2);
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<TypeParameterDescriptor, String> nameTypeParameters(DeclarationDescriptor descriptor2) {
        Map result2 = new LinkedHashMap();
        boolean bl = false;
        for (List list2 : (Iterable)EncodeSignatureKt.collectTypeParameters(descriptor2)) {
            void listIndex;
            boolean bl2 = false;
            for (TypeParameterDescriptor typeParameter : (Iterable)list2) {
                void indexInList;
                Map map2 = result2;
                String string = "" + (int)listIndex + ':' + (int)indexInList;
                map2.put(typeParameter, string);
                ++indexInList;
            }
            ++listIndex;
        }
        return result2;
    }

    private static final List<List<TypeParameterDescriptor>> collectTypeParameters(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor currentDescriptor = descriptor2;
        List result2 = new ArrayList();
        while (currentDescriptor != null) {
            DeclarationDescriptor declarationDescriptor;
            if (EncodeSignatureKt.getOwnTypeParameters(currentDescriptor) != null) {
                List<TypeParameterDescriptor> list2;
                List<TypeParameterDescriptor> it = list2;
                Collection collection = result2;
                collection.add(it);
            }
            if (currentDescriptor instanceof ConstructorDescriptor) {
                ClassDescriptor classDescriptor = ((ConstructorDescriptor)currentDescriptor).getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "currentDescriptor.constructedClass");
                declarationDescriptor = classDescriptor.getContainingDeclaration();
            } else {
                declarationDescriptor = currentDescriptor.getContainingDeclaration();
            }
            currentDescriptor = declarationDescriptor;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeParameterDescriptor> getOwnTypeParameters(DeclarationDescriptor descriptor2) {
        List list2;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ClassDescriptor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            List<TypeParameterDescriptor> list3 = ((ClassDescriptor)descriptor2).getDeclaredTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.declaredTypeParameters");
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeParameterDescriptor it;
                TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                if (!(!typeParameterDescriptor.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyDescriptor = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.correspondingProperty");
            list2 = EncodeSignatureKt.getOwnTypeParameters(propertyDescriptor);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            Iterable $receiver$iv;
            List<TypeParameterDescriptor> list4 = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list4, "descriptor.typeParameters");
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)list4;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                TypeParameterDescriptor it;
                TypeParameterDescriptor typeParameterDescriptor = it = (TypeParameterDescriptor)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "it");
                if (!(!typeParameterDescriptor.isCapturedFromOuterDeclaration())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }
}

