/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.components.SignaturePropagator;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.kotlinSignature.SignaturesPropagationData;
import org.jetbrains.kotlin.types.KotlinType;

public class SignaturePropagatorImpl
implements SignaturePropagator {
    private final BindingTrace trace;

    public SignaturePropagatorImpl(@NotNull BindingTrace trace2) {
        this.trace = trace2;
    }

    @Override
    @NotNull
    public SignaturePropagator.PropagatedSignature resolvePropagatedSignature(@NotNull JavaMethod method, @NotNull ClassDescriptor owner, @NotNull KotlinType returnType, @Nullable KotlinType receiverType, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull List<TypeParameterDescriptor> typeParameters2) {
        SignaturesPropagationData data2 = new SignaturesPropagationData(owner, returnType, receiverType, valueParameters, typeParameters2, method);
        return new SignaturePropagator.PropagatedSignature(returnType, data2.getModifiedReceiverType(), data2.getModifiedValueParameters(), typeParameters2, data2.getSignatureErrors(), data2.getModifiedHasStableParameterNames());
    }

    @Override
    public void reportSignatureErrors(@NotNull CallableMemberDescriptor descriptor2, @NotNull List<String> signatureErrors) {
        this.trace.record(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2.getOriginal(), signatureErrors);
    }
}

