/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KotlinStringLiteralTextEscaper;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtStringTemplateExpression
extends KtExpressionImpl
implements PsiLanguageInjectionHost {
    private static final TokenSet CLOSE_QUOTE_TOKEN_SET = TokenSet.create(KtTokens.CLOSING_QUOTE);

    public KtStringTemplateExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitStringTemplateExpression(this, data2);
    }

    @NotNull
    public KtStringTemplateEntry[] getEntries() {
        return this.findChildrenByClass(KtStringTemplateEntry.class);
    }

    @Override
    public boolean isValidHost() {
        return this.getNode().getChildren(CLOSE_QUOTE_TOKEN_SET).length != 0;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        KtExpression newExpression = new KtPsiFactory(this.getProject()).createExpressionIfPossible(text2);
        if (newExpression instanceof KtStringTemplateExpression) {
            return (KtStringTemplateExpression)this.replace(newExpression);
        }
        return ElementManipulators.handleContentChange(this, text2);
    }

    @Override
    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new KotlinStringLiteralTextEscaper(this);
    }

    public boolean hasInterpolation() {
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof KtSimpleNameStringTemplateEntry) && !(child instanceof KtBlockStringTemplateEntry)) continue;
            return true;
        }
        return false;
    }
}

