/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.inline.InlineAnalyzerExtension;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;

public class AnalyzerExtensions {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;
    private LanguageVersionSettings languageVersionSettings;

    public AnalyzerExtensions(@NotNull BindingTrace trace2, @NotNull Iterable<ReasonableInlineRule> reasonableInlineRules, @NotNull LanguageVersionSettings languageVersionSettings) {
        this.trace = trace2;
        this.reasonableInlineRules = reasonableInlineRules;
        this.languageVersionSettings = languageVersionSettings;
    }

    public void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        for (Map.Entry<KtNamedFunction, SimpleFunctionDescriptor> entry : bodiesResolveContext.getFunctions().entrySet()) {
            KtNamedFunction function2 = entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = entry.getValue();
            for (AnalyzerExtension analyzerExtension : this.getFunctionExtensions(functionDescriptor)) {
                analyzerExtension.process(functionDescriptor, function2, this.trace);
            }
        }
        for (Map.Entry<KtTypeParameterListOwnerStub, CallableMemberDescriptor> entry : bodiesResolveContext.getProperties().entrySet()) {
            KtProperty function2 = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            for (AnalyzerExtension analyzerExtension : this.getPropertyExtensions(propertyDescriptor)) {
                analyzerExtension.process(propertyDescriptor, function2, this.trace);
            }
        }
    }

    @NotNull
    private List<InlineAnalyzerExtension> getFunctionExtensions(@NotNull FunctionDescriptor functionDescriptor) {
        if (InlineUtil.isInline(functionDescriptor)) {
            return Collections.singletonList(new InlineAnalyzerExtension(this.reasonableInlineRules, this.languageVersionSettings));
        }
        return Collections.emptyList();
    }

    @NotNull
    private List<InlineAnalyzerExtension> getPropertyExtensions(@NotNull PropertyDescriptor propertyDescriptor) {
        if (InlineUtil.hasInlineAccessors(propertyDescriptor)) {
            return Collections.singletonList(new InlineAnalyzerExtension(this.reasonableInlineRules, this.languageVersionSettings));
        }
        return Collections.emptyList();
    }

    public static interface AnalyzerExtension {
        public void process(@NotNull CallableMemberDescriptor var1, @NotNull KtCallableDeclaration var2, @NotNull BindingTrace var3);
    }
}

