/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0004J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\fJ8\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e2\u001e\b\u0002\u0010\u000f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J6\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f2\u001c\u0010\u000f\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u00040\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/DescriptorEquivalenceForOverrides;", "", "()V", "areCallableDescriptorsEquivalent", "", "a", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "b", "ignoreReturnType", "areClassesEquivalent", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "areEquivalent", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "areTypeParametersEquivalent", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "equivalentCallables", "Lkotlin/Function2;", "ownersEquivalent", "descriptors"})
public final class DescriptorEquivalenceForOverrides {
    public static final DescriptorEquivalenceForOverrides INSTANCE;

    public final boolean areEquivalent(@Nullable DeclarationDescriptor a2, @Nullable DeclarationDescriptor b2) {
        return a2 instanceof ClassDescriptor && b2 instanceof ClassDescriptor ? this.areClassesEquivalent((ClassDescriptor)a2, (ClassDescriptor)b2) : (a2 instanceof TypeParameterDescriptor && b2 instanceof TypeParameterDescriptor ? DescriptorEquivalenceForOverrides.areTypeParametersEquivalent$default(this, (TypeParameterDescriptor)a2, (TypeParameterDescriptor)b2, null, 4, null) : (a2 instanceof CallableDescriptor && b2 instanceof CallableDescriptor ? DescriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent$default(this, (CallableDescriptor)a2, (CallableDescriptor)b2, false, 4, null) : (a2 instanceof PackageFragmentDescriptor && b2 instanceof PackageFragmentDescriptor ? Intrinsics.areEqual(((PackageFragmentDescriptor)a2).getFqName(), ((PackageFragmentDescriptor)b2).getFqName()) : Intrinsics.areEqual(a2, b2))));
    }

    private final boolean areClassesEquivalent(ClassDescriptor a2, ClassDescriptor b2) {
        return Intrinsics.areEqual(a2.getTypeConstructor(), b2.getTypeConstructor());
    }

    private final boolean areTypeParametersEquivalent(TypeParameterDescriptor a2, TypeParameterDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, equivalentCallables)) {
            return false;
        }
        return a2.getIndex() == b2.getIndex();
    }

    static /* bridge */ /* synthetic */ boolean areTypeParametersEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, TypeParameterDescriptor typeParameterDescriptor, TypeParameterDescriptor typeParameterDescriptor2, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = areTypeParametersEquivalent.1.INSTANCE;
        }
        return descriptorEquivalenceForOverrides.areTypeParametersEquivalent(typeParameterDescriptor, typeParameterDescriptor2, function2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areCallableDescriptorsEquivalent(@NotNull CallableDescriptor a2, @NotNull CallableDescriptor b2, boolean ignoreReturnType) {
        Intrinsics.checkParameterIsNotNull(a2, "a");
        Intrinsics.checkParameterIsNotNull(b2, "b");
        if (Intrinsics.areEqual(a2, b2)) {
            return true;
        }
        if (Intrinsics.areEqual(a2.getName(), b2.getName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(a2.getContainingDeclaration(), b2.getContainingDeclaration())) {
            return false;
        }
        if (DescriptorUtils.isLocal(a2)) return false;
        if (DescriptorUtils.isLocal(b2)) {
            return false;
        }
        if (!this.ownersEquivalent(a2, b2, areCallableDescriptorsEquivalent.1.INSTANCE)) {
            return false;
        }
        OverridingUtil overridingUtil2 = OverridingUtil.createWithEqualityAxioms(new KotlinTypeChecker.TypeConstructorEquality(a2, b2){
            final /* synthetic */ CallableDescriptor $a;
            final /* synthetic */ CallableDescriptor $b;

            public final boolean invoke(@NotNull TypeConstructor c1, @NotNull TypeConstructor c2) {
                Intrinsics.checkParameterIsNotNull(c1, "c1");
                Intrinsics.checkParameterIsNotNull(c2, "c2");
                if (Intrinsics.areEqual(c1, c2)) {
                    return true;
                }
                ClassifierDescriptor d1 = c1.getDeclarationDescriptor();
                ClassifierDescriptor d2 = c2.getDeclarationDescriptor();
                if (!(d1 instanceof TypeParameterDescriptor) || !(d2 instanceof TypeParameterDescriptor)) {
                    return false;
                }
                return DescriptorEquivalenceForOverrides.access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides.INSTANCE, (TypeParameterDescriptor)d1, (TypeParameterDescriptor)d2, new Function2<DeclarationDescriptor, DeclarationDescriptor, Boolean>(this){
                    final /* synthetic */ areCallableDescriptorsEquivalent.overridingUtil.1 this$0;

                    public final boolean invoke(@Nullable DeclarationDescriptor x, @Nullable DeclarationDescriptor y) {
                        return Intrinsics.areEqual(x, this.this$0.$a) && Intrinsics.areEqual(y, this.this$0.$b);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                });
            }
            {
                this.$a = callableDescriptor;
                this.$b = callableDescriptor2;
            }
        });
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo = overridingUtil2.isOverridableBy(a2, b2, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull(overrideCompatibilityInfo, "overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        OverridingUtil.OverrideCompatibilityInfo overrideCompatibilityInfo2 = overridingUtil2.isOverridableBy(b2, a2, null, !ignoreReturnType);
        Intrinsics.checkExpressionValueIsNotNull(overrideCompatibilityInfo2, "overridingUtil.isOverrid\u2026 null, !ignoreReturnType)");
        if (overrideCompatibilityInfo2.getResult() != OverridingUtil.OverrideCompatibilityInfo.Result.OVERRIDABLE) return false;
        return true;
    }

    public static /* bridge */ /* synthetic */ boolean areCallableDescriptorsEquivalent$default(DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides, CallableDescriptor callableDescriptor, CallableDescriptor callableDescriptor2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return descriptorEquivalenceForOverrides.areCallableDescriptorsEquivalent(callableDescriptor, callableDescriptor2, bl);
    }

    private final boolean ownersEquivalent(DeclarationDescriptor a2, DeclarationDescriptor b2, Function2<? super DeclarationDescriptor, ? super DeclarationDescriptor, Boolean> equivalentCallables) {
        DeclarationDescriptor aOwner = a2.getContainingDeclaration();
        DeclarationDescriptor bOwner = b2.getContainingDeclaration();
        return aOwner instanceof CallableMemberDescriptor || bOwner instanceof CallableMemberDescriptor ? equivalentCallables.invoke(aOwner, bOwner).booleanValue() : this.areEquivalent(aOwner, bOwner);
    }

    private DescriptorEquivalenceForOverrides() {
    }

    static {
        DescriptorEquivalenceForOverrides descriptorEquivalenceForOverrides;
        INSTANCE = descriptorEquivalenceForOverrides = new DescriptorEquivalenceForOverrides();
    }

    public static final /* synthetic */ boolean access$areTypeParametersEquivalent(DescriptorEquivalenceForOverrides $this, @NotNull TypeParameterDescriptor a2, @NotNull TypeParameterDescriptor b2, @NotNull Function2 equivalentCallables) {
        return $this.areTypeParametersEquivalent(a2, b2, equivalentCallables);
    }
}

