/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.DeclarationAttributeAltererExtension;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.OperatorModifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.PublishedApiUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;

public class ModifiersChecker {
    private final AnnotationChecker annotationChecker;
    private final Iterable<DeclarationChecker> declarationCheckers;
    private final LanguageVersionSettings languageVersionSettings;
    private final ExpectActualTracker expectActualTracker;
    private final DeprecationResolver deprecationResolver;
    private final ModuleDescriptor moduleDescriptor;

    @NotNull
    public static Modality resolveMemberModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor) {
        return ModifiersChecker.resolveModalityFromModifiers(modifierListOwner, defaultModality, bindingContext, containingDescriptor, false);
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@Nullable KtModifierListOwner modifierListOwner, @NotNull Modality defaultModality, @NotNull BindingContext bindingContext, @Nullable DeclarationDescriptor containingDescriptor, boolean allowSealed) {
        KtModifierList modifierList = modifierListOwner != null ? modifierListOwner.getModifierList() : null;
        Modality modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality, allowSealed);
        if (modifierListOwner != null) {
            List extensions = DeclarationAttributeAltererExtension.Companion.getInstances(modifierListOwner.getProject());
            DeclarationDescriptor descriptor2 = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, modifierListOwner);
            for (DeclarationAttributeAltererExtension extension : extensions) {
                Modality newModality = extension.refineDeclarationModality(modifierListOwner, descriptor2, containingDescriptor, modality, bindingContext, false);
                if (newModality == null) continue;
                modality = newModality;
                break;
            }
        }
        return modality;
    }

    @NotNull
    private static Modality resolveModalityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Modality defaultModality, boolean allowSealed) {
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        if (allowSealed && modifierList.hasModifier(KtTokens.SEALED_KEYWORD)) {
            return Modality.SEALED;
        }
        if (modifierList.hasModifier(KtTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(KtTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull KtModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        return ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable KtModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(KtTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(KtTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(KtTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public ModifiersChecker(@NotNull AnnotationChecker annotationChecker, @NotNull Iterable<DeclarationChecker> declarationCheckers, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker, @NotNull DeprecationResolver deprecationResolver, @NotNull ModuleDescriptor moduleDescriptor) {
        this.annotationChecker = annotationChecker;
        this.declarationCheckers = declarationCheckers;
        this.languageVersionSettings = languageVersionSettings;
        this.expectActualTracker = expectActualTracker;
        this.deprecationResolver = deprecationResolver;
        this.moduleDescriptor = moduleDescriptor;
    }

    @NotNull
    public ModifiersCheckingProcedure withTrace(@NotNull BindingTrace trace2) {
        return new ModifiersCheckingProcedure(trace2);
    }

    public class ModifiersCheckingProcedure {
        private final BindingTrace trace;

        private ModifiersCheckingProcedure(@NotNull BindingTrace trace2) {
            this.trace = trace2;
        }

        public void checkParameterHasNoValOrVar(@NotNull KtValVarKeywordOwner parameter, @NotNull DiagnosticFactory1<PsiElement, KtKeywordToken> diagnosticFactory) {
            PsiElement valOrVar = parameter.getValOrVarKeyword();
            if (valOrVar != null) {
                this.trace.report(diagnosticFactory.on(valOrVar, (KtKeywordToken)valOrVar.getNode().getElementType()));
            }
        }

        public void checkModifiersForDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull MemberDescriptor descriptor2) {
            this.checkNestedClassAllowed(modifierListOwner, descriptor2);
            this.checkTypeParametersModifiers(modifierListOwner);
            this.checkModifierListCommon(modifierListOwner, descriptor2);
            this.checkIllegalHeader(modifierListOwner, descriptor2);
        }

        private void checkNestedClassAllowed(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
            if (!(declaration instanceof KtClassOrObject)) {
                return;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)declaration;
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (!(containingDeclaration instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
            DetailedClassKind kind = DetailedClassKind.getClassKind(classDescriptor);
            if (kind == DetailedClassKind.ANONYMOUS_OBJECT || kind == DetailedClassKind.ENUM_ENTRY) {
                return;
            }
            if ((kind == DetailedClassKind.ENUM_CLASS || kind == DetailedClassKind.OBJECT || kind == DetailedClassKind.COMPANION_OBJECT) && DescriptorUtils.isLocal(classDescriptor)) {
                return;
            }
            if (DescriptorUtils.isEnumEntry(containingClass) && !classDescriptor.isInner() && kind != DetailedClassKind.COMPANION_OBJECT) {
                DiagnosticFactory1<KtClassOrObject, String> diagnostic = ModifiersChecker.this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInEnumEntryShouldBeInner) ? Errors.NESTED_CLASS_NOT_ALLOWED : Errors.NESTED_CLASS_DEPRECATED;
                this.trace.report(diagnostic.on(ktClassOrObject, kind.withCapitalFirstLetter));
                return;
            }
            if (!classDescriptor.isInner() && (containingClass.isInner() || DescriptorUtils.isLocal(containingClass))) {
                this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(ktClassOrObject, kind.withCapitalFirstLetter));
            }
        }

        private void checkModifierListCommon(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            AnnotationUseSiteTargetChecker.INSTANCE.check(modifierListOwner, descriptor2, this.trace);
            this.runDeclarationCheckers(modifierListOwner, descriptor2);
            ModifiersChecker.this.annotationChecker.check(modifierListOwner, this.trace, descriptor2);
            ModifierCheckerCore.INSTANCE.check(modifierListOwner, this.trace, descriptor2, ModifiersChecker.this.languageVersionSettings);
        }

        public void checkModifiersForLocalDeclaration(@NotNull KtDeclaration modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            this.checkModifierListCommon(modifierListOwner, descriptor2);
        }

        public void checkModifiersForDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration) {
            ModifiersChecker.this.annotationChecker.check(multiDeclaration, this.trace, null);
            ModifierCheckerCore.INSTANCE.check(multiDeclaration, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            for (KtDestructuringDeclarationEntry multiEntry : multiDeclaration.getEntries()) {
                ModifiersChecker.this.annotationChecker.check(multiEntry, this.trace, null);
                ModifierCheckerCore.INSTANCE.check(multiEntry, this.trace, null, ModifiersChecker.this.languageVersionSettings);
                UnderscoreChecker.INSTANCE.checkNamed(multiEntry, this.trace, ModifiersChecker.this.languageVersionSettings, true);
            }
        }

        private void checkIllegalHeader(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor2) {
            PsiElement keyword;
            KtModifierList modifierList = modifierListOwner.getModifierList();
            PsiElement psiElement = keyword = modifierList != null ? modifierList.getModifier(KtTokens.HEADER_KEYWORD) : null;
            if (keyword != null && descriptor2 instanceof ClassDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.HEADER_KEYWORD, "nested class"));
            } else if (keyword == null && modifierList != null && (keyword = modifierList.getModifier(KtTokens.EXPECT_KEYWORD)) != null && descriptor2 instanceof ClassDescriptor && descriptor2.getContainingDeclaration() instanceof ClassDescriptor) {
                this.trace.report(Errors.WRONG_MODIFIER_TARGET.on(keyword, KtTokens.EXPECT_KEYWORD, "nested class"));
            }
        }

        @NotNull
        public Map<KtModifierKeywordToken, PsiElement> getTokensCorrespondingToModifiers(@NotNull KtModifierList modifierList, @NotNull Collection<KtModifierKeywordToken> possibleModifiers) {
            HashMap<KtModifierKeywordToken, PsiElement> tokens = Maps.newHashMap();
            for (KtModifierKeywordToken modifier : possibleModifiers) {
                if (!modifierList.hasModifier(modifier)) continue;
                tokens.put(modifier, modifierList.getModifier(modifier));
            }
            return tokens;
        }

        public void runDeclarationCheckers(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2) {
            DeclarationCheckerContext context = new DeclarationCheckerContext(this.trace, ModifiersChecker.this.languageVersionSettings, ModifiersChecker.this.deprecationResolver, ModifiersChecker.this.moduleDescriptor, ModifiersChecker.this.expectActualTracker);
            for (DeclarationChecker checker : ModifiersChecker.this.declarationCheckers) {
                checker.check(declaration, descriptor2, context);
            }
            OperatorModifierChecker.INSTANCE.check(declaration, descriptor2, this.trace, ModifiersChecker.this.languageVersionSettings);
            PublishedApiUsageChecker.INSTANCE.check(declaration, descriptor2, this.trace);
        }

        public void checkTypeParametersModifiers(@NotNull KtModifierListOwner modifierListOwner) {
            if (!(modifierListOwner instanceof KtTypeParameterListOwner)) {
                return;
            }
            List<KtTypeParameter> typeParameters2 = ((KtTypeParameterListOwner)modifierListOwner).getTypeParameters();
            for (KtTypeParameter typeParameter : typeParameters2) {
                ModifierCheckerCore.INSTANCE.check(typeParameter, this.trace, null, ModifiersChecker.this.languageVersionSettings);
            }
        }
    }

    private static enum DetailedClassKind {
        ENUM_CLASS("Enum class"),
        ENUM_ENTRY("Enum entry"),
        ANNOTATION_CLASS("Annotation class"),
        INTERFACE("Interface"),
        COMPANION_OBJECT("Companion object"),
        ANONYMOUS_OBJECT("Anonymous object"),
        OBJECT("Object"),
        CLASS("Class");

        public final String withCapitalFirstLetter;

        private DetailedClassKind(String withCapitalFirstLetter) {
            this.withCapitalFirstLetter = withCapitalFirstLetter;
        }

        @NotNull
        public static DetailedClassKind getClassKind(@NotNull ClassDescriptor descriptor2) {
            if (DescriptorUtils.isEnumEntry(descriptor2)) {
                return ENUM_ENTRY;
            }
            if (DescriptorUtils.isEnumClass(descriptor2)) {
                return ENUM_CLASS;
            }
            if (DescriptorUtils.isAnnotationClass(descriptor2)) {
                return ANNOTATION_CLASS;
            }
            if (DescriptorUtils.isInterface(descriptor2)) {
                return INTERFACE;
            }
            if (DescriptorUtils.isCompanionObject(descriptor2)) {
                return COMPANION_OBJECT;
            }
            if (DescriptorUtils.isAnonymousObject(descriptor2)) {
                return ANONYMOUS_OBJECT;
            }
            if (DescriptorUtils.isObject(descriptor2)) {
                return OBJECT;
            }
            return CLASS;
        }
    }
}

