/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.BindingTrace;

public class PlatformClassesMappedToKotlinChecker {
    public static void checkPlatformClassesMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace2, @NotNull KtImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors) {
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                PlatformClassesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(platformToKotlinMap, trace2, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace2, @NotNull KtElement element, @NotNull DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor2);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace2.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element, kotlinAnalogsForClass));
        }
    }
}

