/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeReconstructionResult;

public class TypeReconstructionUtil {
    @NotNull
    public static KotlinType reconstructBareType(@NotNull KtTypeReference right, @NotNull PossiblyBareType possiblyBareTarget, @Nullable KotlinType subjectType, @NotNull BindingTrace trace2, @NotNull KotlinBuiltIns builtIns) {
        KotlinType targetType;
        TypeReconstructionResult reconstructionResult;
        if (subjectType == null) {
            subjectType = builtIns.getAnyType();
        }
        if (!(reconstructionResult = possiblyBareTarget.reconstruct(subjectType)).isAllArgumentsInferred()) {
            TypeConstructor typeConstructor2 = possiblyBareTarget.getBareTypeConstructor();
            trace2.report(Errors.NO_TYPE_ARGUMENTS_ON_RHS.on(right, typeConstructor2.getParameters().size(), TypeReconstructionUtil.allStarProjectionsString(typeConstructor2)));
        }
        if ((targetType = reconstructionResult.getResultingType()) != null) {
            if (possiblyBareTarget.isBare()) {
                trace2.record(BindingContext.TYPE, right, targetType);
            }
            return targetType;
        }
        return ErrorUtils.createErrorType("Failed to reconstruct type: " + right.getText());
    }

    @NotNull
    private static String allStarProjectionsString(@NotNull TypeConstructor constructor) {
        int size = constructor.getParameters().size();
        assert (size != 0) : "No projections possible for a nilary type constructor" + constructor;
        ClassifierDescriptor declarationDescriptor = constructor.getDeclarationDescriptor();
        assert (declarationDescriptor != null) : "No declaration descriptor for type constructor " + constructor;
        String name = declarationDescriptor.getName().asString();
        return TypeReconstructionUtil.getTypeNameAndStarProjectionsString(name, size);
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name, int size) {
        StringBuilder builder = new StringBuilder(name);
        builder.append("<");
        for (int i2 = 0; i2 < size; ++i2) {
            builder.append("*");
            if (i2 == size - 1) break;
            builder.append(", ");
        }
        builder.append(">");
        return builder.toString();
    }
}

