/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        for (int i2 = 0; line != null && i2 < line.length(); ++i2) {
            if (i2 == cursor) {
                wordIndex = words.size();
                wordCursor = current.length();
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i2)) {
                quoteStart = i2;
                continue;
            }
            if (quoteStart >= 0) {
                if (line.charAt(quoteStart) == line.charAt(i2) && !this.isEscaped(line, i2)) {
                    words.add(current.toString());
                    current.setLength(0);
                    quoteStart = -1;
                    continue;
                }
                if (this.isEscapeChar(line, i2)) continue;
                current.append(line.charAt(i2));
                continue;
            }
            if (this.isDelimiter(line, i2)) {
                if (current.length() <= 0) continue;
                words.add(current.toString());
                current.setLength(0);
                continue;
            }
            if (this.isEscapeChar(line, i2)) continue;
            current.append(line.charAt(i2));
        }
        if (current.length() > 0 || cursor == line.length()) {
            words.add(current.toString());
        }
        if (cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
        }
        if (this.eofOnEscapedNewLine && this.isEscapeChar(line, line.length() - 1)) {
            throw new EOFError(-1, -1, "Escaped new line", "newline");
        }
        if (this.eofOnUnclosedQuote && quoteStart >= 0) {
            throw new EOFError(-1, -1, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
        }
        return new ArgumentList(line, words, wordIndex, wordCursor, cursor);
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i2 = 0; this.quoteChars != null && i2 < this.quoteChars.length; ++i2) {
            if (buffer.charAt(pos) != this.quoteChars[i2]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        for (int i2 = 0; this.escapeChars != null && i2 < this.escapeChars.length; ++i2) {
            if (buffer.charAt(pos) != this.escapeChars[i2]) continue;
            return !this.isEscaped(buffer, pos);
        }
        return false;
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    public static class ArgumentList
    implements ParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;

        public ArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }
    }
}

