/*
 * Decompiled with CFR 0.152.
 */
package ru.yole.jkid.deserialization;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import ru.yole.jkid.UtilKt;
import ru.yole.jkid.deserialization.ClassInfoCache;
import ru.yole.jkid.deserialization.JKidException;
import ru.yole.jkid.deserialization.ObjectListSeed;
import ru.yole.jkid.deserialization.ObjectSeed;
import ru.yole.jkid.deserialization.Parser;
import ru.yole.jkid.deserialization.Seed;
import ru.yole.jkid.deserialization.ValueListSeed;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0005\u001a+\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a\"\u0010\u0000\u001a\u0002H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010\n\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"deserialize", "T", "", "json", "Ljava/io/Reader;", "(Ljava/io/Reader;)Ljava/lang/Object;", "targetClass", "Lkotlin/reflect/KClass;", "(Ljava/io/Reader;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "", "(Ljava/lang/String;)Ljava/lang/Object;", "createSeedForType", "Lru/yole/jkid/deserialization/Seed;", "paramType", "Ljava/lang/reflect/Type;", "isList", "", "build"})
public final class DeserializerKt {
    private static final <T> T deserialize(String json) {
        Reader json$iv = new StringReader(json);
        Intrinsics.reifiedOperationMarker(4, "T");
        return DeserializerKt.deserialize(json$iv, Reflection.getOrCreateKotlinClass(Object.class));
    }

    private static final <T> T deserialize(Reader json) {
        Intrinsics.reifiedOperationMarker(4, "T");
        return DeserializerKt.deserialize(json, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> T deserialize(@NotNull Reader json, @NotNull KClass<T> targetClass) {
        Intrinsics.checkParameterIsNotNull(json, "json");
        Intrinsics.checkParameterIsNotNull(targetClass, "targetClass");
        ObjectSeed<T> seed = new ObjectSeed<T>(targetClass, new ClassInfoCache());
        new Parser(json, seed).parse();
        return seed.spawn();
    }

    @NotNull
    public static final Seed createSeedForType(@NotNull Seed $receiver, @NotNull Type paramType, boolean isList) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(paramType, "paramType");
        Class<Object> paramClass = UtilKt.asJavaClass(paramType);
        if (List.class.isAssignableFrom(paramClass)) {
            Type elementType;
            if (!isList) {
                throw (Throwable)new JKidException("An array expected, not a composite object");
            }
            Type type2 = paramType;
            if (!(type2 instanceof ParameterizedType)) {
                type2 = null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            if (parameterizedType == null) {
                throw (Throwable)new UnsupportedOperationException("Unsupported parameter type " + $receiver);
            }
            ParameterizedType parameterizedType2 = parameterizedType;
            Type[] typeArray = parameterizedType2.getActualTypeArguments();
            Intrinsics.checkExpressionValueIsNotNull(typeArray, "parameterizedType.actualTypeArguments");
            Type type3 = elementType = (Type)ArraysKt.single((Object[])typeArray);
            Intrinsics.checkExpressionValueIsNotNull(type3, "elementType");
            if (UtilKt.isPrimitiveOrString(type3)) {
                return new ValueListSeed(elementType, $receiver.getClassInfoCache());
            }
            return new ObjectListSeed(elementType, $receiver.getClassInfoCache());
        }
        if (isList) {
            throw (Throwable)new JKidException("Object of the type " + paramType.getTypeName() + " expected, not an array");
        }
        return new ObjectSeed<Object>(JvmClassMappingKt.getKotlinClass(paramClass), $receiver.getClassInfoCache());
    }
}

