/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.gradle.workers;

import java.io.File;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.DokkaConfiguration;
import org.jetbrains.dokka.DokkaGenerator;
import org.jetbrains.dokka.gradle.internal.InternalDokkaGradlePluginApi;
import org.jetbrains.dokka.gradle.internal.LoggerAdapter;
import org.jetbrains.dokka.utilities.DokkaLogger;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker;", "Lorg/gradle/workers/WorkAction;", "Lorg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker$Parameters;", "()V", "execute", "", "executeDokkaGenerator", "logFile", "Ljava/io/File;", "dokkaParameters", "Lorg/jetbrains/dokka/DokkaConfiguration;", "prepareOutputDir", "Companion", "Parameters", "dokka-gradle-plugin"})
@InternalDokkaGradlePluginApi
@SourceDebugExtension(value={"SMAP\nDokkaGeneratorWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DokkaGeneratorWorker.kt\norg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1855#2,2:96\n*E\n*S KotlinDebug\n*F\n+ 1 DokkaGeneratorWorker.kt\norg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker\n*L\n57#1,2:96\n*E\n"})
public abstract class DokkaGeneratorWorker
implements WorkAction<Parameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final org.gradle.api.logging.Logger logger;

    public void execute() {
        Object object = ((Parameters)this.getParameters()).getDokkaParameters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.dokkaParameters.get()");
        DokkaConfiguration dokkaParameters = (DokkaConfiguration)object;
        this.prepareOutputDir(dokkaParameters);
        File file = ((RegularFile)((Parameters)this.getParameters()).getLogFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.logFile.get().asFile");
        this.executeDokkaGenerator(file, dokkaParameters);
    }

    private final void prepareOutputDir(DokkaConfiguration dokkaParameters) {
        FilesKt.deleteRecursively((File)dokkaParameters.getOutputDir());
        dokkaParameters.getOutputDir().mkdirs();
        Iterable $this$forEach$iv = dokkaParameters.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DokkaConfiguration.DokkaModuleDescription module = (DokkaConfiguration.DokkaModuleDescription)element$iv;
            boolean bl = false;
            File moduleDir = FilesKt.resolve((File)dokkaParameters.getOutputDir(), (File)module.getRelativePathToOutputDirectory());
            moduleDir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeDokkaGenerator(File logFile, DokkaConfiguration dokkaParameters) {
        Logger logger = (Logger)DokkaGeneratorWorker.logger;
        Object object = ((Parameters)this.getParameters()).getTaskPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.taskPath.get()");
        AutoCloseable autoCloseable = new LoggerAdapter(logFile, logger, (String)object);
        Throwable throwable = null;
        try {
            LoggerAdapter logger2 = (LoggerAdapter)autoCloseable;
            boolean bl = false;
            logger2.progress("Executing DokkaGeneratorWorker with dokkaParameters: " + dokkaParameters);
            DokkaGenerator generator = new DokkaGenerator(dokkaParameters, (DokkaLogger)logger2);
            Duration duration2 = DokkaGeneratorWorker.Companion.measureTime((Function0<Unit>)((Function0)new Function0<Unit>(generator){
                final /* synthetic */ DokkaGenerator $generator;
                {
                    this.$generator = $generator;
                    super(0);
                }

                public final void invoke() {
                    this.$generator.generate();
                }
            }));
            logger2.info("DokkaGeneratorWorker completed in " + duration2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static {
        org.gradle.api.logging.Logger logger = Logging.getLogger(DokkaGeneratorWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DokkaGeneratorWorker::class.java)");
        DokkaGeneratorWorker.logger = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "measureTime", "Ljava/time/Duration;", "block", "Lkotlin/Function0;", "", "dokka-gradle-plugin"})
    @InternalDokkaGradlePluginApi
    public static final class Companion {
        private Companion() {
        }

        private final Duration measureTime(Function0<Unit> block) {
            long startTime = System.nanoTime();
            boolean bl = false;
            block.invoke();
            Duration duration2 = Duration.ofNanos(System.nanoTime() - startTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"nanoTime().let { startTi\u2026 startTime)\n            }");
            return duration2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/dokka/gradle/workers/DokkaGeneratorWorker$Parameters;", "Lorg/gradle/workers/WorkParameters;", "dokkaParameters", "Lorg/gradle/api/provider/Property;", "Lorg/jetbrains/dokka/DokkaConfiguration;", "getDokkaParameters", "()Lorg/gradle/api/provider/Property;", "logFile", "Lorg/gradle/api/file/RegularFileProperty;", "getLogFile", "()Lorg/gradle/api/file/RegularFileProperty;", "taskPath", "", "getTaskPath", "dokka-gradle-plugin"})
    @InternalDokkaGradlePluginApi
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public Property<DokkaConfiguration> getDokkaParameters();

        @NotNull
        public RegularFileProperty getLogFile();

        @NotNull
        public Property<String> getTaskPath();
    }
}

