/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dokka.gradle.adapters;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.gradle.DokkaExtension;
import org.jetbrains.dokka.gradle.adapters.JavaAdapter;
import org.jetbrains.dokka.gradle.engine.parameters.DokkaSourceSetSpec;
import org.jetbrains.dokka.gradle.engine.parameters.KotlinPlatform;
import org.jetbrains.dokka.gradle.internal.GradleProviderUtilsKt;
import org.jetbrains.dokka.gradle.internal.InternalDokkaGradlePluginApi;
import org.jetbrains.dokka.gradle.internal.StringUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\u0002H\u0002J,\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J&\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/dokka/gradle/adapters/JavaAdapter;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "apply", "", "project", "detectJavaToolchainVersion", "dokkaExtension", "Lorg/jetbrains/dokka/gradle/DokkaExtension;", "java", "Lorg/gradle/api/plugins/JavaPluginExtension;", "isConflictingPluginPresent", "Lorg/gradle/api/provider/Provider;", "", "register", "dokkaSourceSets", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lorg/jetbrains/dokka/gradle/engine/parameters/DokkaSourceSetSpec;", "src", "Lorg/gradle/api/tasks/SourceSet;", "registerDokkaSourceSets", "sourceSets", "Lorg/gradle/api/tasks/SourceSetContainer;", "Companion", "dokka-gradle-plugin"})
@InternalDokkaGradlePluginApi
@SourceDebugExtension(value={"SMAP\nJavaAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaAdapter.kt\norg/jetbrains/dokka/gradle/adapters/JavaAdapter\n+ 2 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 3 TypeOfExtensions.kt\norg/gradle/kotlin/dsl/TypeOfExtensionsKt\n+ 4 DomainObjectCollectionExtensions.kt\norg/gradle/kotlin/dsl/DomainObjectCollectionExtensionsKt\n*L\n1#1,152:1\n110#2:153\n28#3:154\n47#4:155\n*E\n*S KotlinDebug\n*F\n+ 1 JavaAdapter.kt\norg/jetbrains/dokka/gradle/adapters/JavaAdapter\n*L\n46#1:153\n46#1:154\n49#1:155\n*E\n"})
public abstract class JavaAdapter
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providers;
    private final Logger logger;

    @Inject
    public JavaAdapter(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
        this.logger = Logging.getLogger(this.getClass());
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.logger.info("applied DokkaJavaAdapter to " + project.getPath());
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $this$getByType$iv = extensionContainer;
        boolean $i$f$getByType = false;
        boolean $i$f$typeOf = false;
        Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<DokkaExtension>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
        DokkaExtension dokkaExtension2 = (DokkaExtension)object;
        PluginContainer pluginContainer = project.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
        DomainObjectCollection $this$withType$iv = (DomainObjectCollection)pluginContainer;
        boolean $i$f$withType = false;
        DomainObjectCollection domainObjectCollection = $this$withType$iv.withType(JavaBasePlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)domainObjectCollection, (String)"withType(S::class.java)");
        domainObjectCollection.configureEach(new Action(project, this, dokkaExtension2){
            final /* synthetic */ Project $project;
            final /* synthetic */ JavaAdapter this$0;
            final /* synthetic */ DokkaExtension $dokkaExtension;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$dokkaExtension = $dokkaExtension;
            }

            public final void execute(JavaBasePlugin $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                ExtensionContainer extensionContainer = this.$project.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
                ExtensionContainer $this$getByType$iv = extensionContainer;
                boolean $i$f$getByType = false;
                boolean $i$f$typeOf = false;
                Object object = $this$getByType$iv.getByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(typeOf<T>())");
                JavaPluginExtension java = (JavaPluginExtension)object;
                ExtensionContainer extensionContainer2 = this.$project.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer2, (String)"project.extensions");
                ExtensionContainer $this$getByType$iv2 = extensionContainer2;
                boolean $i$f$getByType2 = false;
                boolean $i$f$typeOf2 = false;
                Object object2 = $this$getByType$iv2.getByType((TypeOf)new TypeOf<SourceSetContainer>(){});
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByType(typeOf<T>())");
                SourceSetContainer sourceSets = (SourceSetContainer)object2;
                JavaAdapter.access$detectJavaToolchainVersion(this.this$0, this.$dokkaExtension, java);
                Provider isConflictingPluginPresent2 = JavaAdapter.access$isConflictingPluginPresent(this.this$0, this.$project);
                JavaAdapter.access$registerDokkaSourceSets(this.this$0, this.$dokkaExtension, sourceSets, isConflictingPluginPresent2);
            }
        });
    }

    private final void detectJavaToolchainVersion(DokkaExtension dokkaExtension2, JavaPluginExtension java) {
        Property property = java.getToolchain().getLanguageVersion();
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"java\n            .toolch\u2026         .languageVersion");
        Property toolchainLanguageVersion = property;
        dokkaExtension2.getDokkaSourceSets().configureEach(new Action((Property<JavaLanguageVersion>)toolchainLanguageVersion){
            final /* synthetic */ Property<JavaLanguageVersion> $toolchainLanguageVersion;
            {
                this.$toolchainLanguageVersion = $toolchainLanguageVersion;
            }

            public final void execute(DokkaSourceSetSpec $this$configureEach) {
                Intrinsics.checkNotNullParameter((Object)$this$configureEach, (String)"$this$configureEach");
                $this$configureEach.getJdkVersion().set(this.$toolchainLanguageVersion.map((Transformer)detectJavaToolchainVersion.1.INSTANCE).orElse((Object)11));
            }
        });
    }

    private final void registerDokkaSourceSets(DokkaExtension dokkaExtension2, SourceSetContainer sourceSets, Provider<Boolean> isConflictingPluginPresent2) {
        sourceSets.all(new Action(this, dokkaExtension2, isConflictingPluginPresent2){
            final /* synthetic */ JavaAdapter this$0;
            final /* synthetic */ DokkaExtension $dokkaExtension;
            final /* synthetic */ Provider<Boolean> $isConflictingPluginPresent;
            {
                this.this$0 = $receiver;
                this.$dokkaExtension = $dokkaExtension;
                this.$isConflictingPluginPresent = $isConflictingPluginPresent;
            }

            public final void execute(SourceSet $this$jss) {
                Intrinsics.checkNotNullParameter((Object)$this$jss, (String)"$this$jss");
                JavaAdapter.access$register(this.this$0, this.$dokkaExtension.getDokkaSourceSets(), $this$jss, this.$isConflictingPluginPresent);
            }
        });
    }

    private final void register(NamedDomainObjectContainer<DokkaSourceSetSpec> dokkaSourceSets2, SourceSet src, Provider<Boolean> isConflictingPluginPresent2) {
        StringBuilder stringBuilder = new StringBuilder().append("java");
        String string = src.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"src.name");
        dokkaSourceSets2.register(stringBuilder.append(StringUtilsKt.uppercaseFirstChar(string)).toString(), new Action(src, isConflictingPluginPresent2, this){
            final /* synthetic */ SourceSet $src;
            final /* synthetic */ Provider<Boolean> $isConflictingPluginPresent;
            final /* synthetic */ JavaAdapter this$0;
            {
                this.$src = $src;
                this.$isConflictingPluginPresent = $isConflictingPluginPresent;
                this.this$0 = $receiver;
            }

            public final void execute(DokkaSourceSetSpec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.getSuppress().convention(GradleProviderUtilsKt.or(!JavaAdapter.Companion.isPublished(this.$src), this.$isConflictingPluginPresent));
                Object[] objectArray = new Object[]{this.$src.getJava()};
                $this$register.getSourceRoots().from(objectArray);
                $this$register.getAnalysisPlatform().convention((Object)((Object)KotlinPlatform.JVM));
                objectArray = new Object[]{JavaAdapter.access$getProviders$p(this.this$0).provider(new Callable(this.$src){
                    final /* synthetic */ SourceSet $src;
                    {
                        this.$src = $src;
                    }

                    public final FileCollection call() {
                        return this.$src.getCompileClasspath();
                    }
                })};
                $this$register.getClasspath().from(objectArray);
                objectArray = new Object[]{this.$src.getCompileJavaTaskName()};
                $this$register.getClasspath().builtBy(objectArray);
            }
        });
    }

    private final Provider<Boolean> isConflictingPluginPresent(Project project) {
        Provider provider = this.providers.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Boolean call() {
                return this.$project.getPluginManager().hasPlugin("org.jetbrains.kotlin.android") || this.$project.getPluginManager().hasPlugin("org.jetbrains.kotlin.js") || this.$project.getPluginManager().hasPlugin("org.jetbrains.kotlin.jvm") || this.$project.getPluginManager().hasPlugin("org.jetbrains.kotlin.multiplatform");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project: Project\n    ): \u2026nMultiplatform)\n        }");
        Provider projectHasKotlinPlugin2 = provider;
        Provider provider2 = this.providers.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Boolean call() {
                return this.$project.getPluginManager().hasPlugin("com.android.base") || this.$project.getPluginManager().hasPlugin("com.android.application") || this.$project.getPluginManager().hasPlugin("com.android.library");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project: Project\n    ): \u2026AndroidLibrary)\n        }");
        Provider projectHasAndroidPlugin2 = provider2;
        return GradleProviderUtilsKt.or((Provider<Boolean>)projectHasKotlinPlugin2, (Provider<Boolean>)projectHasAndroidPlugin2);
    }

    public static final /* synthetic */ void access$detectJavaToolchainVersion(JavaAdapter $this, DokkaExtension dokkaExtension2, JavaPluginExtension java) {
        $this.detectJavaToolchainVersion(dokkaExtension2, java);
    }

    public static final /* synthetic */ Provider access$isConflictingPluginPresent(JavaAdapter $this, Project project) {
        return $this.isConflictingPluginPresent(project);
    }

    public static final /* synthetic */ void access$registerDokkaSourceSets(JavaAdapter $this, DokkaExtension dokkaExtension2, SourceSetContainer sourceSets, Provider isConflictingPluginPresent2) {
        $this.registerDokkaSourceSets(dokkaExtension2, sourceSets, (Provider<Boolean>)isConflictingPluginPresent2);
    }

    public static final /* synthetic */ void access$register(JavaAdapter $this, NamedDomainObjectContainer dokkaSourceSets2, SourceSet src, Provider isConflictingPluginPresent2) {
        $this.register((NamedDomainObjectContainer<DokkaSourceSetSpec>)dokkaSourceSets2, src, (Provider<Boolean>)isConflictingPluginPresent2);
    }

    public static final /* synthetic */ ProviderFactory access$getProviders$p(JavaAdapter $this) {
        return $this.providers;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/dokka/gradle/adapters/JavaAdapter$Companion;", "", "()V", "isPublished", "", "Lorg/gradle/api/tasks/SourceSet;", "dokka-gradle-plugin"})
    @InternalDokkaGradlePluginApi
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPublished(@NotNull SourceSet $this$isPublished) {
            Intrinsics.checkNotNullParameter((Object)$this$isPublished, (String)"<this>");
            if (Intrinsics.areEqual((Object)$this$isPublished.getName(), (Object)"test")) return false;
            String string = $this$isPublished.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"main", (boolean)false, (int)2, null)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

